#include <stdio.h>

void
setenv (name, value, overwrite)
char *name;
char *value;
int overwrite;
{
    extern char **environ;
    static char **new_environ = NULL;
    int slot;
    int nameLength;
    int valueLength;
    char *dst;

    if ((nameLength = strlen (name)) == 0)
	return;
    if (name[nameLength-1] == '=')
	--nameLength;

    if (*value == '=')
	++value;
    valueLength = strlen (value);

    /*
     * find name in current environment
     */
    for (slot = 0; environ[slot] != NULL; ++slot) {
	if (strncmp (name, environ[slot], nameLength) == 0) {
	    if (overwrite) {
		if (strlen (environ[slot] + nameLength + 1) >= valueLength) {
		    /* enough room there already...just copy over old value */
		    strcpy (environ[slot] + nameLength + 1, value);
		    return;
		}
		goto add_entry;	/* NB:  slot == where to add entry */
	    }
	    else
		return;
	}
    }
    /*
     * not found -- allocate new environment and copy
     * If new_environ is non-NULL, it means we have already alloced an
     * environment.  If that is the same as the current value of environ,
     * we know it is from heap space and can use realloc.  Otherwise,
     * malloc a new one to be sure.
     */
    if (new_environ == environ) {
	new_environ = (char **) realloc ((char *) environ,
					 (slot + 2) * sizeof (char *));
	new_environ[slot + 1] = NULL;
    }
    else {
	new_environ = (char **) malloc ((slot + 2) * sizeof (char *));
	new_environ[slot + 1] = NULL;
	for (slot = 0; environ[slot] != NULL; ++slot)
	    new_environ[slot] = environ[slot];
    }
    environ = new_environ;
    /* fall through to... */
 add_entry:
    /* allocate enuf space for (NAME + '=' + VALUE + '\0') */
    environ[slot] = (char *) malloc (nameLength + 1 + valueLength + 1);
    dst = environ[slot];
    while (*name) {
	if (*name == '=')
	    break;
	*dst++ = *name++;
    }
    *dst++ = '=';
    while (*dst++ = *value++);
}
