/***********************************************************************
 *                                                                     *
 *                                 stat                                *
 *                                                                     *
 ***********************************************************************/

#include <sys/stat.h>

/*
 * some systems don't define the S_ISxxx macros, while others
 * (POSIX compliant) define ONLY these macros.  This code is
 * supposed to define the macros if they are missing.
 * Some systems don't support FIFOs, SOCKETs, or SYMLINKs, so
 * we define dummy S_ISxxx macros for these which are always false.
 */

#ifndef S_ISBLK
#define S_ISBLK(m) (((m) & S_IFMT) == S_IFBLK)
#endif

#ifndef S_ISCHR
#define S_ISCHR(m) (((m) & S_IFMT) == S_IFCHR)
#endif

#ifndef S_ISDIR
#define S_ISDIR(m) (((m) & S_IFMT) == S_IFDIR)
#endif

#ifndef S_ISFIFO
#ifdef S_IFIFO
#define S_ISFIFO(m) (((m) & S_IFMT) == S_IFIFO)
#else
#define S_ISFIFO(m) 0			/* never true */
#endif
#endif

#ifndef S_ISLNK
#ifdef S_IFLNK
#define S_ISLNK(m) (((m) & S_IFMT) == S_IFLNK)
#else
#define S_ISLNK(m) 0			/* never true */
#endif
#endif

#ifndef S_ISREG
#define S_ISREG(m) (((m) & S_IFMT) == S_IFREG)
#endif

#ifndef S_ISSOCK
#ifdef S_IFSOCK
#define S_ISSOCK(m) (((m) & S_IFMT) == S_IFSOCK)
#else
#define S_ISSOCK(m) 0			/* never true */
#endif
#endif
