
/* f is the function to be integrated. */

static double f(x)
   double x;
{
   return 1.0/x;
}


/* Integrate f from a to b using n (actually n+2 function evaluations.
 *   This is not really a good way to integrate, but its only an
 *   example.
 */

double simp(a, b, n)
   double a;
   double b;
   int n;
{
   double h, half, hov2, s, x;
   int nm1, i;

   if (n < 3) n = 3;

   h = (b - a)/n;
   hov2 = h/2.0;
   s = 0.0;
   half = f(a + hov2);
   nm1 = n - 1;

   for (i = 1; i <= nm1; i++) {
      x = a+ i*h;
      s = s + f(x);
      half = half + f(x + hov2);
   }

   s = (h/6.0)*(f(a) + 4.0*half + 2.0*s + f(b));

   return s;
}
