#include <stdio.h>
#include <sys/param.h>
#define INITENG     2.0     /* gamma */
#define CAVILEN     1000.0   /* cavity length in unit of radiation wavelength */
#define NUMPART     2000    /* the number of test particles */
#define STEP        0.005
#define OFFSET      1.303   /* the detuning factor */
#define TWOPI       6.28318530717959
#define gam(beta)   (1.0/sqrt(1.0 - beta*beta))
#define beta(gam)   sqrt(1.0-1.0/(gam*gam))
#define sepx(b,bp)  ((*kL)*((1.0-bp*b)/sqrt(1.0-b*b)-sqrt(1.0-bp*bp)))

void output(trap, step, dgam, numpoints)
double trap, step, dgam[];
int    numpoints;
{
    int   i;
    FILE  *fp;

    if ((fp = fopen("hdata", "w")) == NULL) {
        perror("Can't open file hdata");
        exit(-1);
    }
    for (i = 0;  i < numpoints; i++)
        fprintf(fp, "%0.4g  %0.4g\n",trap+(double)i*step,dgam[i]/(INITENG-1.0));
    fclose(fp);
}
