#include <stdio.h>
#include <math.h>
#define INITENG     2.0     /* gamma */
#define CAVILEN     1000.0   /* cavity length in unit of radiation wavelength */
#define NUMPART     2000    /* the number of test particles */
#define STEP        0.005
#define OFFSET      1.303   /* the detuning factor */
#define TWOPI       6.28318530717959
#define gam(beta)   (1.0/sqrt(1.0 - beta*beta))
#define beta(gam)   sqrt(1.0-1.0/(gam*gam))
#define sepx(b,bp)  ((*kL)*((1.0-bp*b)/sqrt(1.0-b*b)-sqrt(1.0-bp*bp)))


init(trap, step, beta0, betap, kL, numpoints)
double  *trap, *step;
double  *beta0, *betap, *kL;
int     numpoints;
{
    register int  i;
    double        g0, maxE;

    /* constants */
    *beta0 = sqrt(1.0 - 1.0/(INITENG*INITENG));
    *kL = TWOPI*CAVILEN;
    *betap = *beta0*(1.0 - 2.0*OFFSET/(*kL));
    g0 = *kL/(INITENG*INITENG*INITENG*(*beta0)*(*beta0));
    *trap = 0.5*sepx((*beta0), (*betap));
    maxE = 80.0/g0;
    *step = maxE/(double)numpoints;
}
