#include <math.h>
#define INITENG     2.0     /* gamma */
#define CAVILEN     1000.0   /* cavity length in unit of radiation wavelength */
#define NUMPART     2000    /* the number of test particles */
#define STEP        0.005
#define OFFSET      1.303   /* the detuning factor */
#define TWOPI       6.28318530717959
#define gam(beta)   (1.0/sqrt(1.0 - beta*beta))
#define beta(gam)   sqrt(1.0-1.0/(gam*gam))
#define sepx(b,bp)  ((*kL)*((1.0-bp*b)/sqrt(1.0-b*b)-sqrt(1.0-bp*bp)))

double engLost(field, beta0, betap, kL)
double  field, beta0, betap, kL;
{
    register int  i;
    double        gamma[NUMPART], phi[NUMPART];
    double        dphi, gamsum, z, dz;

    /* initialization */
    dphi = TWOPI/(double)NUMPART;
    for (i = 0; i < NUMPART; i++) {
        gamma[i] = gam(beta0);
        phi[i] = i*dphi;
    }

    /* now do the integration */
    dz = STEP;
    for (z = 0.0; z < 1.0; z += dz) {
        for (i = 0; i < NUMPART; i++) {
            gamma[i] -= field*sin(phi[i])*dz;
            phi[i] += kL*(1.0-betap/beta(gamma[i]))*dz;
        }
    }
    gamsum = 0.0;
    for (i = 0; i < NUMPART; i++)
        gamsum += gamma[i];
    return (INITENG-gamsum/(double)NUMPART);
}
