#include <stdio.h>

/* The following macro depends on the variables a and nca */
#define A(i,j) (*(a + (i)*nca + (j)))

void
initb(n, a, b)
int     n;
double  *a, *b;
{
    int  i, j, nca = n;

    for (i = 0; i < n; i++) {
        b[i] = 0.0;
        for (j = 0; j < n; j++)
            b[i] += A(i,j)*j;
    }
}

void
initarray(n, a, a1, b)
int    n;
double *a, *a1, b[];
{

    double *_a;
    int i, j;
    int nca = n;
    FILE *fp;

    _a = (double *)malloc(n * n * sizeof(double));

    fp = fopen("lu.output", "w");
    fprintf(fp, "%d\n", n); fflush(fp);

    for(i = 0; i < n; i++) {
	for(j = 0; j < n; j++) {
	    A(i, j) =
              ((random() % 0x7fffffff) / (double)(unsigned)0x7fffffff)*100;
            fprintf(fp, "%f ", A(i,j));
	}
        fprintf(fp,"\n");
    }
    bcopy(a, a1, n*n*sizeof(double));
    initb(n, a, b);
    for (i = 0; i < n; i++) fprintf(fp, "%f ", b[i]);
    fprintf(fp, "\n********\n");
    fclose(fp);
}
