PROGRAM sample3
! Section 3.3 of the manual "Computer Graphics PLOTTER"
! Sample 3: A parallel plate condenser. 
IMPLICIT NONE
REAL:: aa,x1,y1,dx(8),dy(8),hs,x5,x10,x11,y10,y12
! A setting of Plotter
CALL pfnbegin('sample3')
CALL pfsorigin(105.,150.)
CALL pcsheight(4.)
! Parallel plates
CALL plswidth(.2);  hs=40;  x5=12
CALL pldsgmnt(-x5,0.,-x5,hs)
CALL pldsgmnt(x5,0.,x5,hs)
! The left side hatching, -sigma
CALL plswidth(.1);  aa=5.
dx=0
dx(1)=0.;   dx(2)=0.;   dx(3)=aa;   dx(4)=aa
dy(1)=0.;   dy(2)=hs;   dy(3)=hs;   dy(4)=0.
dx=dx+x5
CALL pldhatching(4,dx,dy,1.,0.78)
y1=14;  x1=2
CALL pfscolor(100.,100.,100.)
CALL prprctgl(x5+x1,y1,x5+8.,y1+6)
CALL pfscolor(0.,0.,0.)
CALL pcspstn(0,1);  CALL pcwrite(x5+x1+0.5,y1+3,'\f10}-\s3}s')
! The right side hatching, +sigma
dx=-dx
CALL pldhatching(4,dx,dy,1.,0.78)
CALL pfscolor(100.,100.,100.)
CALL prprctgl(-x5-8.,y1,-x5-x1,y1+6)
CALL pfscolor(0.,0.,0.)
CALL pcspstn(2,1);  CALL pcwrite(-x5-x1-1,y1+3,'\f3}+\f10}\s1}s')
! Electric field E
x10=2;  x11=x5-2;  y10=20.
CALL pldsgmnt(-x5+2,y10,x5-2,y10);  CALL pldarrow(x10,y10,x11,y10)
CALL pcspstn(1,-1)
CALL pcwrite(0.,y10+.5,'\f3}E')
! epsilon_0
CALL pcwrite(0.,35.,'\f10}e\f1}\l}0\e}')
! Dimension d
y12=-8
CALL pldsgmnt(-x5,y12-2,-x5,-1.);  CALL pldsgmnt(x5,y12-2,x5,-1.)
CALL pldsgmnt( x5,y12, 3.,y12);    CALL pldarrow(0.,y12, x5,y12)
CALL pldsgmnt(-x5,y12,-3.,y12);    CALL pldarrow(0.,y12,-x5,y12)
CALL pcspstn(1,1)
CALL pcwrite(0.,y12,'\f3}d')
! Sample 3
CALL pfsorigin(0.,0.);  CALL pcspstn(1,0)
CALL pcwrite(105.,270.,'\f1}Sample 3')
CALL pfnend
END PROGRAM sample3
