#define CRAYTRACE 1
static char USMID[] = "@(#)rawdump.c	1.1 10/16/90 11:04:00 LLNL ";
#include <stdio.h>
#include "defines.h"
#include "log_entry.h"
#include <fcntl.h>

struct log_entry_templet le;
int gink[NB_THEADER];



/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

struct event {
	char *ename;
	int  enume;
} etable[] = {
	"START",	  0,	  /* TSKST - Start Task */
	"COMPLETED",	  1,	  /* TSKCM - Complete Task */
	"TNWAIT",	  2,	  /* TSKWT - TSKWAIT, nowait */
	"TWAIT",	  3,	  /* TSKWTB - begin wait for task */
	"TRESUME",	  4,	  /* TSKWTE - run after wait for task */
	"TTEST",	  5,	  /* TSKTST - test task */

	"LASSIGN",	  6,	  /* LCKASN - assign lock */
	"LRELEASE",	  7,	  /* LCKREL - release lock */
	"LNWAIT",	  8,	  /* LCKSET - set lock */
	"LWAIT",	  9,	  /* LCKWTB - begin wait to set lock */
	"LRESUME",	 10,	  /* LCKWTE - run after wait for lock */
	"LCLEAR",	 11,	  /* LCKCLR - clear lock */
	"LTEST",	 12,	  /* LCKTST - test lock */

	"EASSIGN",	 13,	  /* EVASGN - assign event */
	"ERELEASE",	 14,	  /* EVREL - release event */
	"EPOST",	 15,	  /* EVPOST - post event */
	"ECLEAR",	 16,	  /* EVCLR - clear event */
	"ENWAIT",	 17,	  /* EVWAIT - EVWAIT, no wait */
	"EWAIT",	 18,	  /* EVWTB - begin wait for event */
	"ERESUME",	 19,	  /* EVWTE - run after wait for event */
	"ETEST",	 20,	  /* EVTEST - test event */

	"BIND",		 21,	  /* CPUATT - attach to logical CPU */
	"UNBIND",	 22,	  /* CPUDET - detach from logical CPU */
	"REQUEST",	 23,	  /* CPUREQ - request a logical CPU */
	"REQUEST_NA",	 24,	  /* CPUREQ+1 - COS only - no-abort on CPUREQ */
	"ACQUIRE",	 25,	  /* CPUACQ - acquire a logical CPU */
	"RELEASE",	 26,	  /* CPUDEL - release a logical CPU */
	"RELEASE_NA",	 27,	  /* CPUDEL+1 - COS only - no-abort on CPUDEL */
	"SUSPEND",	 28,	  /* CPUSUS - suspend a logical CPU */
	"SUSPEND_NA",	 29,	  /* CPUSUS+1 - COS only - no-abort on CPUSUS */
	"REQSUS",	 30,	  /* CPUACT - activate a logical CPU */
	"REQSUS_NA",	 31,	  /* CPUACT+1 - COS only - no-abort on CPUACT */
	"IDLE",		 32,	  /* CPUHLD - delay a logical CPU */

	"BASSIGN",	 33,	  /* BRASGN - assign a barrier */
	"BRELEASE",	 34,	  /* BRREL - release a barrier */
	"BNWAIT",	 35,	  /* BRSYNC - sync at a barrier, no wait */
	"BWAIT",	 36,	  /* BRWTB - barrier sync, start wait */
	"BRESUME",	 37,	  /* BRWTE - barrier sync, end wait */

	"MSTARTF",	  65,	  /* Master Starts Fray */
	"MWAITF",	  66,	  /* Master Waits for Fray Done */
	"MRESUMEF",	  67,	  /* Master Resumes after Fray */
	"SSTARTF",	  68,	  /* Slave Starts Fray */
	"SEXIT",	  69,	  /* Slave Exits */
	"CSWAIT",	  70,	  /* Wait for Control Structure Done */
	"CSRESUME",	  71,	  /* Resume after Control Structure */

	"GNWAIT",	 256,	  /* Wait for Guard N */
	"GNRESUME",	 257,	  /* Resume after Guard N */
	"GWAIT",	 258,	  /* Wait for Guard */
	"GRESUME",	 259,	  /* Resume after Guard */
	"SINIT",	 260,	  /* Initialize Slaves */

	"CSNWAIT",	 265,	  /* No Wait for Control Structure */
	"SWAITW",	 267,	  /* Slave Waits For Work */

	"RECOVER",	 32767,	  /* not used */
	"LIGHT",	 32766,	  /* not used */
	"REACQUIRE",	 32765,	  /* not used */

	"LOST",		1023,	  /* Logging items lost */
	"UNDEFINED",	 9999	   /* NO DEFINITION EXIST FOR THIS ACTION # */
};


main(argc, argv)
int argc;
char *argv[];
{
	int i=0;
	int rawmode = 0;
	int fd, nb; 
	int lcnt = 0;		/* line counter */
	char tracefile[20];


	if (argc <= 1) {
		fprintf(stderr, "Cannot open tracefile\n");
		fprintf(stderr,"usage: rawdump [-r] tracefile\n");
		exit(-1);
	}
	if( argc == 3 )
	{
		if( strcmp(argv[1],"-r") != 0 )
		{
			fprintf(stderr, "Invalid option %s\n", argv[1]);
			fprintf(stderr,"usage: rawdump [-r] tracefile\n");
			exit(-1);
		}
		rawmode = 1;
		strcpy(tracefile,argv[2]);
	} else
	{
		strcpy(tracefile,argv[1]);
	}

	if ((fd = open(tracefile,O_RDONLY)) < 0) {
		fprintf(stderr,"cannot open %s\n",argv[1]);
		exit(1);
	}

	read(fd, (char *)gink, NB_THEADER);
	if( gink[0] == 2176 )
	{
		printf("New COS 1.17 BB format.\n");
	} else
	{
		printf("UNICOS or New COS 1.17 OB format.\n");
	}
	nb = sizeof(struct log_entry_templet);
	nb = 32;
	fprintf(stderr, "nb = (%d)\n", nb);
	while ((nb = read(fd, (char *)&le, nb)) > 0)
	{
		if( rawmode > 0 )
		{
			if( (lcnt % 20) == 0 )
			{
				printf("\t	actno\t	 tid	   clock      user\n");
				printf("\t	-----\t	 ---	   -----      ----\n");
			}
		} else
		{
			if( (lcnt % 20 ) == 0 )
			{
				printf("\t     action\t actno\t	 tid	   clock      user\n");
				printf("\t     ------\t -----\t	 ---	   -----      ----\n");
			}
		}
		i = 0; 
		while(etable[i].enume != 9999)
		{
			if( etable[i].enume == le.actno )
			{
				break;
			}	
			i++;
		}
		if( rawmode > 0 )
		{
			printf("\t%11d	%8d %11d %11d\n",le.actno,
				le.tid, le.clock, le.lo_user);
		} else
		{
			printf("\t%12s %8d %8d %11d %11d\n", etable[i].ename, 
				le.actno, le.tid, le.clock, le.lo_user);
		}
		lcnt++;
	}
}
