static char USMID[] = "@(#)key.c	1.1 10/16/90 11:03:44 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include "externvars.h"

/*************************************************************
 * This file contains the routines to bring up a window 
 * containing a key to the various symbols used by GMAT
 * timeline.
 *              WIN_WIDTH,              420,
 *            WIN_HEIGHT,               740,
 **************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,    */
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.     */
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

struct pixfont *node_font;

extern Pixwin *kpw;
extern Frame popup_key_frame;

/* read the images into the pixrect structures */
    
short im_dotted[] = {
#include "icons/dotted.line"
};
mpr_static(dotted,16,16,1,im_dotted);
short im_light[] = {
#include "icons/light.box"
};
mpr_static(lightbox,RECTX,RECTY,1,im_light);
short im_start[] = {
#include "icons/start.box"
};
mpr_static(startbox,RECTX,RECTY,1,im_start);
short im_complete[] = {
#include "icons/complete.box"
};
mpr_static(completebox, RECTX,RECTY,1,im_complete);
short im_recover[] = {
#include "icons/recover.box"
};
mpr_static(recoverbox,RECTX,RECTY,1,im_recover);
short im_blank[] = {
#include "icons/blank.box"
};
mpr_static(blankbox,RECTX,RECTY,1,im_blank);
short im_empty[] = {
#include "icons/template.box"
};
mpr_static(emptybox,RECTX,RECTY,1,im_empty);
short im_punbind[] = {
#include "icons/punbind.icon"
};
mpr_static(punbind,PROCDIM,PROCDIM,1,im_punbind);
short im_pidle[] = {
#include "icons/pidle.icon"
};
mpr_static(pidle,PROCDIM,PROCDIM,1,im_pidle);
short im_psuspend[] = {
#include "icons/psuspnd.icon"
};
mpr_static(psuspend,PROCDIM,PROCDIM,1,im_psuspend);
short im_preacq[] = {
#include "icons/preacq.icon"
};
mpr_static(preacq,PROCDIM,PROCDIM,1,im_preacq);
short im_pbind[] = {
#include "icons/pbind.icon"
};
mpr_static(pbind,PROCDIM,PROCDIM,1,im_pbind);

prepare_key()
{
    char str[40];

    struct pixfont *font;

    window_set(popup_key_frame,WIN_SHOW,FALSE,0);
    
    font = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.b.14");
    pw_text(kpw,130,15,PIX_SRC,font,"Key to GMAT Symbols");

    pw_vector(kpw,80,          30,     80,          30+15,   PIX_SET,1);
    pw_text  (kpw,80 + 45,     30 + 10,                      PIX_SRC,0,"Task is ready to run");

    pw_vector(kpw,80,          45,     80,          45+15,   PIX_SET,1);
    pw_vector(kpw,80 - LINESEP,45,     80 - LINESEP,45+15,   PIX_SET,1);
    pw_vector(kpw,80 + LINESEP,45,     80 + LINESEP,45+15,   PIX_SET,1);
    pw_text  (kpw,80 + 45,     45+10,                        PIX_SRC,0,"Task is running");

    pw_rop   (kpw,80,          60,                           16,16,PIX_SRC,&dotted,0,0);
    pw_text  (kpw,80 + 45,     60+10,                        PIX_SRC,0,"Task is waiting");

    pw_rop   (kpw,80,          75,                          16,16, PIX_SRC,&dotted,0,0);
    pw_vector(kpw,80 - LINESEP,75,    80 - LINESEP,75+15,  PIX_SET,1);
    pw_vector(kpw,80 + LINESEP,75,    80 + LINESEP,75+15,  PIX_SET,1);
    pw_text  (kpw,80 + 45,     75+10,                      PIX_SRC,0,"Task is waiting and bound");

/* primary canvas nodes */
     pw_rop(kpw,50,   120,   RECTX,RECTY,PIX_SRC | PIX_DST,&lightbox,0,0);
    pw_text(kpw,50+75,120+11,PIX_SRC | PIX_DST,0,"And Then There Was Light ...");

     pw_rop(kpw,50,   140,   RECTX,RECTY,PIX_SRC | PIX_DST,&startbox,0,0);
    pw_text(kpw,50+46,140+11,PIX_SRC | PIX_DST,node_font,"N");
    pw_text(kpw,50+75,140+11,PIX_SRC | PIX_DST,0,"Task N has been started");

     pw_rop(kpw,50,   160,   RECTX,RECTY,PIX_SRC | PIX_DST,&completebox,0,0);
    pw_text(kpw,50+75,160+11,PIX_SRC | PIX_DST,0,"Task is completed");

     pw_rop(kpw,50,   180,   RECTX,RECTY,PIX_SRC | PIX_DST,&recoverbox,0,0);
    pw_text(kpw,50+75,180+11,PIX_SRC | PIX_DST,0,"Task has been recovered");

     pw_rop(kpw,50,   200,   RECTX,RECTY,PIX_SRC | PIX_DST,&blankbox,0,0);
    pw_text(kpw,50+75,200+11,PIX_SRC | PIX_DST,0,"Task has posted action number N");
    pw_text(kpw,50+25,200+11,PIX_SRC | PIX_DST,0,"N");

     pw_rop(kpw,50,   220,   RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
    pw_text(kpw,50+75,220+11,PIX_SRC | PIX_DST,0,"Identifier STR posted, with data X");
    pw_text(kpw,50+10,220+11,PIX_SRC | PIX_DST,node_font,"STR: X");

    pw_text(kpw,10,260+11,PIX_SRC,0,"AsB:    Assign Barrier");
    pw_text(kpw,10,280+11,PIX_SRC,0,"AsE:    Assign Event");
    pw_text(kpw,10,300+11,PIX_SRC,0,"AsL:    Assign Lock ");
    pw_text(kpw,10,320+11,PIX_SRC,0,"ClE:    Clear Event");
    pw_text(kpw,10,340+11,PIX_SRC,0,"ClL:    Clear Lock");
    pw_text(kpw,10,360+11,PIX_SRC,0,"ExitS:  Slave Exits");
    pw_text(kpw,10,380+11,PIX_SRC,0,"MstF:   Master Starts Fray");
    pw_text(kpw,10,400+11,PIX_SRC,0,"MwaitF: Master Waits on Fray");
    pw_text(kpw,10,420+11,PIX_SRC,0,"NWB:    No Wait on Barrier");
    pw_text(kpw,10,440+11,PIX_SRC,0,"NWCS:   No Wait on CntrlStrctr");
    pw_text(kpw,10,460+11,PIX_SRC,0,"NWE:    No Wait on Event");
    pw_text(kpw,10,480+11,PIX_SRC,0,"NWL:    No Wait on Lock");
    pw_text(kpw,10,500+11,PIX_SRC,0,"NWT:    No Wait on Task");
    pw_text(kpw,10,520+11,PIX_SRC,0,"PsE:    Post Event");
    pw_text(kpw,10,540+11,PIX_SRC,0,"ReqPro  Request Process");
    pw_text(kpw,10,560+11,PIX_SRC,0,"RlB:    Release Barrier");

    pw_text(kpw,230,260+11,PIX_SRC,0,"RlE:    Release Event");
    pw_text(kpw,230,280+11,PIX_SRC,0,"RlL:    Release Lock");
    pw_text(kpw,230,300+11,PIX_SRC,0,"RESUME  Resume");
    pw_text(kpw,230,320+11,PIX_SRC,0,"SINIT   Initialize Slaves");
    pw_text(kpw,230,340+11,PIX_SRC,0,"TsE:    Test Event");
    pw_text(kpw,230,360+11,PIX_SRC,0,"TsL:    Test Lock");
    pw_text(kpw,230,380+11,PIX_SRC,0,"TsT:    Test Task");
    pw_text(kpw,230,400+11,PIX_SRC,0,"WE:     Wait on Event");
    pw_text(kpw,230,420+11,PIX_SRC,0,"WB:     Wait on Barrier");
    pw_text(kpw,230,440+11,PIX_SRC,0,"WL:     Wait on Lock");
    pw_text(kpw,230,460+11,PIX_SRC,0,"WG:     Wait on Guard");
    pw_text(kpw,230,480+11,PIX_SRC,0,"WGN:    Wait on Guard N");
    pw_text(kpw,230,500+11,PIX_SRC,0,"WT:     Wait on Task");
    pw_text(kpw,230,520+11,PIX_SRC,0,"WaitCS  Wait on CntrlStrctr");
    pw_text(kpw,230,540+11,PIX_SRC,0,"SWait   Slave Waits for Work");
    pw_text(kpw,230,560+11,PIX_SRC,0,"StartF  Slave Starts Fray");


/* process icons */
    pw_rop (kpw,10,    575,   48,48,PIX_NOT(PIX_SRC),&pbind,0,0);
    pw_text(kpw,10+50, 575+25,PIX_SRC,0,"process is bound");

    pw_rop (kpw,10,    620,   PROCDIM,PROCDIM,PIX_SRC,&psuspend,0,0);
    pw_text(kpw,10+50, 620+25,PIX_SRC,0,"process is suspended");

    pw_rop (kpw,10,    665,   PROCDIM,PROCDIM,PIX_SRC,&punbind,0,0);
    pw_text(kpw,10+50, 665+25,PIX_SRC,0,"process is unbound");

    pw_rop (kpw,210,   575,   PROCDIM,PROCDIM,PIX_SRC,&pidle,0,0);
    pw_text(kpw,210+50,575+25,PIX_SRC,0,"process is idle");

    pw_rop (kpw,210,   620   ,PROCDIM,PROCDIM,PIX_SRC,&preacq,0,0);
    pw_text(kpw,210+50,620+25,PIX_SRC,0,"process is reacquired");
}
#endif
