static char USMID[] = "@(#)driver.c	1.2 10/22/90 13:16:53 LLNL ";
#include <stdio.h>
#include <math.h>

#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/canvas.h>
#include <suntool/textsw.h>
#include <suntool/scrollbar.h>
#endif

#include "externvars.h"
/*#include "defines.h"*/
#ifdef X11
#include "xexterns.h"
#endif


/* ********************************************************************** */
/*                                                                        */
/*              GMAT -- Graphical Multiprocessing Analysis Tool           */
/*                                                                        */
/****************************************************************************
This is a new release of GMAT that includes both an X-window implementation
and a Sunview implementation.  The conversion from Sunview to X-windows was
done by CRI while participating in a collaborative effort with LLNL.  
They have subsequently granted to LLNL :
 "a non-exclusive, perpetual, royalty-free, worldwide license to
use, copy, modify, translate and distribute this software." 
They also disclaim any responsibility for the correct performance of the 
software or any subsequent version distributed by LLNL.                                     							           */
/**************************************************************************/


/* ********************************************************************** */
/* This file contains the driver for the gmat timeline tool.              */
/* It defines all the global variables and contains and enters into       */
/* window_main_loop() so that the SunView *Notifier* can schedule events. */
/* This type of scheduling reduces the CPU load.                          *
 * Initial Release
 * 
 * ********************************************************************** */
/*                                                                        */
/*  Please direct comments or interesting usage reports to:               */
/*                                                                        */
/*              GMAT Tool                                                 */
/*              User Systems Division, Computation Dept.                  */
/*              Lawrence Livermore National Laboratory                    */
/*              P.O. Box 808, L300                                       */
/*              Livermore, CA  94550                                      */
/*                                                                        */
/*   Active development  on this product  has stopped, therefore there    */
/*	is no longer support for bugfixes or enhancements.		  */
/*                                                              	  */
/*                                                                        */
/*                              ACKNOWLEDGEMENTS                          */
/*                                                                        */
/*  This tool was initially developed by Susan Campbell, Scott Sikora,    */
/*  Mark Seager and Robert Strout during the summer of 1987, at Lawrence  */
/*  Livermore National Laboratory, working with additional guidance and   */
/*  help from Mary Zosel, Nancy Werner, and Bruce Kelly.                  */
/*									  */
/*  Later enhancements were done by Nancy Werner. After CRI converted     */
/*  GMAT to X-windows (Athena widget set), Nancy tested this version,     */
/*  made some minor bug fixes and put it under SCCS code control in 10/90.*/
/*									  */
/*                                                                        */
/*  The tool was inspired by the MAT (Multitasking Analysis Tool)         */
/*  developed at LLNL for the Cray supercomputers.  The desire to supply  */
/*  a graphical interface for MAT was heightened by the appearance of the */
/*  Schedule display tool developed at Argonne National Laboratory by     */
/*  J. Dongarra and D. Sorenson.  It was from this tool that we began our */
/*  development.  Though only two routines from that tool remain in this  */
/*  source, we are very grateful to Dongarra and Sorenson for their       */
/*  support by allowing us access to their source code.  This helped      */
/*  greatly as an example from which we could learn how to use the        */
/*  SunView windowing system, and in turn greatly accelerated our         */
/*  development effort.                                                   */
/*                                                                        */
/*  The multiprocessing event data that is generated for MAT and GMAT is  */
/*  patterned after a similar tool designed by Cray Research, Inc. and    */
/*  called MTDUMP.  The format of the event data, library routines to     */
/*  collect the data on the Livermore Computer Center's (LCC) X-MP        */
/*  multiprocessing machines (NLTSS system), and the MAT tool that        */
/*  produces an ascii display of the data were designed and implemented   */
/*  by Bruce Kelly and Robert Strout.  The microtasking mechanism         */
/*  supported at LCC was modified to produce trace information by Nancy   */
/*  Werner.  Additionally, Mark Seager has produced a Cray multitasking   */
/*  compatibility library to provide a multitasking capability and to     */
/*  generate the trace data on an Alliant FX/8.                           */
/*                                                                        */
/* ********************************************************************** */

/* ********************************************************************** */
/*                                                                        */
/* (c) Copyright 1987 by the Regents of the University of California.     */
/*  All rights reserved.  This work was produced under the sponsorship of */
/*  the U.S.Department of Energy.  The Government retains certain rights  */
/*  therein.                                                              */
/*                                                                        */
/*                               Notice                                   */
/*      This computer code material was prepared as an account of work    */
/*      sponsored by the United States Government. Neither the United     */
/*      States nor the United States Department of Energy, nor any of     */
/*      their employees, nor any of their contractors, subcontractors,    */
/*      or their employees, makes any warranty, express or implied, or    */
/*      assumes any legal liability or responsibility for the accuracy,   */
/*      completeness or usefulness of any information, apparatus,         */
/*      product or process disclosed, or represents that its use would    */
/*      not infringe privately-owned rights.                              */
/*                                                                        */
/*                                                                        */
/* ********************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

/* ********************************************************************** */
/*                                                                        */
/*                               DISCLAIMER                               */
/*                                                                        */
/*                This document was  prepared as an account               */
/*                of work  sponsored  by  an  agency of the               */
/*                United States  Government.   Neither  the               */
/*                United States    Government    nor    the               */
/*                University of California nor any of their               */
/*                employees, makes any warranty, express or               */
/*                implied, or assumes  any  legal liability               */
/*                or responsibility   for   the   accuracy,               */
/*                completeness or   usefulness    of    any               */
/*                information, apparatus,     product    or               */
/*                process disclosed, or represents that its               */
/*                use would  not  infringe  privately owned               */
/*                rights.  Reference herein to any specific               */
/*                commercial products,  process, or service               */
/*                by trade name,  trademark,  manufacturer,               */
/*                or otherwise,    does   not   necessarily               */
/*                constitute or  imply   its   endorsement,               */
/*                recommendation, or favoring by the United               */
/*                States Government  or the  University  of               */
/*                California.  The  views  and  opinions of               */
/*                authors expressed    herein     do    not               */
/*                necessarily state or reflect those of the               */
/*                United States  Government   thereof,  and               */
/*                shall not  be  used  for  advertising  or               */
/*                product endorsement purposes.                           */
/*                                                                        */
/*                Work performed under  the auspices of the               */
/*                U.S. Department of   Energy  by  Lawrence               */
/*                Livermore National    Laboratory    under               */
/*                contract number W-7405-Eng-48.                          */
/*                                                                        */
/* ********************************************************************** */

/* Global Variable Definitions */
#include "check_init.h"         /* action versus name table */
double curr_clock, last_clock;/* check that logging events in order */
double idle_interval;   /* check task not  in CPU */
int filter_display,event_error, error_count, curr_cs, curr_owner; /* filtering */
int direction;                  /* if jump direction = 0: forward */
int initflag;                   /* filter init flag */
int first_box = 1;              /* to draw first box to be erased */
int dt_index;                   /* offset into cd table below   */
                                /* to get name of directory     */
char *directory_table[128];     /* table of filenames notice hard
                                   coded max */
int ft_index;                   /* offset into file table below */
                                /* to get name of trace file    */
int ft_val;                     /* offset combined with ft_index.*/
char *file_table[128];          /* table of filenames notice hard
                                   coded max */
int key_enable = 1;             /* used to determine if the key can
                                   be brought up in dynamic mode */
int go, filepresent;
int e_speed;
int display_type;               /* 0=lock, 1=event, 2=barrier */
int histx, histy;               /* Last x,y plotted in histogram */
int histogram_wrap = 0;         /* Number of times histogram has wrapped */
int oldx,oldy;                  /* coords of old view box  */
int choice[6];                  /* user-defined significant action numbers */
int leftid;                     /* node id of left mse bttn, -1 == invalid node */
int ypos;                       /* global y position, according to event number */
int blank_intervals;            /* Number of current blank_intervals */
double aux_data[7];             /* all possible auxiliary data */
struct screen_struct screen[MAXCOLUMNS];    /* array of screen columns */

int locks[MAXVALUES+1];         /* array of lock values */
int events[MAXVALUES+1];                /* array of event values */
int barriers[MAXVALUES+1];      /* array of barrier values */

struct task_struct  tasks[MAXTASKS];   /* array of tasks */

struct proc_struct procs[MAXPROCS];    /* array of process structures */
/* global variables to load socket info into */
int curr_id;      /* task id of current task */
int curr_action;  /* action of current task */
int curr_process; /* process of current task */
int curr_events;  /* total number of events processed */
int curr_procs = 0;   /* number of active processes */
int curr_tasks;   /* total number of tasks created */

/* The necessary global clock variables, all double to approx 64 bit words on Cray XMP */
double clock_interval;          /* user-set clock interval */
double update_time;             /* Estimated time to update the screen */
double clock_cycle;             /* One clock cycle, wrt CRAY/ALLIANT */                            
double initial_clock;           /* And then there was light */
double last_real_clock;         /* Last Event Clock */
double real_clock;              /* Event clock */
double program_clock;           /* Clock as to GMAT */
double str_blank_clock;         /* Start of a blank interval (histogram) */
double new_blank_interval;      /* New clock interval during blanks */
int blankx;                     /* Global x position for updating blank intervals */
int clock_error;                /* clock order error variable */

int fp;         /* trace file descriptor */
FILE *df;               /* dump file */

extern char user_act_nam[128][5];       /* user action name table */
extern int user_act_num[128];           /* user action number table */
extern int act_file_present;            /* =# entries if user action file is present */
#ifdef sunview
extern Notify_error notify_dispatch();
extern struct pixfont *node_font;


void load_notify_proc(),
  go_notify_proc(),
  hist_notify_proc(),
  quit_notify_proc(),
  e_speed_notify_proc(),
  step_notify_proc(),
  connect_notify_proc(),
  key_notify_proc(),
  interval_notify_proc(),
  machine_notify_proc(),
  path_notify_proc(),
  directory_notify_proc(),
  handle_pcevent(),
  display_message(),
  plot_histogram(),
  display_notify_proc(),
  interval_notify_proc(),
  machine_notify_proc(),
  file_notify_proc();

Menu action_menu;
Window action_window;
Frame frame,popup_frame,popup_key_frame,misc_frame,popup_panel_frame;
Frame frame,popup_news_frame,confimer;
Panel panel,popup_panel, quit_panel;
Textsw textsw;
Scrollbar pcv_bar;              /* primary canvas scrollbars */
Canvas canvas,pop_canvas,canvas_full,key_canvas,misc_canvas,news_canvas;
Panel_item title, speedometer, event_count, process_count, display_choice,
  go_button, connect_button, load_button, quit_button,
  file_choice, directory_choice, task_count,
  filter_choice, news_button, jump_direction,
  step_button,key_button,histogram_button,jump_button,
  e_speed_slider, clock_interval_slider,jump_choice,jump_text,jump_title,
  jump_cancel_button, jump_execute_button,interval_choice, idle_choice,
  machine_choice, message_item,
  quit_execute_button, quit_cancel_button;

Pixwin *pw,*pw2,*pwf,*kpw, *mpw, *npw;
#endif

#ifdef X11
#define maxArgs 10

Widget frame, panel;
Widget control_widget, message_widget, outer_canvas, inner_canvas;
Widget outer_hist, inner_hist, hist_viewport, hist_shell, filter_shell;
Widget title, hidden_canvas;
Screen *hidden_scr, *canvas_screen, *control_screen, *hist_screen, *key_scr;
Display *hidden_display;
Display *control_display, *hist_display;
Display *display_control, *text_display, *key_display;

Window can_win, hidden_win, control_win, hist_win, text_win;
GC canvas_gc, event_gc, hidden_gc, dotted_gc, control_gc, key_gc;
Widget jump_button, jump_execute_button, jump_cancel_button;
Widget interval_choice, address_choice, address_pop;
Widget dir_label, trace_label, clock_label, machine_label, address_label;
Widget jump_label, jumpto_value, idle_label, filter_label;
Widget file_choice, directory_choice, machine_choice, idle_choice;
Widget display_choice, filter_button;
Widget dir_pop, jump_pop, file_pop, speedometer_label;
Widget dir_shell, jump_shell, file_shell, jumpby_choice;
Widget key_pop, key_shell, address_shell, idle_shell, machine_shell;
Widget interval_shell;
Widget jumpby_buttons, jumpby_shell, jumpby_pop;
Widget jump_direction_shell, jump_direction_pop, jumpDirection_choice;
Widget jump_direction_buttons;
Widget news_widget, news_shell, news_pop, action_shell, action_pop;
Display *canvas_display;

int move_height = 600;
int move_hist   = 700;
char *address_table[] =
{
        "Locks   ", "Events  ", "Barriers", NULL
};
char *idle_table[] =
{
        "10^5  ", "5X10^5", "10^6  ", "5X10^6", "10^7  ", "5X10^7", "10^8  ", "5X10^8", NULL
};
char *interval_table[] =
{
        "10^0", "10^1", "10^2", "10^3", "10^4", "10^5", "10^6", "10^7", NULL
};
char *jumpby_table[] =
{
        "Event Cnt", "Task #   ", "Action # ", NULL
};
char *jump_direction_table[] =
{
        "Forward ", "Backward", "Rewind  ", NULL
};
char *filter_table[] =
{
        "NONE  ", "Micro", "All   ", NULL
};
char *machine_table[] =
{
        "Cray X-MP", "Cray2    ", "Cray Y-MP", NULL
};

#endif

char node_str[40];   /* string containing node text */
char str[80];        /* string containing text */
char dumpfile[80];   /* file to dump socket data to */
int fd;              /* file descriptor of dump file */
int mode;   /* 0 indicates Static Mode, 1 Dynamic Mode */
int done;   /* 0 indicates socket input not done, 1 is done */
int jumpingFLAG = 0;
int rv = 0;

main(argc,argv)
     int argc;
     char **argv;
{
    char program_name[256];
    extern int optind;
    int c;
    int errflg = 0, dflg = 0, sflg = 0;
        extern char *optarg;
        extern int opterr;

#ifdef X11
        /* This is my way of getting whether things are to be reverse videod or
         * not. */
        opterr = 0;
        while ((c = getopt(argc,argv,"r:")) != EOF)
        {
                switch(c)
                {
                        case 'r':
                                if( *optarg == 'v' )
                                {
                                        rv = 1;
                                }
                                break;
                        default:
                                break;
                }
        }
    /* Initialize the toolkit, and create the top-level widget */
    frame = XtInitialize("gmat",    /* application name */
                            "GMAT",        /* application class */
                            NULL,          /* pointer to options */
                            0,             /* number of options */
                            &argc, argv);  /* command line */
#endif

#ifdef CRAYTRACE
    strcpy(program_name,argv[0]);
    while ((c = getopt(argc,argv,"sdW:")) != EOF) {
        switch(c) {
        case 'd':
#ifdef STDERR
                fprintf(stderr,"Dynamic mode not yet supported\n");
#else
                msghan(8,1,NULL);
#endif
                errflg = 1;
                dflg = 1;
                break;
        case 's':
                sflg = 1;
                break;
        case 'W':
                /* pass on to window system */
                break;
        case '?':
        default:
                errflg = 1;
                break;
        }
    }

    if (!sflg && !dflg) { /* default to static mode for now */
        sflg = 1;
    } else if (sflg && dflg) {
        errflg = 1;
    }
    
    if (((argc-optind) > 0) || errflg)
        {
#ifdef STDERR
        fprintf(stderr, "Usage: %s [-s] [-d]\n", program_name);
#else
        msghan(1,1,NULL);
#endif
        exit(1);
    }
#endif CRAYTRACE

    

    update_time = (pow(10.0,-1.0));
    mode = 0;
    filepresent = 0;
#ifdef sunview
    static_init();
#ifdef LLNL     /* CTSSTRACE */
    load_user();
    load_news();
#endif LLNL     /* CTSSTRACE */
    prepare_key();
    initialize();
#endif
#ifdef X11
    if( static_init(&argc,argv) != 0 )
    {
#ifdef STDERR
        fprintf(stderr,"static_init: (%d) Unable to open windows\n");
#else
        msghan(2,1,NULL);
#endif
        exit(-1);
    }
    load_user();
    load_news();
    prepare_key();
    initialize();
#endif
    clock_cycle = (8.5 * pow(10.0,-9.0));               
    go = 0;
#ifdef sunview
    panel_set(machine_choice,PANEL_VALUE,0,0);
    /* write text on textsw and canvas */
    node_font = pf_open("usr/lib/fonts/fixedwidthfonts/screen.b.12");
    display_message("To start: load file, click Go or Step\n");
    pw_text(pw,125,150,PIX_SCR,0,
            "To start load file and click GO or STEP.");
    window_set(frame,WIN_SHOW,TRUE,0);
    /* Turn control over to the SunView *NOTIFIER* */
    window_main_loop(frame);
#endif

#ifdef X11

    display_message("To start: load file, click Go or Step\n");
    /* Wait for something to happen */
    XtMainLoop();
#endif
}

void lookup(action_num,action_nam)
int action_num;
char *action_nam;
{
    static int i;
    /*  get name for specified action */
#ifdef CTSSTRACE
    if(action_num == 0)
    {
        strcpy(action_nam,"NONE");
        return;
    }
#endif
    for (i=0 ; i < MAX_ACTIONS  ; i++)
    {
        if(action_num == action_number[i]) 
        {
            strcpy(action_nam,action_name[i]);
            return;
        }
    }
    for(i=0 ; i < XMAX_ACTIONS ; i++)      
    {
        if(action_num==action_xnumber[i])
        {
            strcpy(action_nam,action_xname[i]);
            return;
        }
    }
#ifdef CTSSTRACE
    if(action_num > 127)
    {
#endif
#ifdef CRAYTRACE
    if (action_num <= BRESUME)
    {
#endif
        sprintf(str,"Action = %d  : ",action_num);
        display_message (str);
        strcpy(action_nam,"Unknown!!");
        return;
    }

    for (i=0; i < act_file_present; i++)
    {
        if(action_num==user_act_num[i])
        {
            strcpy(action_nam,user_act_nam[i]);
            return;
        }
    }

    strcpy(action_nam,"USER");
    return;
}
