static char USMID[] = "@(#)display.c	1.1 10/16/90 11:03:35 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#include <suntool/textsw.h>

#include <math.h>
#include "externvars.h"

/**********************************************************************
 * This routine displayes a message in the textsw window for the users
 * edification.
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern Pixwin *pw, *mpw;
extern Textsw textsw;
extern double update_time;
extern Panel panel;
extern Panel_item speedometer;

short im_zerospeed[] = {
#include "icons/zero.icon"
};
mpr_static(zerospeed,PROCDIM,PROCDIM,1,im_zerospeed);

short im_onespeed[] = {
#include "icons/one.icon"
};
mpr_static(onespeed,PROCDIM,PROCDIM,1,im_onespeed);

short im_onenspeed[] = {
#include "icons/none.icon"
};
mpr_static(onenspeed,PROCDIM,PROCDIM,1,im_onenspeed);

short im_twospeed[] = {
#include "icons/two.icon"
};
mpr_static(twospeed,PROCDIM,PROCDIM,1,im_twospeed);

short im_twonspeed[] = {
#include "icons/ntwo.icon"
};
mpr_static(twonspeed,PROCDIM,PROCDIM,1,im_twonspeed);

short im_threespeed[] = {
#include "icons/three.icon"
};
mpr_static(threespeed,PROCDIM,PROCDIM,1,im_threespeed);

short im_threenspeed[] = {
#include "icons/nthree.icon"
};
mpr_static(threenspeed,PROCDIM,PROCDIM,1,im_threenspeed);

short im_fourspeed[] = {
#include "icons/four.icon"
};
mpr_static(fourspeed,PROCDIM,PROCDIM,1,im_fourspeed);

short im_fournspeed[] = {
#include "icons/nfour.icon"
};
mpr_static(fournspeed,PROCDIM,PROCDIM,1,im_fournspeed);

short im_fivespeed[] = {
#include "icons/five.icon"
};
mpr_static(fivespeed,PROCDIM,PROCDIM,1,im_fivespeed);

short im_fivenspeed[] = {
#include "icons/nfive.icon"
};
mpr_static(fivenspeed,PROCDIM,PROCDIM,1,im_fivenspeed);

short im_sixspeed[] = {
#include "icons/six.icon"
};
mpr_static(sixspeed,PROCDIM,PROCDIM,1,im_sixspeed);

short im_sixnspeed[] = {
#include "icons/nsix.icon"
};
mpr_static(sixnspeed,PROCDIM,PROCDIM,1,im_sixnspeed);

short im_sevenspeed[] = {
#include "icons/seven.icon"
};
mpr_static(sevenspeed,PROCDIM,PROCDIM,1,im_sevenspeed);

short im_sevennspeed[] = {
#include "icons/nseven.icon"
};
mpr_static(sevennspeed,PROCDIM,PROCDIM,1,im_sevennspeed);


display_message(text)
char *text;
{
/*********************************************
 * Display a message in the text subwindow 
 **********************************************/ 
    if (textsw) {
	/* Make sure the cursor is at the end of the text before inserting */
	window_set( textsw, TEXTSW_INSERTION_POINT, TEXTSW_INFINITY, 0 );
	textsw_insert(textsw, text, strlen(text));
    } else {
	printf(text);
    }
}

display_task_id()
{
/*********************************************
 * Function to print out the task id line on the
 * the screen.
 *********************************************/
    int x,id,i,y;
    char str[5];
    struct pixfont *display_font;

    display_font = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.b.14");
    y = ypos + NODEHEIGHT - 2;
    for (i=0;i < MAXCOLUMNS;i++) {
	id = screen[i].taskid; 
	if ( id != 0) {
	    x = tasks[id].x + (COLUMNWIDTH/2) - 10;
	    sprintf(str,"%d",id);
	    pw_text(pw,x,y,PIX_SCR,display_font,str);
	}
    }
    ypos += NODEHEIGHT;

}

display_values()
{
/**********************************************
 * display_values displays the values assigned 
 * to the various locks, events, or barriers.
 ********************************************/	 
    char str[40];
    int i;

    switch (display_type) {
      case 0 :	 /* locks */
	if (locks[0] == -1)
	  pw_text(mpw,30,50,PIX_SCR,0,"No Locks");
	else {
	    pw_text(mpw,30,20,PIX_SCR,0,"Values of the Locks");
	    pw_text(mpw,30,35,PIX_SCR,0,"-------------------");
	    for (i= 0;(i < MAXVALUES) && (locks[i] != -1);i++) {
		sprintf(str,"Value: %d	Address: %d", 
			i, locks[i]);
		pw_text(mpw,20,50 + (15*i),PIX_SCR,0,str);
	    } 
	}
	break;
      case 1 :	 /* events */
	if (events[0] == -1)
	  pw_text(mpw,30,50,PIX_SCR,0,"No Events");
	else {
	    pw_text(mpw,30,20,PIX_SCR,0,"Values of the Events");
	    pw_text(mpw,30,35,PIX_SCR,0,"--------------------");
	    for (i= 0;(i < MAXVALUES) && (events[i] != -1);i++) {
		sprintf(str,"Value: %d	Address: %d", 
			i, events[i]);
		pw_text(mpw,20,50 + (15*i),PIX_SCR,0,str);
	    } 
	}
	break;
      case 2 :
	if (barriers[0] == -1)
	  pw_text(mpw,30,50,PIX_SCR,0,"No Barriers");
	else {
	    pw_text(mpw,30,20,PIX_SCR,0,"Values of the Barriers");
	    pw_text(mpw,30,35,PIX_SCR,0,"----------------------"); /* TIR 11832*/
	    for (i= 0;(i < MAXVALUES) && (barriers[i] != -1);i++) {
		sprintf(str,"Value: %d	Address: %d", 
			i, barriers[i]);
		/* no TIR # but fixes a spacing inconsistency */
		pw_text(mpw,20,50 + (20*i),PIX_SCR,0,str);  
	    } 
	}
	break;
    }
}


display_time_warp(clock_difference)
     double clock_difference;
{
/**************************************************
* Display the correlation between Cray/Alliant time 
* and real time.  Will be reported as a power 
* of ten: 1 (s) Cray/Alliant = 10^X (s) Timeline Time.
***************************************************/
    double logpower;
    double warpfactor;
    int tenpower;
    char str[20];

    if (clock_difference == 0 ) 
      logpower = 0.0;
    else {
	warpfactor = (update_time)/(clock_cycle*clock_difference);
	logpower = (log10(warpfactor));
	if (logpower < 0)			/* Round ... */
	  logpower = logpower - 0.5;
	else
	  logpower = logpower + 0.5;
    }
    tenpower = (int)logpower;			/* ... and truncate  */

    switch (tenpower) {
      case -7:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &sevennspeed,
		  0);
	break;
      case -6:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &sixnspeed,
		  0);
	break;
      case -5:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &fivenspeed,
		  0);
      case -4:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &fournspeed,
		  0);
	break;
      case -3:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &threenspeed,
		  0);
	break;
      case -2:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &twonspeed,
		  0);
	break;
      case -1:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &onenspeed,
		  0);
	break;
      case 0:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &zerospeed,
		  0);
	break;
      case 1:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &onespeed,
		  0);
	break;
      case 2:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &twospeed,
		  0);
	break;
      case 3:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &threespeed,
		  0);
	break;
      case 4:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &fourspeed,
		  0);
	break;
      case 5:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &fivespeed,
		  0);
	break;
      case 6:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &sixspeed,
		  0);
	break;
      case 7:
	panel_set(speedometer,
		  PANEL_LABEL_IMAGE, &sevenspeed,
		  0);
	break;
    }
}
#endif /* sunview */
