h19425
s 00069/00005/01137
d D 1.2 90/10/22 13:11:36 werner 2 1
c Added eventhandlers to intercept Button presses for popup windows.
e
s 01142/00000/00000
d D 1.1 90/10/16 11:04:13 werner 1 0
c date and time created 90/10/16 11:04:13 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef X11
#include <stdio.h>
#include "externvars.h"
#include "xwinit.h"             /* xwinit.h includes xexterns.h */
/*#include <X11/Xutil.h>*/
#include "xicons/punbind.icon" /* Only for debugging */

/*#include "defines.h"*/


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#define nActions(x) (sizeof(x)/sizeof(XtActionsRec))

static Widget interval_buttons, machine_buttons, idle_buttons;
static Widget filter_buttons;
static Widget address_buttons;
static Widget idle_pop;
static Widget filter_pop;
static Widget interval_pop;
static Widget machine_pop;
static Widget quit_pop, quit_shell, quit_question;
static Widget quit_button, quit_cancel_button, quit_execute_button;

static Widget jumpby_label, jumpto_label;
static Widget viewport;

Pixel  black, white;
XWindowAttributes frameAttributes;
Window frame_wid;       /* used to expose window */
Arg args[maxArgs];
unsigned int depth;

extern int margc;
extern char **margv;
extern char dumpfile[];
extern XImage *speed_image[];

void load_file_table(), load_directory_table();
extern XtCallbackProc load_notify_proc(), go_notify_proc(),
        step_notify_proc(), events_notify_proc(),hist_notify_proc(),
        cancel_notify_proc(), filter_notify_proc(), idle_notify_proc(),
        machine_notify_proc(), interval_notify_proc(), action_notify_proc();

extern void display_values();
extern void display_notify_proc();
extern void directory_notify_proc(), file_notify_proc();

#define nActions(x) (sizeof(x)/sizeof(XtActionsRec))
#define MAXARGS 10

#include "xicons/tl.icon"
#include "xicons/four.icon"

Pixmap four_pixmap;
Pixmap tl_pixmap;

static char *hist_str = "       GMAT Histogram - Events Procesed versus Active Processes";
static char *key_str = "              Key to GMAT Symbols";
static char *time_str = "        GMAT - TimeLine                       ";
static char *dir_str = "Directory: ";
static char *trace_str = "Trace file:             ";

I 2
/* intercepts events that you do not want to reach the root window */
void  popdummy(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
	return;
}


E 2
static XtCallbackProc popMachine(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+187);
        XtSetArg(args[1],XtNy,frameAttributes.y+117);
        XtSetValues(machine_shell,args,2);

        XtPopup(machine_shell,XtGrabNone);
        return;
}

static XtCallbackProc popInterval(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+159);
        XtSetArg(args[1],XtNy,frameAttributes.y+105);
        XtSetValues(interval_shell,args,2);

        XtPopup(interval_shell,XtGrabNone);
        return;
}

static XtCallbackProc popFilter(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+469);
        XtSetArg(args[1],XtNy,frameAttributes.y+172);
        XtSetValues(filter_shell,args,2);

        XtPopup(filter_shell,XtGrabNone);
        return;
}

static XtCallbackProc popIdle(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+162);
        XtSetArg(args[1],XtNy,frameAttributes.y+90);
        XtSetValues(idle_shell,args,2);

        XtPopup(idle_shell,XtGrabNone);
        return;
}

XtCallbackProc popAddress(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+170);
        XtSetArg(args[1],XtNy,frameAttributes.y+132);
        XtSetValues(address_shell,args,2);

        XtPopup(address_shell,XtGrabNone);
        return;
}

static XtCallbackProc popAction(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        extern int action_FLAG;

        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+415);
        XtSetArg(args[1],XtNy,frameAttributes.y+213);
        XtSetValues(action_shell,args,2);

        XtPopup(action_shell,XtGrabNone);
        action_FLAG = 1;
        return;
}

static XtCallbackProc popJump(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+284);
        XtSetArg(args[1],XtNy,frameAttributes.y+173);
        XtSetValues(jump_shell,args,2);

        XtPopup(jump_shell,XtGrabNone);
        return;
}

static XtCallbackProc popDirection(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+402);
        XtSetArg(args[1],XtNy,frameAttributes.y+193);
        XtSetValues(jump_direction_shell,args,2);

        XtPopup(jump_direction_shell,XtGrabNone);
        return;
}



static XtCallbackProc quit_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+557);
        XtSetArg(args[1],XtNy,frameAttributes.y+173);
        XtSetValues(quit_shell,args,2);
D 2

        XtPopup(quit_shell,XtGrabNone);
E 2
I 2
        XtPopup(quit_shell,XtGrabNone); 
E 2
}

I 2

E 2
static XtActionProc execQuit(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        exit(0);
}

static XtActionProc cancelQuit(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XtPopdown(quit_shell);
        return;
}

XtActionProc dirMenu(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+176);
        XtSetArg(args[1],XtNy,frameAttributes.y+66);
        XtSetValues(dir_shell,args,2);

        XtSetSensitive(directory_choice,False);
        XtPopup(dir_shell,XtGrabNone);
        return;
}


XtActionProc fileMenu(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
        XtSetArg(args[0],XtNx,frameAttributes.x+147);
        XtSetArg(args[1],XtNy,frameAttributes.y+84);
        XtSetValues(file_shell,args,2);

        XtPopup(file_shell,XtGrabNone);
        return;
}


static int x = 300;
static int y = 10;
static int cnt = 0;


static XtCallbackProc keyProc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{
        prepare_key();
        return;
}

char current_dir[150];

XFontStruct *font_info2;
static_init(argc,argv)
int *argc;
char *argv[];
{
        int i;
        int ret_val = 0;        /* generic error return value */
        Screen *s;
        XGCValues values;
        XSetWindowAttributes attr;

        s = XtScreen(frame);
        display_control = XtDisplay(frame);
        if( rv == 0 )
        {
                black = BlackPixel(display_control,DefaultScreen(display_control));
                white = WhitePixel(display_control,DefaultScreen(display_control));
        } else
        {
                white = BlackPixel(display_control,DefaultScreen(display_control));
                black = WhitePixel(display_control,DefaultScreen(display_control));
        }
        depth = DisplayPlanes(XtDisplay(frame), DefaultScreen(XtDisplay(frame)));

        tl_pixmap = XCreateBitmapFromData(display_control,
                        DefaultRootWindow(display_control), tl_bits,
                        tl_width, tl_height);
        XtSetArg(args[0], XtNiconPixmap, tl_pixmap);
        XtSetValues(frame, args, 1);

        /* Create gmat widget.  This will be the 3 windows.
         * control_widget, message_widget, and canvas. */
        panel = XtCreateManagedWidget("gmat",           /* widget name */
                                       formWidgetClass,/* widget class */
                                       frame,   /* parent widget */
                                       NULL, NULL);     /* argument list */

        /* Create Timeline title.  First open the display to load the font. */
    if ((font_info2 = XLoadQueryFont(display_control, "fixed")) == NULL )
        {
#ifdef STDERR
                fprintf(stderr,"XLoadQueryFont: unable to open font fixed\n");
#else
                msghan(5,1,"fixed");
#endif 
                exit();
        }

        if( (ret_val = control_window()) == 0 )
                if( (ret_val = message_window()) == 0 )
                        if( (ret_val = canvas_window()) == 0)
                                hist_window();
        if( ret_val != 0 )
        {
#ifdef STDERR
                fprintf(stderr,"Unable to initialize timeline\n");
#else
                msghan(2,1,NULL);
#endif
                exit(-1);
        }
        
        /* Realize the widget heirarchy, creating and mapping windows */
        XtRealizeWidget(frame);
        XtResizeWidget(inner_canvas,VIEWSIZE,VIEWHEIGHT,0);
        XtMoveWidget(inner_canvas,-CENTER,0);
        XtRealizeWidget(hist_shell);
        XtResizeWidget(inner_hist,MAXHIST,220,0);
        
        frame_wid = XtWindow(frame);

        control_display = XtDisplay(control_widget);;
        control_screen = XtScreen(control_widget);
        control_win = XtWindow(control_widget);

        values.function = GXcopy;
        values.font = font_info2->fid;
        values.foreground = black;
        values.background = white;

        attr.backing_store = Always;
        attr.save_under = True;
        XChangeWindowAttributes(control_display,control_win,
                (CWBackingStore | CWSaveUnder),&attr);
        
        control_gc = XCreateGC(control_display,control_win,
                        (GCFunction|GCForeground|GCBackground|GCFont),
                                &values);

        key_display = XtDisplay(key_pop);
        key_scr = XtScreen(key_pop);

        key_gc = control_gc;
        
        hist_display = XtDisplay(inner_hist);
        hist_screen = XtScreen(inner_hist);
        hist_win = XtWindow(inner_hist);

        XChangeWindowAttributes(hist_display,hist_win,
                (CWBackingStore | CWSaveUnder),&attr);

        hidden_display = XtDisplay(hidden_canvas);
        hidden_scr = XtScreen(hidden_canvas);
        hidden_win = XtWindow(hidden_canvas);

        XChangeWindowAttributes(hidden_display,hidden_win,
                (CWBackingStore | CWSaveUnder),&attr);

        hidden_gc = control_gc;

        canvas_display = XtDisplay(inner_canvas);
        canvas_screen = XtScreen(inner_canvas);
        can_win = XtWindow(inner_canvas);

        /* this is a different gc it is set to dashes to give the wait line */
        dotted_gc = XCreateGC(canvas_display,can_win,
                        (GCFunction|GCForeground|GCBackground),
                                &values);
        XSetLineAttributes(canvas_display,dotted_gc,1,LineOnOffDash,
                CapButt,JoinRound);

        canvas_gc = XCreateGC(canvas_display,can_win,
                        (GCFunction|GCForeground|GCBackground|GCFont),
                                &values);

        attr.backing_store = Always;
        attr.save_under  = True;
        XChangeWindowAttributes(canvas_display,can_win,
                (CWBackingStore | CWSaveUnder),&attr);

        text_display = XtDisplay(message_widget);
        text_win = XtWindow(message_widget);

        if( rv == 0 )
        {
                values.foreground = black;
                values.background = white;
        } else
        {
                values.foreground = white;
                values.background = black;
        }
        event_gc = XCreateGC(canvas_display,can_win,
                        (GCFunction|GCForeground|GCBackground|GCFont),
                                &values);

        init_speed();
        XPutImage(display_control,control_win,control_gc,speed_image[11],
                        0,0,300,75,64,64);
        XFlush(control_display);

        return(ret_val);
}

int canvas_window()
{
        int ret_val = 0;
        unsigned long event_mask;

        XtSetArg(args[0],XtNheight,690);
        XtSetArg(args[1],XtNwidth,800);
        XtSetArg(args[2],XtNborderWidth,2);
        XtSetArg(args[3],XtNfromHoriz,NULL);
        XtSetArg(args[4],XtNfromVert,control_widget);
        outer_canvas = XtCreateManagedWidget("canvas", formWidgetClass,
                                        panel, args, 5);

        XtSetArg(args[0],XtNallowHoriz,True);
        XtSetArg(args[1],XtNallowVert,True);
        XtSetArg(args[2],XtNlength,VIEWSIZE);
        XtSetArg(args[3],XtNthickness,VIEWSIZE);
        XtSetArg(args[4],XtNborderWidth,0);
        viewport = XtCreateManagedWidget( "viewport", viewportWidgetClass,
                                outer_canvas, args, 5);
        XtSetArg(viewportArgs[0], XtNforceBars, True);
        XtSetValues(viewport,viewportArgs,1);

        /* this height really controls the height of the canvas */
D 2
    XtSetArg(args[0],XtNheight,690);
E 2
I 2
    	XtSetArg(args[0],XtNheight,690);
E 2
        XtSetArg(args[1],XtNwidth,850);
        XtSetArg(args[2],XtNborderWidth,0);
        inner_canvas = XtCreateManagedWidget( NULL, formWidgetClass, viewport,
                                                args, 3);
        event_mask = ButtonPressMask;
        XtAddEventHandler(inner_canvas,event_mask,NULL,display_values,NULL);

        XtSetArg(args[0],XtNheight,700);
        XtSetArg(args[1],XtNwidth,200);
        XtSetArg(args[2],XtNborderWidth,0);
        XtSetArg(args[3],XtNfromHoriz,outer_canvas);
        XtSetArg(args[4],XtNfromVert,message_widget);
        hidden_canvas = XtCreateManagedWidget("canvas", boxWidgetClass,
                                        panel, args, 5);
        
        return(ret_val);
}


int hist_window()
{
        int ret_val = 0;
        unsigned long event_mask;

        outer_hist = XtCreateManagedWidget("hist", formWidgetClass,
                                        hist_shell, outerHistArgs, 
                                        XtNumber(outerHistArgs));

        hist_viewport = XtCreateManagedWidget( "hist_viewport",
                                viewportWidgetClass,
                                outer_hist, histViewportArgs, 
                                XtNumber(histViewportArgs));
        XtSetArg(histViewportArgs[0], XtNforceBars, True);
        XtSetValues(hist_viewport,histViewportArgs,1);

        inner_hist = XtCreateManagedWidget( NULL, formWidgetClass,hist_viewport,
                                                innerHistArgs, 
                                                XtNumber(innerHistArgs));

        return(ret_val);
}

int message_window()
{
        int ret_val = 0;

        XtSetArg(messageWidgetArgs[3],XtNfromHoriz,control_widget);
        XtSetArg(messageWidgetArgs[7],XtNforeground,black);
        XtSetArg(messageWidgetArgs[8],XtNbackground,white);
        XtSetArg(messageWidgetArgs[9],XtNfont,font_info2);
#ifdef X11R3
        message_widget = XtCreateManagedWidget("TexWidg",
                                asciiStringWidgetClass, panel,
                                messageWidgetArgs, 
                                XtNumber(messageWidgetArgs));
#else
        message_widget = XtCreateManagedWidget("TexWidg",
                                asciiTextWidgetClass, panel,
                                messageWidgetArgs, 
                                XtNumber(messageWidgetArgs));
#endif
        return(ret_val);
}

int control_window()
{
I 2
	unsigned long event_mask;
E 2
        Mask *valueMask = NULL;
        XSetWindowAttributes *attributes;
        Cardinal width = 400;
        Cardinal height = 600;
        Cardinal borderWidth = 2;
        Cardinal bottomRow = 150;
        Arg controlWindowArgs[maxArgs];
        int n, i;
        int ret_val = 0;
        XFontStruct *font_info;
        static Widget load_button, go_button, step_button, histogram_button;
        static Widget key_button, idle_header, machine_header, interval_header;
        static Widget filter_header, address_header, jumpby_header;
        static Widget action_lister;

D 2
/*        static char *fontname[] = { "/LG2/werner/NGMAT/vr-25", "vg-25", "fg-20" }; */
E 2
I 2
/*        static char *fontname[] = { "vr-25", "vg-25", "fg-20" }; */
E 2
         static char *fontname[] = { "12x24", "12x24", "10x20" }; 
        char str[80];
        extern XtCallbackProc execute_notify_proc(), set_direction_selection();
        extern String action_list[];


        /* Create form widget.  This will contain all the controlling
         * buttons for timeline. */
        control_widget = XtCreateManagedWidget("gmat", formWidgetClass,
                                     panel, controlWidgetArgs,
                                     XtNumber(controlWidgetArgs));

        /* try to find a few resonable fonts.  If they're not there use default. */
        for( i=0; i<3; i++ )
        {
                /* do the title */
                if ((font_info = XLoadQueryFont(display_control, fontname[i])) == NULL )
                {
                        sprintf(str, "XLoadQueryFont: unable to open font %s\n",
                                fontname[i]);
#ifdef STDERR
                        fprintf(stderr, "%s",str);
#else
                        msghan(5,0,fontname[i]);
#endif
                } else
                {
                        break;
                }
        }
        if( i == 3 )
        {
 
               sprintf(str,"XLoadQueryFont: unable to find title fonts - using default\n");
#ifdef STDERR
               fprintf(stderr, "%s" ,str);

#else
                        msghan(5,1,NULL);
#endif
/*strcpy(str,"XLoadQueryFont: unable to open  title fonts - using default\n");
                display_message(str); */
                 
                font_info = font_info2;
        }
        
        XtSetArg(titleArgs[4],XtNlabel,time_str);
        XtSetArg(titleArgs[6],XtNfont,font_info);
        title = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, titleArgs, 
                                      XtNumber(titleArgs));

        hist_shell = XtCreatePopupShell("hist_shell",wmShellWidgetClass,
                        frame, histShellArgs, XtNumber(histShellArgs));

        /* Create file menu popup button. This is really a temporary
         * thing since these next three windows get destroy in the
         * call to load_directory_table. */
        file_choice = XtCreateManagedWidget("label", commandWidgetClass,
                                      control_widget, NULL, (Cardinal) 0);
       /* create file menu shell to pop up. */
        file_shell = XtCreatePopupShell("file",overrideShellWidgetClass,
                        frame,NULL, (Cardinal) 0);
        file_pop = XtCreateManagedWidget("menu",boxWidgetClass,file_shell,
                               NULL,(Cardinal) 0);

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(file_pop,event_mask,NULL,popdummy,NULL);


E 2
        /* Create Directory Label */
        XtSetArg(dirLabelArgs[2],XtNfromVert,title);
        XtSetArg(dirLabelArgs[4],XtNlabel,"Directory: ");
        XtSetArg(dirLabelArgs[6],XtNfont,font_info2);
        dir_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, dirLabelArgs, 
                                      XtNumber(dirLabelArgs));

        /* Get the current working directory and put it to the screen. */
        getcwd(current_dir,150);

        /* Create directory command button to cd around. */
        directory_choice = XtCreateManagedWidget("label", commandWidgetClass,
                                      control_widget, NULL, (Cardinal) 0);

        /* create directory menu shell to pop up. */
        dir_shell = XtCreatePopupShell("directory",overrideShellWidgetClass,
                        panel,NULL, (Cardinal) 0);

        dir_pop = XtCreateManagedWidget("menu",boxWidgetClass,dir_shell,
                               NULL,(Cardinal) 0);
        
I 2

	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(dir_pop,event_mask,NULL,popdummy,NULL);

E 2
        /* Create tracefile Label */
        XtSetArg(traceLabelArgs[2],XtNfromVert,dir_label);
        XtSetArg(traceLabelArgs[4],XtNlabel,"Tracefile: ");
        XtSetArg(traceLabelArgs[6],XtNfont,font_info2);
        trace_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, traceLabelArgs, 
                                      XtNumber(traceLabelArgs));

        load_directory_table();

        /* Create idle Interval Label */
        XtSetArg(idleLabelArgs[2],XtNfromVert,NULL);
        XtSetArg(idleLabelArgs[3],XtNvertDistance,75);
        XtSetArg(idleLabelArgs[4],XtNlabel,"Idle Interval: ");
        XtSetArg(idleLabelArgs[6],XtNfont,font_info2);
        idle_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, idleLabelArgs, 
                                      XtNumber(idleLabelArgs));

        /* Create Idle Interval command popup button. */
        XtSetArg(idleChoiceArgs[2],XtNfromVert, NULL);
        XtSetArg(idleChoiceArgs[3],XtNvertDistance, 75);
        XtSetArg(idleChoiceArgs[4],XtNlabel, "10^5   ");
        XtSetArg(idleChoiceArgs[6],XtNfont,font_info2);
        idle_choice = XtCreateManagedWidget("label", commandWidgetClass,
                                      control_widget, idleChoiceArgs, 
                                      XtNumber(idleChoiceArgs));
        XtAddCallback(idle_choice,XtNcallback,popIdle);


        idle_shell = XtCreatePopupShell("idles",
                                        overrideShellWidgetClass, frame,
                                        idleShellArgs, XtNumber(idleShellArgs));
        idle_pop = XtCreateManagedWidget("menu", boxWidgetClass,
                                        idle_shell, NULL, (Cardinal) 0);
I 2


	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(idle_pop,event_mask,NULL,popdummy,NULL);


E 2
        XtSetArg(idleHeaderArgs[1],XtNbackground,black);
        XtSetArg(idleHeaderArgs[2],XtNforeground,white);
        XtSetArg(idleHeaderArgs[3],XtNlabel,"Idle Interval:");
        XtSetArg(idleHeaderArgs[4],XtNfont,font_info2);
        idle_header = XtCreateManagedWidget("Label",
                                        labelWidgetClass, idle_pop,
                                        idleHeaderArgs,
                                        XtNumber(idleHeaderArgs));

        XtSetArg(args[0],XtNlist,idle_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,idle_header);
        XtSetArg(args[6],XtNfont,font_info2);
        idle_buttons = XtCreateManagedWidget("", listWidgetClass, idle_pop,
                                args, 7);
        XtAddCallback(idle_buttons, XtNcallback, idle_notify_proc);

        /* Create Clock Interval Label */
        XtSetArg(clockLabelArgs[2],XtNfromVert,idle_label);
        XtSetArg(clockLabelArgs[4],XtNlabel,"Clock Interval:");
        XtSetArg(clockLabelArgs[6],XtNfont,font_info2);
        clock_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, clockLabelArgs, 
                                      XtNumber(clockLabelArgs));

        /* Create Clock Interval command popup button. */
        XtSetArg(intervalChoiceArgs[2],XtNfromVert, idle_choice);
        XtSetArg(intervalChoiceArgs[4],XtNlabel, "10^4");
        XtSetArg(intervalChoiceArgs[6],XtNfont,font_info2);
        interval_choice = XtCreateManagedWidget("label", commandWidgetClass,
                                      control_widget, intervalChoiceArgs, 
                                      XtNumber(intervalChoiceArgs));
        XtAddCallback(interval_choice,XtNcallback,popInterval);


        interval_shell = XtCreatePopupShell("intervals",
                                        overrideShellWidgetClass, frame,
                                        intervalShellArgs,
                                        XtNumber(intervalShellArgs));

        interval_pop = XtCreateManagedWidget("menu", boxWidgetClass,
                                        interval_shell, NULL, (Cardinal) 0);

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(interval_pop,event_mask,NULL,popdummy,NULL);

E 2
        XtSetArg(intervalHeaderArgs[1],XtNbackground,black);
        XtSetArg(intervalHeaderArgs[2],XtNforeground,white);
        XtSetArg(intervalHeaderArgs[3],XtNlabel,"Clock Interval:");
        XtSetArg(intervalHeaderArgs[4],XtNfont,font_info2);
        interval_header = XtCreateManagedWidget("Label",
                                        labelWidgetClass, interval_pop,
                                        intervalHeaderArgs,
                                        XtNumber(intervalHeaderArgs));

        XtSetArg(args[0],XtNlist,interval_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,interval_header);
        XtSetArg(args[6],XtNfont,font_info2);
        interval_buttons = XtCreateManagedWidget("", listWidgetClass,
                interval_pop, args, 7);
        XtAddCallback(interval_buttons, XtNcallback, interval_notify_proc);

        /* Create Machine type Label */
        XtSetArg(machineLabelArgs[2],XtNfromVert,clock_label);
        XtSetArg(machineLabelArgs[4],XtNlabel,"Machine Type: ");
        XtSetArg(machineLabelArgs[6],XtNfont,font_info2);
        machine_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, machineLabelArgs, 
                                      XtNumber(machineLabelArgs));

        /* Create Machine type command popup button */
        XtSetArg(machineChoiceArgs[2],XtNfromVert,interval_choice);
        XtSetArg(machineChoiceArgs[4],XtNlabel,"Cray X-MP");
        XtSetArg(machineChoiceArgs[6],XtNfont,font_info2);
        machine_choice = XtCreateManagedWidget("command", commandWidgetClass,
                                      control_widget, machineChoiceArgs, 
                                      XtNumber(machineChoiceArgs));
        XtAddCallback(machine_choice,XtNcallback,popMachine);

        machine_shell = XtCreatePopupShell("machines",
                                        overrideShellWidgetClass, frame,
                                        machineShellArgs,
                                        XtNumber(machineShellArgs));

        machine_pop = XtCreateManagedWidget("menu", boxWidgetClass,
                                        machine_shell, NULL, (Cardinal) 0);

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(machine_pop,event_mask,NULL,popdummy,NULL);

E 2
        XtSetArg(machineHeaderArgs[1],XtNbackground,black);
        XtSetArg(machineHeaderArgs[2],XtNforeground,white);
        XtSetArg(machineHeaderArgs[3],XtNlabel,"Machine Type:");
        XtSetArg(machineHeaderArgs[4],XtNfont,font_info2);
        machine_header = XtCreateManagedWidget("Label",
                                        labelWidgetClass, machine_pop,
                                        machineHeaderArgs,
                                        XtNumber(machineHeaderArgs));

        XtSetArg(args[0],XtNlist,machine_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,machine_header);
        XtSetArg(args[6],XtNfont,font_info2);
        machine_buttons = XtCreateManagedWidget("", listWidgetClass,
                                machine_pop, args, 7);
        XtAddCallback(machine_buttons, XtNcallback, machine_notify_proc);

        /* Create Address Table Label */
        XtSetArg(addressLabelArgs[2],XtNfromVert,machine_label);
        XtSetArg(addressLabelArgs[4],XtNlabel,"Address Table: ");
        XtSetArg(addressLabelArgs[6],XtNfont,font_info2);
        address_label = XtCreateManagedWidget("label", labelWidgetClass,
                                      control_widget, addressLabelArgs,
                                      XtNumber(addressLabelArgs));


        /* Create Address Table command button. */
        XtSetArg(addressChoiceArgs[2],XtNfromVert,machine_choice);
        XtSetArg(addressChoiceArgs[5],XtNlabel,"Locks   ");
        XtSetArg(addressChoiceArgs[6],XtNfont,font_info2);
        address_choice = XtCreateManagedWidget("label", commandWidgetClass,
                                      control_widget, addressChoiceArgs, 
                                      XtNumber(addressChoiceArgs));
        XtAddCallback(address_choice,XtNcallback,popAddress);

        address_shell = XtCreatePopupShell("address",
                                        overrideShellWidgetClass, frame,
                                        addressShellArgs,
                                        XtNumber(addressShellArgs));

        address_pop = XtCreateManagedWidget("menu", boxWidgetClass,
                                        address_shell, NULL, (Cardinal) 0);

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(address_pop,event_mask,NULL,popdummy,NULL);

E 2
        XtSetArg(addressHeaderArgs[1],XtNbackground,black);
        XtSetArg(addressHeaderArgs[2],XtNforeground,white);
        XtSetArg(addressHeaderArgs[3],XtNlabel,"Address Selection:");
        XtSetArg(addressHeaderArgs[4],XtNfont,font_info2);
        address_header = XtCreateManagedWidget("Label",
                                        labelWidgetClass, address_pop,
                                        addressHeaderArgs,
                                        XtNumber(addressHeaderArgs));

        XtSetArg(args[0],XtNlist,address_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,address_header);
        XtSetArg(args[6],XtNfont,font_info2);
        address_buttons = XtCreateManagedWidget("", listWidgetClass,
                address_pop, args, 7);
        XtAddCallback(address_buttons, XtNcallback, display_notify_proc);


        /* CREATE CHOICE BUTTONS */

        /* Create Load button */
        XtSetArg(loadButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(loadButtonArgs[5],XtNlabel,"Load");
        XtSetArg(loadButtonArgs[6],XtNfont,font_info2);
        load_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, loadButtonArgs, 
                                     XtNumber(loadButtonArgs));
        XtAddCallback(load_button,XtNcallback,load_notify_proc);

        /* Create go button */
        XtSetArg(goButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(goButtonArgs[4],XtNfromHoriz,load_button);
        XtSetArg(goButtonArgs[5],XtNlabel,"Go");
        XtSetArg(goButtonArgs[6],XtNfont,font_info2);
        go_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, goButtonArgs, 
                                     XtNumber(goButtonArgs));
        XtAddCallback(go_button,XtNcallback,go_notify_proc);

        /* Create step button */
        XtSetArg(stepButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(stepButtonArgs[4],XtNfromHoriz,go_button);
        XtSetArg(stepButtonArgs[5],XtNlabel,"Step");
        XtSetArg(stepButtonArgs[6],XtNfont,font_info2);
        step_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, stepButtonArgs, 
                                     XtNumber(stepButtonArgs));
        XtAddCallback(step_button,XtNcallback,step_notify_proc);

        /* Create key button */
        XtSetArg(keyButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(keyButtonArgs[4],XtNfromHoriz,step_button);
        XtSetArg(keyButtonArgs[5],XtNlabel,"Key");
        XtSetArg(keyButtonArgs[6],XtNfont,font_info2);
        key_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, keyButtonArgs, 
                                     XtNumber(keyButtonArgs));
        XtAddCallback(key_button,XtNcallback,keyProc);

        /* Create histogram button */
        XtSetArg(histogramButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(histogramButtonArgs[4],XtNfromHoriz,key_button);
        XtSetArg(histogramButtonArgs[5],XtNlabel,"Histogram");
        XtSetArg(histogramButtonArgs[6],XtNfont,font_info2);
        histogram_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, histogramButtonArgs, 
                                     XtNumber(histogramButtonArgs));
        XtAddCallback(histogram_button,XtNcallback,hist_notify_proc);

        /* create  jump button */
        XtSetArg(jumpButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(jumpButtonArgs[4],XtNfromHoriz,histogram_button);
        XtSetArg(jumpButtonArgs[5],XtNlabel,"Jump");
        XtSetArg(jumpButtonArgs[6],XtNfont,font_info2);
        jump_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, jumpButtonArgs, 
                                     XtNumber(jumpButtonArgs));
        XtAddCallback(jump_button,XtNcallback,popJump);


        /* Create Jump button shell for popup window. */
        jump_shell = XtCreatePopupShell("jumpShell",overrideShellWidgetClass,
                                        frame,jumpShellArgs,
                                        XtNumber(jumpShellArgs));

        /* Create jump window form. */
        jump_pop = XtCreateManagedWidget("jumpWindow", formWidgetClass,
                                  jump_shell, jumpPopArgs,
                                  XtNumber(jumpPopArgs));

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(jump_pop,event_mask,NULL,popdummy,NULL);

E 2
        /* Create Jump button shell for popup window. */
        jump_direction_shell = XtCreatePopupShell("jumpShell",
                                        overrideShellWidgetClass,
                                        frame,jumpDirectionShellArgs,
                                        XtNumber(jumpDirectionShellArgs));

        /* Create jump window form. */
        jump_direction_pop = XtCreateManagedWidget("jumpWindow",formWidgetClass,
                                  jump_direction_shell, jumpDirectionPopArgs,
                                  XtNumber(jumpDirectionPopArgs));

        /* Create the Jump title button. */
        XtSetArg(jumpLabelArgs[0],XtNlabel,"Jump: ");
        XtSetArg(jumpLabelArgs[5],XtNfont,font_info2);
        jump_label = XtCreateManagedWidget("jumpWindow", labelWidgetClass,
                                  jump_pop, jumpLabelArgs, 
                                  XtNumber(jumpLabelArgs));

        /* Create Jump type command popup button */
        XtSetArg(jumpDirectionChoiceArgs[0],XtNfromHoriz,NULL);
        XtSetArg(jumpDirectionChoiceArgs[2],XtNlabel,jump_direction_table[0]);
        XtSetArg(jumpDirectionChoiceArgs[4],XtNfromVert,NULL);
        XtSetArg(jumpDirectionChoiceArgs[6],XtNfont,font_info2);
        jumpDirection_choice = XtCreateManagedWidget("command",
                                        commandWidgetClass,
                                        jump_pop, jumpDirectionChoiceArgs, 
                                        XtNumber(jumpDirectionChoiceArgs));
        XtAddCallback(jumpDirection_choice,XtNcallback,events_notify_proc);


        /* Create the jumpby label */
        XtSetArg(jumpbyLabelArgs[0],XtNlabel,"Jump By: ");
        XtSetArg(jumpbyLabelArgs[3],XtNfromVert,jump_label);
        XtSetArg(jumpbyLabelArgs[6],XtNfont,font_info2);
        jumpby_label = XtCreateManagedWidget("jumpWindow", labelWidgetClass,
                                        jump_pop, jumpbyLabelArgs, 
                                        XtNumber(jumpbyLabelArgs));

        /* Create Jump type command popup button */
        XtSetArg(jumpbyChoiceArgs[0],XtNfromHoriz,NULL);
        XtSetArg(jumpbyChoiceArgs[2],XtNlabel,jumpby_table[0]);
        XtSetArg(jumpbyChoiceArgs[4],XtNfromVert,jump_label);
        XtSetArg(jumpbyChoiceArgs[6],XtNfont,font_info2);
        jumpby_choice = XtCreateManagedWidget("command", commandWidgetClass,
                                        jump_pop, jumpbyChoiceArgs, 
                                        XtNumber(jumpbyChoiceArgs));
        XtAddCallback(jumpby_choice,XtNcallback,events_notify_proc);

        /* Create the jumpto label */
        XtSetArg(jumptoLabelArgs[0],XtNlabel,"Jump To: ");
        XtSetArg(jumptoLabelArgs[3],XtNfromVert,jumpby_label);
        XtSetArg(jumptoLabelArgs[6],XtNfont,font_info2);
        jumpto_label = XtCreateManagedWidget("jumpWindow", labelWidgetClass,
                                        jump_pop, jumptoLabelArgs, 
                                        XtNumber(jumptoLabelArgs));

        /* Create the jumpto value */
        XtSetArg(jumptoValueArgs[0],XtNlabel,"           ");
        XtSetArg(jumptoValueArgs[4],XtNfromVert,NULL);
        XtSetArg(jumptoValueArgs[5],XtNvertDistance,35);
        XtSetArg(jumptoValueArgs[6],XtNvalue,"");
        XtSetArg(jumptoValueArgs[9],XtNforeground,black);
        XtSetArg(jumptoValueArgs[10],XtNbackground,white);
        XtSetArg(jumptoValueArgs[11],XtNfont,font_info2);
        jumpto_value = XtCreateManagedWidget("jumpWindow", dialogWidgetClass,
                                        jump_pop, jumptoValueArgs, XtNumber(jumptoValueArgs));

        /* Create the Jump execute button */
        XtSetArg(jumpExecuteButtonArgs[0],XtNlabel,"Execute");
        XtSetArg(jumpExecuteButtonArgs[2],XtNfromVert,jumpto_label);
        XtSetArg(jumpExecuteButtonArgs[4],XtNfont,font_info2);
        jump_execute_button = XtCreateManagedWidget("jumpWindow",
                                  commandWidgetClass, jump_pop, jumpExecuteButtonArgs, 
                                  XtNumber(jumpExecuteButtonArgs));
        XtAddCallback(jump_execute_button,XtNcallback,execute_notify_proc);

        /* Create the Jump cancel button */
        XtSetArg(jumpCancelButtonArgs[0],XtNlabel,"Cancel");
        XtSetArg(jumpCancelButtonArgs[2],XtNfromHoriz,jump_execute_button);
        XtSetArg(jumpCancelButtonArgs[4],XtNfromVert,jumpto_label);
        XtSetArg(jumpCancelButtonArgs[6],XtNfont,font_info2);
        jump_cancel_button = XtCreateManagedWidget("jumpWindow",
                                  commandWidgetClass,
                                  jump_pop, jumpCancelButtonArgs, 
                                  XtNumber(jumpCancelButtonArgs));
        XtAddCallback(jump_cancel_button,XtNcallback,cancel_notify_proc);

        /* Create the jumpby button */
        XtSetArg(args[0],XtNx,90);
        XtSetArg(args[1],XtNy,60);
        jumpby_shell = XtCreatePopupShell("jumpShell",
                                overrideShellWidgetClass,
                                frame,args,2);

        /* Create jump by menu form. */
        XtSetArg(args[0],XtNwidth,0);
        jumpby_pop = XtCreateManagedWidget("jumpWindow", boxWidgetClass,
                                jumpby_shell, args, 1);

        XtSetArg(args[1],XtNbackground,black);
        XtSetArg(args[2],XtNforeground,white);
        XtSetArg(args[3],XtNlabel,"Jump By:");
        XtSetArg(args[4],XtNfont,font_info2);
        jumpby_header = XtCreateManagedWidget("Label",
                                labelWidgetClass, jumpby_pop, args, 5);

        XtSetArg(args[0],XtNlist,jumpby_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,jumpby_header);
        XtSetArg(args[6],XtNfont,font_info2);
        jumpby_buttons = XtCreateManagedWidget("", listWidgetClass,
                                jumpby_pop, args, 7);
        XtAddCallback(jumpby_buttons,XtNcallback, set_jump_selection);

        /* Create the jump direction button */
        XtSetArg(args[0],XtNx,120);
        XtSetArg(args[1],XtNy,80);
        jump_direction_shell = XtCreatePopupShell("jumpShell",
                                overrideShellWidgetClass,
                                frame,args,2);

        /* Create jump by menu form. */
        XtSetArg(args[0],XtNwidth,0);
        jump_direction_pop = XtCreateManagedWidget("jumpWindow",
                                boxWidgetClass,
                                jump_direction_shell, args, 1);

        XtSetArg(args[1],XtNbackground,black);
        XtSetArg(args[2],XtNforeground,white);
        XtSetArg(args[3],XtNlabel,"Jump By:");
        XtSetArg(args[4],XtNfont,font_info2);
        jumpby_header = XtCreateManagedWidget("Label",
                                labelWidgetClass, jump_direction_pop, args, 5);

        XtSetArg(args[0],XtNlist,jump_direction_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,jumpby_header);
        XtSetArg(args[6],XtNfont,font_info2);
        jump_direction_buttons = XtCreateManagedWidget("", listWidgetClass,
                        jump_direction_pop, args, 7);
        XtAddCallback(jump_direction_buttons,XtNcallback, set_direction_selection);

        /* Create Jump button shell for popup window. */
        action_shell = XtCreatePopupShell("actionShell",
                                        overrideShellWidgetClass,
                                        frame,actionShellArgs,
                                        XtNumber(actionShellArgs));

        /* Create jump window form. */
        action_pop = XtCreateManagedWidget("actionWindow", formWidgetClass,
                                  action_shell, actionPopArgs,
                                  XtNumber(actionPopArgs));

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(action_pop,event_mask,NULL,popdummy,NULL);

E 2
        XtSetArg(args[0],XtNlist,action_list);
        XtSetArg(args[1],XtNdefaultColumns,6);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfont,font_info2);
        action_lister = XtCreateManagedWidget("list", listWidgetClass,
                                action_pop, args, 6);
        XtAddCallback(action_lister,XtNcallback,action_notify_proc);

        /* Create Filter Label */
        XtSetArg(filterLabelArgs[0],XtNfromHoriz,histogram_button);
        XtSetArg(filterLabelArgs[1],XtNhorizDistance,180);
        XtSetArg(filterLabelArgs[2],XtNvertDistance,bottomRow);
        XtSetArg(filterLabelArgs[3],XtNfromVert,NULL);
        XtSetArg(filterLabelArgs[4],XtNlabel,"Filter: ");
        XtSetArg(filterLabelArgs[5],XtNborderWidth,0);
        XtSetArg(filterLabelArgs[6],XtNfont,font_info2);
        filter_label = XtCreateManagedWidget("Filter", labelWidgetClass,
                                      control_widget, filterLabelArgs, 
                                      XtNumber(filterLabelArgs));

        /* Create filter button */
        XtSetArg(quitButtonArgs[0],XtNhorizDistance,1);
        XtSetArg(quitButtonArgs[2],XtNborderWidth,0);
        XtSetArg(quitButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(quitButtonArgs[4],XtNfromHoriz,filter_label);
        XtSetArg(quitButtonArgs[5],XtNlabel,"None  ");
        XtSetArg(quitButtonArgs[6],XtNfont,font_info2);
        filter_button = XtCreateManagedWidget("None  ", commandWidgetClass,
                                     control_widget, quitButtonArgs, 
                                     XtNumber(quitButtonArgs));
        XtAddCallback(filter_button,XtNcallback,popFilter);


        filter_shell = XtCreatePopupShell("filter",
                                        overrideShellWidgetClass, frame,
                                        filterShellArgs,
                                        XtNumber(filterShellArgs));

        filter_pop = XtCreateManagedWidget("menu", formWidgetClass,
                                        filter_shell, NULL, (Cardinal) 0);

I 2
	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(filter_pop,event_mask,NULL,popdummy,NULL);

E 2
        XtSetArg(filterHeaderArgs[1],XtNbackground,black);
        XtSetArg(filterHeaderArgs[2],XtNforeground,white);
        XtSetArg(filterHeaderArgs[3],XtNlabel,"Filter:");
        XtSetArg(filterHeaderArgs[4],XtNfont,font_info2);
        filter_header = XtCreateManagedWidget("Label",
                                        labelWidgetClass, filter_pop,
                                        filterHeaderArgs,
                                        XtNumber(filterHeaderArgs));

        XtSetArg(args[0],XtNlist,filter_table);
        XtSetArg(args[1],XtNdefaultColumns,1);
        XtSetArg(args[2],XtNforceColumns,False);
        XtSetArg(args[3],XtNverticalList,False);
        XtSetArg(args[4],XtNborderWidth,0);
        XtSetArg(args[5],XtNfromVert,filter_header);
        XtSetArg(args[6],XtNfont,font_info2);
        filter_buttons = XtCreateManagedWidget("", listWidgetClass,
                filter_pop, args, 7);
        XtAddCallback(filter_buttons, XtNcallback, filter_notify_proc);

        /* Create quit button */
        XtSetArg(quitButtonArgs[0],XtNhorizDistance,20);
        XtSetArg(quitButtonArgs[2],XtNborderWidth,2);
        XtSetArg(quitButtonArgs[3],XtNvertDistance,bottomRow);
        XtSetArg(quitButtonArgs[4],XtNfromHoriz,filter_button);
        XtSetArg(quitButtonArgs[5],XtNlabel,"Quit");
        XtSetArg(quitButtonArgs[6],XtNfont,font_info2);
        quit_button = XtCreateManagedWidget("command", commandWidgetClass,
                                     control_widget, quitButtonArgs, 
                                     XtNumber(quitButtonArgs));
        XtAddCallback(quit_button,XtNcallback,quit_notify_proc);

        /* Create quit popup shell. */
I 2
/*      quit_shell = XtCreatePopupShell("quitShell",transientShellWidgetClass,*/
E 2
        quit_shell = XtCreatePopupShell("quitShell",overrideShellWidgetClass,
                                        frame,quitShellArgs,
                                        XtNumber(quitShellArgs));
D 2
        
E 2
I 2

E 2
        /* Create the quit window form. */
I 2





E 2
        quit_pop = XtCreateManagedWidget("quitWindow", formWidgetClass,
                                  quit_shell, quitPopArgs,
                                  XtNumber(quitPopArgs));

I 2


	/*  Keep buttonpress events from being delivered to the root window */
        event_mask = ButtonPressMask;
        XtAddEventHandler(quit_pop,event_mask,NULL,popdummy,NULL);
E 2
        /* Create the quit question. */
I 2

E 2
        XtSetArg(quitQuestionArgs[0],XtNlabel,"Do you really want to quit?");
        XtSetArg(quitQuestionArgs[4],XtNfont,font_info2);
        quit_question = XtCreateManagedWidget(NULL,
                                  labelWidgetClass,
                                  quit_pop, quitQuestionArgs, 
                                  XtNumber(quitQuestionArgs));
I 2


E 2

        /* Create the quit quit button. */
        XtSetArg(quitExecuteButtonArgs[0],XtNlabel,"Yes ");
        XtSetArg(quitExecuteButtonArgs[5],XtNfont,font_info2);
        quit_execute_button = XtCreateManagedWidget("quitWindow",
                                  commandWidgetClass,
                                  quit_pop, quitExecuteButtonArgs,
                                  XtNumber(quitExecuteButtonArgs));
        XtAddCallback(quit_execute_button,XtNcallback,execQuit);

        /* Create the quit cancel button. */
        XtSetArg(quitCancelButtonArgs[0],XtNlabel,"NO    ");
        XtSetArg(quitCancelButtonArgs[2],XtNfromHoriz,quit_execute_button);
        XtSetArg(quitCancelButtonArgs[6],XtNfont,font_info2);
        quit_cancel_button = XtCreateManagedWidget("quitWindow",
                                  commandWidgetClass,
                                  quit_pop, quitCancelButtonArgs, 
                                  XtNumber(quitCancelButtonArgs));
        XtAddCallback(quit_cancel_button,XtNcallback,cancelQuit);

        /* create the popup shell and popup widget here */
        key_shell = XtCreatePopupShell("key_shell",wmShellWidgetClass,
                                        frame,keyShellArgs,
                                        XtNumber(keyShellArgs));

        key_pop = XtCreateManagedWidget("", formWidgetClass,
                                        key_shell, keyPopArgs, 
                                        XtNumber(keyPopArgs));

        return(ret_val);
}
#endif
E 1
