h44423
s 00254/00000/00000
d D 1.1 90/10/16 11:03:57 werner 1 0
c date and time created 90/10/16 11:03:57 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/scrollbar.h>
#endif /* sunview */
#ifdef X11
#include "xexterns.h"
#endif
#include "externvars.h"

/*************************************************************
 * This file contains the routines to draw the histogram:
 * 
 ***********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
Scrollbar h_bar;
extern Frame frame;
extern Frame popup_frame;
extern Pixwin *pw, *pw2;
#endif /* sunview */
extern int mode,done;
extern double str_blank_clock;	     /* Start of a blank interval (histogram) */

plot_histogram(type)
int type;
{
/*****************************************
 * histogram updates the histogram 
 * popup canvas using the global 
 * variables initial_clock and curr_procs
 ****************************************/
	int startx,starty,final,tempx;
	double blank_clock_difference;
	char str[40];

	switch (type)
	{
		case 1:	   /* Blank Histogram Update */
		startx = histx;
		starty = histy;
		histx +=  SPACEHIST;
		histy = (175 - (curr_procs * 20));
#ifdef sunview
		pw_vector(pw2,startx,starty-1,histx,histy-1,PIX_SET,1);
		pw_vector(pw2,startx,starty  ,histx,histy  ,PIX_SET,1);
		pw_vector(pw2,startx,starty+1,histx,histy+1,PIX_SET,1);
#endif
#ifdef X11
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty-1, histx, histy-1);
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty, histx, histy);
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty+1, histx, histy+1);
#endif
		blank_clock_difference = (program_clock - str_blank_clock);
		/* More than 100 blank intervals */
		if (blank_clock_difference/clock_interval > 100)
		{
			/* Break Histogram */	
#ifdef sunview
			pw_vector(pw2,histx,15,histx,175,PIX_SET,1);
#endif
#ifdef X11
			XDrawLine(hist_display,hist_win,control_gc,
				histx, 15, histx, 175);
#endif
			histx += (SPACEHIST * 2);
			/* Break Histogram */	
#ifdef sunview
			pw_vector(pw2,histx,15,histx,175,PIX_SET,1);
#endif
#ifdef X11
			XDrawLine(hist_display,hist_win,control_gc,
				histx, 15, histx, 175);
#endif
			sprintf(str,"%-.0f",(program_clock-initial_clock));
		} else /* Draw 'em out */
		{
			startx = histx;
			starty = histy;
			final = startx +
			((int)(blank_clock_difference/clock_interval)) * SPACEHIST;
			for(tempx = histx ; tempx <= final ; tempx += SPACEHIST)
			{
				/* this keeps histx correct after last iterate*/
				histx = tempx;
				histy =	 (175 - (curr_procs * 20));
#ifdef sunview
				pw_vector(pw2,startx,starty-1,histx,histy-1,PIX_SET,1);	    
				pw_vector(pw2,startx,starty  ,histx,histy  ,PIX_SET,1);	    
				pw_vector(pw2,startx,starty+1,histx,histy+1,PIX_SET,1);	    
#endif
#ifdef X11
				XDrawLine(hist_display,hist_win,control_gc,
					startx, starty-1, histx, histy-1);
				XDrawLine(hist_display,hist_win,control_gc,
					startx, starty, histx, histy);
				XDrawLine(hist_display,hist_win,control_gc,
					startx, starty+1, histx, histy+1);
#endif
				startx = histx;
				starty = histy;
				if (histx%400 == 0)
				{
					sprintf(str,"%-.0f",(program_clock-initial_clock));
#ifdef sunview
					/* Print interval */
					pw_text(pw2,histx,191,PIX_SCR,0,str);
#endif
#ifdef X11
					XDrawString(hist_display,hist_win,
						control_gc, histx, 191,
						str, strlen(str));
#endif
				}
			}
		}
	break;
	case 2: /* Normal Histogram Update */
		startx = histx;
		starty = histy;
		histx +=  SPACEHIST;
		histy = (175 - (curr_procs * 20));
#ifdef sunview
		pw_vector(pw2,startx,starty-1,histx,histy-1,PIX_SET,1);
		pw_vector(pw2,startx,starty  ,histx,histy  ,PIX_SET,1);
		pw_vector(pw2,startx,starty+1,histx,histy+1,PIX_SET,1);
#endif
#ifdef X11
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty-1, histx, histy-1);
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty, histx, histy);
		XDrawLine(hist_display,hist_win,control_gc,
			startx, starty+1, histx, histy+1);
#endif
	break;
	}
    
	if (histx%400 == 0)
	{
		sprintf(str,"%-.0f",(program_clock-initial_clock));
		/* Print interval */
#ifdef sunview
		pw_text(pw2,histx,191,PIX_SCR,0,str);
#endif
#ifdef X11
		XDrawString(hist_display,hist_win,control_gc,
			histx, 191, str, strlen(str));
#endif
	}	

#ifdef sunview
	if (histx >= 700)
	{
		scrollbar_scroll_to(h_bar,histx-700);
	}
#endif
#ifdef X11
	if ( histx >= (move_hist-100) )
	{
		XtMoveWidget(inner_hist,-(move_hist-700),0);
		move_hist += 80;
	}
#endif
	if (histx >= MAXHIST)
	{
		initialize_histogram();
	}
}

initialize_histogram()
{
	int i;

#ifdef sunview
	clearscreen(pw2,HISTX,HISTY);
	scrollbar_scroll_to(h_bar,0);
#endif 
#ifdef X11
	XClearWindow(hist_display,hist_win);
	XtMoveWidget(inner_hist,0,0);
	move_hist = 700;
#endif
	histx = SPACEHIST * 2;
	histy = 175;
#ifdef sunview
	pw_text(pw2,histx,191,PIX_SCR,0,"0");		/* Print interval */
	pw_vector(pw2,0,15,MAXHIST,15,PIX_SET,1);   /* draw upper bound	 - 8 processors */	
	pw_vector(pw2,0,55,MAXHIST,55,PIX_SET,1);	/* 6 processors */
	pw_vector(pw2,0,95,MAXHIST,95,PIX_SET,1);	/* 4 processors */
	pw_vector(pw2,0,135,MAXHIST,135,PIX_SET,1);	/* 2 processors */
	pw_vector(pw2,0,175,MAXHIST,175,PIX_SET,1);	/* 0 processors */
#endif
#ifdef X11
	XDrawString(hist_display,hist_win,control_gc,
		histx, 191, "0", 1);
	XDrawLine(hist_display,hist_win,control_gc,
		0, 15, MAXHIST, 15);
	XDrawLine(hist_display,hist_win,control_gc,
		0, 55, MAXHIST, 55);
	XDrawLine(hist_display,hist_win,control_gc,
		0, 95, MAXHIST, 95);
	XDrawLine(hist_display,hist_win,control_gc,
		0, 135, MAXHIST, 135);
	XDrawLine(hist_display,hist_win,control_gc,
		0, 175, MAXHIST, 175);
#endif

	for(i=0;i<= (MAXHIST/SPACEHIST);i=i+100)	/* Draw processor ids */
	{
#ifdef sunview
		pw_text(pw2,(i*SPACEHIST),13,PIX_SCR,0,"8");
		pw_text(pw2,(i*SPACEHIST),53,PIX_SCR,0,"6");
		pw_text(pw2,(i*SPACEHIST),93,PIX_SCR,0,"4");
		pw_text(pw2,(i*SPACEHIST),133,PIX_SCR,0,"2");
#endif
#ifdef X11
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 13, "8", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 53, "6", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 93, "4", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 133, "2", 1);
#endif
	}
}
E 1
