h18957
s 00489/00000/00000
d D 1.1 90/10/16 11:03:38 werner 1 0
c date and time created 90/10/16 11:03:38 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/canvas.h>
#include <suntool/panel.h>
#include <suntool/scrollbar.h>
#include "externvars.h"

/***********************************************************
 * This file contains the routines to handle the drawing
 * of the various nodes of the graph, the process icons,
 * and the view box. 
 *
 * Five types of process icons exist:
 *	B process icon - Bound process
 *	U process icon - Unbound process
 *	I process icon - Idle process
 *	S process icon - Suspended process
 *	R process icon - Reacquired process
 * The process icons were defined in the Icon Editor as
 * 64x64 pixrects.  The visible portion of the icon is
 * 48x48.  Icons are displayed via the raster operations
 * from a pixrect to a pixwin.
 *
 **********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern Pixwin *pw,*pwf,*stpw;
extern Panel_item task_count, process_count;
extern Pixrect dotted;
extern Pixrect lightbox,startbox;
extern Pixrect resumebox,barrierbox;
extern Pixrect blankbox, emptybox;
extern Pixrect completebox,recoverbox;
extern Pixrect punbind,pbind,pidle,psuspend,preacq;
extern struct pixfont *node_font;
extern Scrollbar h_bar, pcv_bar;

draw_bound_state(id)
int id;
{
/**********************************
 * indicates that a 
 * process has been assigned to the
 * task by enclosing the line with
 * a double line.
 **********************************/

    int x1,x2,y; 
    int endy;

    x1 = tasks[id].x + (COLUMNWIDTH/2) - LINESEP;
    x2 = tasks[id].x + (COLUMNWIDTH/2) + LINESEP;
    y = ypos;
    endy = y + NODEHEIGHT;
    if(( real_clock - tasks[id].last_time_log) > idle_interval)
    {
	pw_rop(pw,x1,y,16,16,(PIX_SRC | PIX_DST),&dotted,0,0);
	pw_rop(pw,x2,y,16,16,(PIX_SRC | PIX_DST),&dotted,0,0);
    } else
    {
	pw_vector(pw,x1,y,x1,endy,PIX_SET,1);
	pw_vector(pw,x2,y,x2,endy,PIX_SET,1);
    }
}

	      
draw_wait_state(id)
int id;
{
/****************************************
 * displays a dotted or
 * solid line depending on whether or
 * not the task is waiting (dotted) or
 * ready to run (solid).
 ***************************************/
    int x,y, endy;
    float fx, fy, fendy;
    Pr_texture texture;
    Pr_brush brush;

    x = tasks[id].x + (COLUMNWIDTH/2);
    y = ypos;
    endy = y + NODEHEIGHT;
    if (tasks[id].wait_state != 0) {
/*	texture.pattern = pr_tex_dotted;
	brush.width = 1;
	pw_line(pw,x,y,x,endy,&texture,&brush,PIX_SET); */
	pw_rop(pw,x,y,16,16,(PIX_SRC | PIX_DST),&dotted,0,0);
    }
    else 
      pw_vector(pw,x,y,x,endy,PIX_SRC,1);
}


draw_process()
{
/*****************************************
 * draw_process draws or updates the 
 * process icon for the current process.
 * Process icons are displayed only in
 * the Primary Canvas - and always on 
 * the first row.
 ****************************************/
    int x,y;
    char str[10];

    x = procs[curr_process].x;
    y = procs[curr_process].y;
    switch(procs[curr_process].state)  {
      case -1:	 /* process is not yet acquired */
	break;
      case 0 :	/* process is idle */
	pw_rop(pwf,x,y,PROCDIM+36,50,PIX_CLR,NULL,0,0);	    /* clear old task id */
	pw_rop(pwf,x,y,PROCDIM,PROCDIM,PIX_SRC,&pidle,0,0);
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	pw_text(pwf,x,y+60,PIX_SCR,0,str);
	break;
      case 1 : /* process is suspended */
	pw_rop(pwf,x,y,PROCDIM+36,50,PIX_CLR,NULL,0,0);	    /* clear old task id */
	pw_rop(pwf,x,y,PROCDIM,PROCDIM,PIX_SRC,&psuspend,0,0);
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	pw_text(pwf,x,y+60,PIX_SCR,0,str);
	break;
      case 2 : /* process is reaquired */
	pw_rop(pwf,x,y,PROCDIM+36,50,PIX_CLR,NULL,0,0);	    /* clear old task id */
	pw_rop(pwf,x,y,PROCDIM,PROCDIM,PIX_SRC,&preacq,0,0);
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	pw_text(pwf,x,y+60,PIX_SCR,0,str);
	break;
      case 3 : /* process is bound */
	pw_rop(pwf,x,y,PROCDIM+36,50,PIX_CLR,NULL,0,0);	    /* clear old task id */
	pw_rop(pwf,x,y,PROCDIM,PROCDIM,PIX_SRC,&pbind,0,0);
	pw_rop(pwf,x,y,48,48,PIX_NOT(PIX_DST),NULL,0,0);
	sprintf(str,"<-- %d", procs[curr_process].task);
	pw_text(pwf,x+50,y+24,PIX_SCR,0,str);
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	pw_text(pwf,x,y+60,PIX_SCR,0,str);
	break;
      case 4 : /* process is unbound */
	pw_rop(pwf,x,y,PROCDIM+36,50,PIX_CLR,NULL,0,0);	    /* clear old task id */
	pw_rop(pwf,x,y,PROCDIM,PROCDIM,PIX_SRC,&punbind,0,0);
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	pw_text(pwf,x,y+60,PIX_SCR,0,str);
	break;
      default : display_message("Unknown process state\n");
    }
}


draw_event(id)
int id;
{
/******************************************
 * draw_event draws a node appropriate to
 * the posted event of the task.
 *****************************************/
    int x,y,endx;
    int action_no;
    char str[20];
    extern int act_file_present;

    x = tasks[id].x - 10;
    y = ypos;	
    action_no = tasks[id].post_event;

    /* filter to the appropriate switches for the drawing */
/********
    if (((action_no >= 128) && (action_no <= 133)) || (action_no == 160))
	special_draw_switch(id);
    else if (((action_no >= 160) && (action_no <= 183)) ||
	((action_no >= 256) && (action_no <= 300)) ||
	(action_no == 144) )
    {
	    pw_text(pw,x+5,y+12,PIX_SCR,node_font,node_str);
	    pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
    } else
    {
	sprintf(str,"%d",action_no);
	pw_text(pw,x + 20,y + NODEHEIGHT - 3,PIX_SCR,0,str);
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&blankbox,0,0);
    }
********/
    switch (action_no) {
    case LIGHT:		case START:
    case COMPLETED:	case RECOVER:
    case BIND:		case UNBIND:
    case TWAIT:
	special_draw_switch(id);
	break;
    case LASSIGN:	case LRELEASE:		case LWAIT:
    case LNWAIT:	case LRESUME:		case LCLEAR:
    case LTEST:
    case EWAIT:		case ENWAIT:		case ERESUME:
    case ECLEAR:	case EPOST:		case EASSIGN:
    case ERELEASE:	case ETEST:
    case TTEST:		case TNWAIT:		case TRESUME:
    case BASSIGN:	case BRELEASE:		case BWAIT:
    case BNWAIT:	case BRESUME:
    case GNWAIT:	case GNRESUME:		case GWAIT:
    case GRESUME:
    case SINIT:

/*  The following case variables are current reserved for user buffers in
 *  CRAY dumps.	  In the future they may be used for microtasing.   Until
 *  then they should be treated as user buffer variables when coming from
 *  CRAY tracefiles. */
#ifdef CTSSTRACE			/* This is for TIR 11770 */
    case MSTARTF:
    case MWAITF:
    case MRESUMEF:
    case SSTARTF:
    case SEXIT:
    case CSWAIT:
    case CSRESUME:
#endif
    case CSNWAIT:
	case SWAITW:		
    case REQUEST:
#ifdef CRAYTRACE	/* COS only */
    case REQUEST_NA:
#endif CRAYTRACE
	if(filter_display == 0)
	{
		pw_text(pw,x+5,y+12,PIX_SCR,node_font,node_str);
		pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
	} else if(filter_display == 1 && action_no < GNWAIT)
	{
		pw_text(pw,x+5,y+12,PIX_SCR,node_font,node_str);
		pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
	} else if (event_error > 0)
	{
		sprintf(str,"X:%d",error_count);
		pw_text(pw,x + 20,y + NODEHEIGHT - 3,PIX_SCR,node_font,str);
		pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
	} else
	{
		draw_wait_state(id);
		if(tasks[id].process_state != -1)  /* bound */
			draw_bound_state(id);
		switch(action_no)
		{
		  case BWAIT: case LWAIT: case MWAITF: case SWAITW:
		  case CSWAIT: case EWAIT:
		    pw_text(pw,x+5,y+12,PIX_SCR,node_font,node_str);
		    pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
		}
	}
	break;
    default:
	if(action_no != -1)
	{
	if(act_file_present > 0)
	{
		lookup(action_no, str);
	} else
	{
		sprintf(str,"%d",action_no);
	}
	pw_text(pw,x + 20,y + NODEHEIGHT - 3,PIX_SCR,0,str);
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&blankbox,0,0);
	}
	break;
    }
#ifdef CRAYTRACE
    tasks[id].post_event = -1;
#endif CRAYTRACE
#ifdef CTSSTRACE
    tasks[id].post_event = 0;
#endif CTSSTRACE
    tasks[id].aux_item = 0;
    sprintf(node_str,"");
}


special_draw_switch(id)
int id;
{
/******************************************************
 * special_draw_switch draws the nodes which require
 * special pixrects, or additional lines to be drawn.
 * These include task actions such as Light, Start,
 * Complete, Recover, Bind, Unbind, and Wait Task
 *****************************************************/
    int x,y,endx;
    int action_no;
    char str[30];

    x = tasks[id].x - 10;
    y = ypos;	
    action_no = tasks[id].post_event;

    switch (action_no)	{
      case LIGHT :
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&lightbox,0,0);
/*  can be decided later light/start or start/light or light 
	ypos += NODEHEIGHT;
	pw_text(pw,tasks[1].x+37,ypos+11,PIX_SCR,node_font,"1");
	pw_rop(pw,tasks[1].x - 10,ypos,RECTX,RECTY,PIX_SRC | PIX_DST,&startbox,0,0);
*/
	draw_process();
	break; 
     case START : 

	sprintf(str,"%d",id);
	pw_text(pw,x+43,y+11,PIX_SCR,node_font,str);
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&startbox,0,0);

	/* draw line to task waiting on */
	endx = tasks[tasks[id].parent].x + (COLUMNWIDTH/2);
	if (endx > x) {
	    pw_vector(pw,x+60,y+7,endx,y+7,PIX_SET,1);
	    pw_vector(pw,x+60,y+8,endx,y+8,PIX_SET,1);		 
	}
	else  {
	    pw_vector(pw,x,y+7,endx,y+7,PIX_SET,1);
	    pw_vector(pw,x,y+8,endx,y+8,PIX_SET,1);
	}
	break;
      case COMPLETED :
	draw_process();
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC,&completebox,0,0);
#ifdef CRAYTRACE /* we don't have RECOVERS the COMPLETE is the end */
	screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
	tasks[curr_id].x = 0;
#endif CRAYTRACE
	break;
      case RECOVER : 
	pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC,&recoverbox,0,0);
	screen[pixel_to_array(tasks[curr_id].x)].taskid = 0;
	tasks[curr_id].x = 0;
	break;
      case BIND :
	draw_wait_state(id);
	draw_bound_state(id);
	draw_process();
	break;
      case UNBIND :
	draw_wait_state(id);
	draw_process();
	break;
      case TWAIT :
	if(filter_display < 2 )
	{
		sprintf(str,"WT :%2d",tasks[id].wait_state);
		pw_text(pw,x+5,y+12,PIX_SCR,node_font,str);
		pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
	} else if (event_error > 0) 
	{
		sprintf(str,"X:%d",error_count);
		pw_text(pw,x + 20,y + NODEHEIGHT - 3,PIX_SCR,0,str);
		pw_rop(pw,x,y,RECTX,RECTY,PIX_SRC | PIX_DST,&emptybox,0,0);
	} else
	{
		draw_wait_state(id);
		if(tasks[id].process_state != -1)  /* bound */
			draw_bound_state(id);
	}
	/* draw line to task waiting on */
/* works properly - commented out because Scott didn't like it */
#ifdef CTSSTRACE
	if( filter_display > 1 )
	{
		endx = tasks[tasks[id].wait_state].x + (COLUMNWIDTH/2); 
		if (endx > x)
		{
			pw_vector(pw,x+30,y+6,endx,y+6,PIX_SET,1);
			pw_vector(pw,x+30,y+8,endx,y+8,PIX_SET,1);
			sprintf(str,">||");
			pw_text(pw,endx-10,y+11,PIX_SRC | PIX_DST,0,str);
		} else
		{
			pw_vector(pw,x+30,y+6,endx,y+6,PIX_SET,1);
			pw_vector(pw,x+30,y+8,endx,y+8,PIX_SET,1);
			sprintf(str,"||<");
			pw_text(pw,endx-10,y+11,PIX_SRC | PIX_DST,0,str);
		}
	}
#endif CTSSTRACE
	break;
      default :
	break;
    }
}

check_value(addr,type)
int addr, type;
{
/*******************************************
 * check_value takes an address and a type 
 * (1=lock,0=event) and returns with the 
 * value that has already been assigned to
 * that lock or event, or a new value. 
 * This is meant to provide the user with
 * a more comprehensive display - containing
 * labels for locks, versus numbers.
 *******************************************/
    int i;

    if (type == 2) {		/* is a barrier */
	for (i=0; (barriers[i] != -1) && (i < MAXVALUES);i++)
	  if (barriers[i] == addr)
	    return(i);
	
	/* did not find the address, therefore add it in */
	barriers[i] = addr;
	return(i);
    }
    else if (type == 1) {		/* is a lock */
	for (i=0; (locks[i] != -1) && (i < MAXVALUES);i++)
	  if (locks[i] == addr)
	    return(i);
	
	/* did not find the address, therefore add it in */
	locks[i] = addr;
	return(i);
    }
    else  {   /* is an event */
	for (i=0; (events[i] != -1) && (i < MAXVALUES);i++)
	  if (events[i] == addr)
	    return(i);

	/* did not find the address, therefore add it in */
	events[i] = addr;
	return(i);
    }
}
	    
void
draw_timestamp(x,y)
    int x,y;
{
    char str[40];
    double dummy;
    struct pixfont *display_font;

    display_font = pf_open("/usr/lib/fonts/fixedwidthfonts/screen.r.12");
    dummy = (program_clock - initial_clock);
    sprintf(str,"%-.0f", dummy);
    pw_text(pw,x,(y + NODEHEIGHT- 4),PIX_SCR,display_font,str);
}
#endif
E 1
