h59852
s 00725/00000/00000
d D 1.1 90/10/16 11:03:33 werner 1 0
c date and time created 90/10/16 11:03:33 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif /* sunview */
#include <stdio.h>
#ifdef sun
#include <sys/file.h>
#endif
#include "externvars.h"
#ifdef X11
#include "xexterns.h"
#endif
#if CRAY2 || CRAY
#define L_SET 0 /* set the seek pointer */
#define L_INCR 1/* increment the seek pointer */
#define L_XTND 2/* extend the file size */
#endif
#include "log_entry.h"
#ifdef CTSSTRACE
short last_usr_len[MAX_BACKUP];		/* size of last read user action data */
#endif
int len=0;				/* length of last aux data read */
char str[80];

#define BUFSIZE 10	   /* Maximum 32 bit words to buffer */

/* ********************************************************************** */
/* This file contains various routines for interaction with the user
 * ********************************************************************** */

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.	All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/


#ifdef sunview
extern Panel_item event_count,process_count,task_count,clock_count;
#endif /* sunview */

/***********************************************************
 * significant_input reads the next significant event
 ***********************************************************/
significant_input(event_count_update)
{
    int error = 0, skipevent = 1;
    
    while ((error == 0) && (skipevent == 1)) {
	error = data_input(event_count_update);
	if (!error) {
		skipevent = check_nonpost_events();
		if (skipevent) {
			real_clock = last_real_clock;	/* ignore it's clock */
		}
	}
    }
    if (error) {
	return(-1);
    } else {	
	return(0);
    }
}

#ifdef CRAYTRACE
SNAP node_root;
SNAP node_ll;
static int snap_RATE = 500; /* the rate at which to take a snap shot for jumping backwards */
#endif CRAYTRACE

data_input(event_count_update)
{
/************************************************************
 * data_input reads the data from the file or the socket and
 * fills the global variables so that process_task can
 * be called.
 ***********************************************************/
    int cc, first, secnd, aux_data_len, i;
    unsigned int length(), action(), process(), number();
    unsigned int buf[BUFSIZE];
    double sbuf[3];
    double data(), clock();
    char tstr[20];	/* store the ascii clock value on error */
#ifdef CTSSTRACE
    last_usr_len[curr_events%MAX_BACKUP]=len;
data_input:
#endif CTSSTRACE

	   /* Read the first 32 bit word   */
    cc = read(fp,(char *)&log_entry,sizeof(log_entry));	 
    if (cc == 0) {  /* at EOF */
	display_message("End of Tracefile - EOF\n");
	close(fp);
	done = 1;
	go = 0;
	return(-1);
    }
#ifdef CTSSTRACE
    len = log_entry.len;		/* Number of 64 bit words	*/
    if(len == 0) goto data_input;	/* bypass garbage at begin of file */
#endif
    /* check the last real clock against this real clock for sanity sake.
     * the trace files have been know to get out-of-wack.  Make sure their 
     * sane.   Print the warning once, but keep processing the trace file. */
    if( real_clock < last_real_clock )
    {
	if( clock_error == 0 )
	{
	    strncpy(str,"REAL TIME out of order starting at: ",40);
	    sprintf(tstr,"%f\n",real_clock);
	    strncat(str,tstr,40);
	    display_message(str);
	    clock_error = 1;
	}
    }
    
#ifdef CRAYTRACE
    len = LOG_ENT_LEN;			/* Number of 64 bit words	*/
#endif
    curr_action	    = log_entry.actno;	/* Action number for this event */
    curr_id	    = log_entry.tid;		/* Task ID */
    last_real_clock = real_clock;	/* Keep the last clock around */
#if sun
    real_clock	    = clock(log_entry.clock_hi,log_entry.clock);
#endif
#if CRAY2 || CRAY
    real_clock	    = log_entry.clock;
#endif
#ifdef DEBUG
	printf("%3d   %3d   %10d   %10d\n", curr_action, curr_id, last_real_clock, real_clock);
#endif
#ifdef CRAYTRACE
    /* any curr_actions of -1 are invalid.  It just happens that -1 is put
     * in the trace file to detect the tracefile wrap around condition. */
    if( curr_action == -1 )
	display_message("DETECTED PARTIAL TRACE FILE OR UNREADABLE TRACEFILE.\n");
#endif

    tasks[curr_id].last_time_log = real_clock;

    curr_events++;			/* update number of events */
    sprintf(str,"Events Processed: %d",curr_events-1);
#ifdef sunview
    panel_set(event_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
    XClearArea(control_display,control_win,424,75,150,13,True);
    XDrawString(control_display,control_win,canvas_gc,424,85,
	    str,strlen(str));
#endif

#ifdef CTSSTRACE
    curr_process    = log_entry.pid;	/* Process ID */
    if( curr_process >= MAXPROCS) {
	display_message("data_input.c: No available procs[] entries\n");
	/*close(fp);*/
	done = 1;
	go = 0;
	return(-1);
    }
    if (curr_action == COMPLETED )	/* kludge 'till Bruce Kelly's MAT bug fix */
      curr_id = procs[curr_process].task;
    
    if (curr_action == 0) {
	display_message("End of Tracefile - action == 0\n");
	close(fp);
	done = 1;
	go = 0;
	return(-1);
    }
    aux_data_len = len - 2;		/* Number of 64 bit aux data words.  */
    cc = read(fp,buf,aux_data_len*8);
    for(i = 0; i < aux_data_len; i++) {
	first = buf[2*i];
	secnd = buf[2*i+1];
	if(i==0) curr_owner = (int)secnd;
	if(i==3) curr_cs = (int)secnd;
	aux_data[i] = data(first, secnd);
    }
#endif
#ifdef CRAYTRACE
#if sun
    aux_data[0] = data(log_entry.hi_user,log_entry.lo_user);
#endif
#if CRAY2 || CRAY
     aux_data[0] = log_entry.lo_user;
#endif
     /* this is how we have to do our back jumping */
     if( (curr_events % snap_RATE) == 0 )
     {
	/* take a snap shot of the proc table, the task table,
	   event count and position in the file pointer */
	snap_shot();
     }

    switch (curr_action) {
    case START:
	/*
	 * for CRAY traces, we have no LIGHT function, but there should
	 * be a dummy TSKSTART on task 0.
	 */
	if ((real_clock == 0.0) && (curr_events == 1)) {
		curr_action = LIGHT;	/* Dummy up LIGHT entry */
		curr_process = 0;
	}
	break;
    case COMPLETED:
	break;
    case ACQUIRE:
	/* find an empty procs[] table entry for the new proc */
	for (i = 0; i < MAXPROCS; i++) {
		if (procs[i].state == -1) {
			break;
		}
	}
	if (i == MAXPROCS) {
		display_message("ERROR: No available procs[] entries\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}

	curr_process = i;
	procs[curr_process].pid = log_entry.lo_user;
	break;

    case BIND:
    case UNBIND:
    case REQUEST:
    case REQUEST_NA:
    case RELEASE:
    case RELEASE_NA:
    case SUSPEND:
    case SUSPEND_NA:
    case REQSUS:
    case REQSUS_NA:
    case IDLE:
	/* find the procs[] table entry matching this pid */
	for (i = 0; i < MAXPROCS; i++) {
	    if (procs[i].pid == log_entry.lo_user) {
		 break;
	    }
	}
	if (i == MAXPROCS) {
	    /* catch the startup pid0 case */
	    if (procs[0].pid == 0) {
		i = 0;
		procs[0].pid = log_entry.lo_user;
	    } else {
		display_message("ERROR: Process not found\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	    }
	}
	curr_process = i;
	switch (curr_action) {
	case REQUEST:
	case REQUEST_NA:
	case RELEASE:
	case RELEASE_NA:
	case SUSPEND:
	case SUSPEND_NA:
	case REQSUS:
	case REQSUS_NA:
	case ACQUIRE:
	    /* XMP traces do not have a "current-task" when doing some*/
	    /* functions, so conjure one up.		*/
	    if (curr_id == 0) {
		curr_id = procs[curr_process].task;
	    }
	    break;
	default:
	    break;
	}
	break;

    default:
	/* Zero is an invalid task number but they are in the trace file. 
	 * Ignore them when you encounter them with a case that's based on
	 * tid's. */
	if( log_entry.tid != 0 )
	{
		/* find the proc to which this task should be connected */
		for (i = 0; i < MAXPROCS; i++) {
#ifdef DEBUG
			fprintf(stderr,"%d: task = %d tid = %d\n",
				i, procs[i].task, log_entry.tid);
#endif
			if (procs[i].task == log_entry.tid) {
				break;
			}
		}
		if (i == MAXPROCS) {
			display_message("ERROR: Process/task connect mismatch\n");
			close(fp);
			done = 1;
			go = 0;
			return(-1);
		}
	}
	curr_process = i;
    }

#endif

#ifdef DATAPRINT
    dataprint();
#endif DATAPRINT
    if( direction == 0) event_error = check_action();
    return(0);
}

#define POW 4294967296.0   /* 32 bit offset */ 
#if sun
double clock(first, secnd)
unsigned int first, secnd;
{
    unsigned int  msk, lsb;
    double clk, msb, pow = POW;

    lsb = secnd;  /* Least signif bits */

    msk = first & 0x3ff;    /* mask to get first 9 bits */
    msb = (double)msk * pow; /* shift by 32 bits */
    clk = msb + lsb;

    return(clk);
}
#endif


double data(first,secnd)
unsigned int first, secnd;
{
    unsigned int lsb;
    double ldata, msb, pow = POW;

    lsb = secnd;		 /* Least signif. bit */
    msb = (double)first * pow;	/* shift by 32 bits */
    ldata = msb + lsb;
    return(ldata);
}


data_seek(choice,text)
    int choice;
    int text;
{
/****************************************************************************/
/*  seeks backward in trace file one log_entry at a time until		    */
/*   jump condition is satisfied					    */
/****************************************************************************/
    long backup_amt;
    long result=0, orig_pos;
    int save_curr_events, orig_tasks, orig_procs, orig_events;
    double save_init_clock;
    int save_curr_id;
    int backup=0;
    int bypass;	    /* too be sure new action will be before present action */

    orig_pos=lseek(fp,0,L_INCR);
    orig_tasks = curr_tasks;
    orig_procs = curr_procs;
    orig_events = curr_events;
 
#ifdef CRAYTRACE
    backup_amt = - (sizeof(log_entry));
#endif
    switch (choice) {
      case 2:  /* Find by Action Number */
	if (++backup >= MAX_BACKUP) {
	  sprintf(str,"Exceeded maximum backup allowed = %d",MAX_BACKUP);
	  display_message(str);
	  break;
	}
	bypass=0;
	while(	 (bypass++ <= 2 )  ||
		(!done && (curr_action != text) && (result >= 0) 
		&& (!button_hit()) ) ) {
#ifdef CTSSTRACE
	  backup_amt = - (sizeof(log_entry)+8*(len-2));
#endif
	  result=lseek(fp,backup_amt,L_INCR);
#ifdef CTSSTRACE
	  backup_amt = - (sizeof(log_entry)+8*
		(last_usr_len[(curr_events-1)%MAX_BACKUP]-2));
#endif
	  result=lseek(fp,backup_amt,L_INCR);
	  curr_events -= 2;
#ifdef CTSSTRACE
	  len =last_usr_len[(curr_events)%MAX_BACKUP];
#endif
#ifdef CTSSTRACE
	  data_input();
#endif CTSSTRACE
#ifdef CRAYTRACE
	  get_task_and_action();
#endif CRAYTRACE
	}
#ifdef CRAYTRACE
	  text = curr_events;
	  jump_back_to_event(text);
	  jump_to_event(text);
#endif CRAYTRACE
	  break;
      case 1:  /*  Find by Task Number */
	curr_id = -2;
	while(!done && (curr_id != text) && (result >= 0 )
		&& (!button_hit() )) {
#ifdef CTSSTRACE
	  backup_amt = - (sizeof(log_entry)+8*(len-2));
#endif
	  result=lseek(fp,backup_amt,L_INCR);
#ifdef CTSSTRACE
	  backup_amt = - (sizeof(log_entry)+8*
		(last_usr_len[(curr_events-1)%MAX_BACKUP]-2));
#endif
	  result=lseek(fp,backup_amt,L_INCR);
	  curr_events -= 2; 
#ifdef CTSSTRACE
	  len =last_usr_len[(curr_events)%MAX_BACKUP]; 
#endif
#ifdef CTSSTRACE
	  data_input(); 
#endif CTSSTRACE
#ifdef CRAYTRACE
	  get_task_and_action();
#endif CRAYTRACE
	} 
#ifdef CRAYTRACE
	  text = curr_events;
	  jump_back_to_event(text);
	  jump_to_event(text);
#endif CRAYTRACE
	  break; 
      case 0:  /*  Find by Event Count */
#ifdef CTSSTRACE
	if (text > curr_events) result = -1;
	while(!done && (curr_events > text) && (result >= 0)
		&& (!button_hit() )) {
	  backup_amt = - (sizeof(log_entry)+8*(len-2));
	  result=lseek(fp,backup_amt,L_INCR); 
	  backup_amt = - (sizeof(log_entry)+8*
		(last_usr_len[(curr_events-1)%MAX_BACKUP]-2));
	  result=lseek(fp,backup_amt,L_INCR);
	  curr_events -= 2; 
	  len =last_usr_len[(curr_events)%MAX_BACKUP];
	  data_input(); 
	}
#endif CTSSTRACE
#ifdef CRAYTRACE
	jump_back_to_event(text);
	jump_to_event(text);
#endif CRAYTRACE
	  break;
   
      default:	/*  error */
	display_message("Data_seek:  illegal choice for jump \n");
	close (fp);
	done = 1;
	go = 0;
	return(-1);
 
  
    }
     
    if (result < 0 ) {
      /* File was  not positioned backwards successfully */
      display_message("Data_seek:  Failed to jump back in trace file \n");
   /*	close (fp);
      done = 1;*/
      go = -1 ;	  
      result = lseek(fp,orig_pos,L_SET);   /* reset file to previous position */
      curr_tasks = orig_tasks;
      curr_procs = orig_procs;
      curr_events = orig_events;
      return(0);
    }

#ifdef CTSSTRACE
    backup_amt = - (sizeof(log_entry)+8*(len-2));
#endif
    result=lseek(fp,backup_amt,L_INCR);
    save_curr_events=curr_events-1;
    save_init_clock=initial_clock;
    save_curr_id=curr_id;
#ifdef CTSSTRACE
    initialize();
#endif CTSSTRACE
    curr_events=save_curr_events;
    initial_clock=save_init_clock;
    curr_id=save_curr_id;
#ifdef CTSSTRACE
    len =last_usr_len[(curr_events)%MAX_BACKUP];
#endif

 
}

get_task_and_action()
{
	int cc;

	cc = read(fp,(char *)&log_entry,sizeof(log_entry));
	if (cc == 0) {	/* at EOF */
	    display_message("End of Tracefile - EOF\n");
	    close(fp);
	    done = 1;
	    go = 0;
	    return(-1);
	}
	curr_action	= log_entry.actno;  /* Action number for this event */
	curr_id		= log_entry.tid;	    /* Task ID */
	curr_events++;			/* update number of events */

}

#ifdef CRAYTRACE
jump_back_to_event(text)
int text;
{
	SNAP node;
	SNAP last_node;
	int i;
#ifdef sunview
	extern Panel_item jump_choice, jump_direction;
#endif sunview
#ifdef X11
	Arg args[1];
	extern int jump_choice, jump_direction;
#endif X11

	if(node_root == NULL || text == 0)
	{
		rewind_file();
		return;
	}
	last_node = node_root;

	/* find the last valid record before the event */
	for( node = node_root; ; node=node->next)
	{
		if(node->curr_events > text)
		{
			node = last_node;
			break;
		}
		last_node = node;
		if( node->next == NULL )
			break;
	}
	node = last_node;
	/* reset the file descriptor location */
	if( lseek(fp,node->file_position,0) == -1 )
	{
		display_message("file not repositioned.	 Jump not exectued\n");
		return;
	}
	/* reset to that record. */
	/* set back the snap shot of the procs table */
	for( i = 0;  i < MAXPROCS; i++ )
	{
		procs[i].state = node->proc_table[i].state;
		procs[i].task = node->proc_table[i].task;
		procs[i].pid = node->proc_table[i].pid;
		procs[i].x = node->proc_table[i].x;
		procs[i].y = node->proc_table[i].y;
	}	

	/* set back the snap shot of the task table */
	for( i = 0;  i < MAXTASKS; i++ )
	{
		tasks[i].x = node->task_table[i].x;
		tasks[i].process_state = node->task_table[i].process_state;
		tasks[i].wait_state = node->task_table[i].wait_state;
		tasks[i].post_event = node->task_table[i].post_event;
		tasks[i].parent = node->task_table[i].parent;
	}
	/* set the event_count */
	curr_events = node->curr_events;
	real_clock = node->real_clock;
	 
#ifdef sunview
	panel_set(jump_choice,PANEL_VALUE,0,0);
#ifdef LLNL /* CTSSTRACE */
	panel_set(jump_direction,PANEL_VALUE,0,0);
#endif LLNL /* CTSSTRACE */
#endif sunview
#ifdef X11
	XtSetArg(args[0],XtNlabel,jumpby_table[0]);
	XtSetValues(jumpby_choice,args,1);
	XtSetArg(args[0],XtNlabel,jump_direction_table[0]);
	XtSetValues(jumpDirection_choice,args,1);
#endif X11
	if(curr_events == 0 )
	{
		rewind_file();
	} else 
	{
		data_input(0);
	}
}
#endif CRAYTRACE


#ifdef CRAYTRACE
int biggest_snap = 0;
static int snap_cnt = 0;
int snap_shot()
{
	SNAP node;
	SNAP old_node; /* use in error condition to clean up snap tree */
	unsigned int i;
	struct task_struct *save_task;

	/* don't snap shot what you already have */
	if(jumpingFLAG == 1||(jumpingFLAG == 0 && biggest_snap >= curr_events))
	{
		return;
	}
	node = (SNAP)malloc(sizeof(struct SNAP_type));
	snap_cnt++;
	if( node == (SNAP)NULL || snap_cnt >= 50 )
	{
		node = node_root->next;
		while(node->next != NULL )
		{
			old_node = node;
			node = node->next;
			free(old_node);
		}
		free(node);
		node_root->next = NULL;
		node_ll = node_root;
		snap_cnt = 0;	/* only keep 50 so we don't strain memory too much */
		snap_RATE=snap_RATE*2;
		return; /* in an error just clean up the old and reuse */
	}
	/* set the snap shot of the proc table */
	for( i = 0;  i < MAXPROCS; i++ )
	{
		node->proc_table[i].state = procs[i].state;
		node->proc_table[i].task = procs[i].task;
		node->proc_table[i].pid = procs[i].pid;
		node->proc_table[i].x = procs[i].x;
		node->proc_table[i].y = procs[i].y;
	}

	
	/* set the snap shot of the task table */
	for( i = 0;  i < MAXTASKS; i++ )
	{
		node->task_table[i].x = tasks[i].x;
		node->task_table[i].process_state = tasks[i].process_state;
		node->task_table[i].wait_state = tasks[i].wait_state;
		node->task_table[i].post_event = tasks[i].post_event;
		node->task_table[i].parent = tasks[i].parent;
	}

	/* set the event_count */
	node->curr_events = curr_events;
	node->real_clock = real_clock;
	biggest_snap = curr_events;
	/* get the file descriptor location */
	if( biggest_snap == 0 )
	{
		node->file_position = 0;
	} else
	{
		node->file_position = lseek(fp,0,L_INCR);
	}

	/* set this next to null */
	node->next = NULL;

	/* set the last next to this */
	if( node_root == NULL )
	{
		node_root = node;
		node_ll = node;
	} else
	{
		node_ll->next = node;
		node_ll = node;
	}

}
#endif CRAYTRACE

#ifdef DATAPRINT
dataprint()
{
/*****************************************
 * Used for debugging purposes to verify
 * valid input.
 ****************************************/    

    printf("Action is  %2d;  ", curr_action);
    printf("Process is %d[%2d]\n", procs[curr_process].pid,curr_process);
    printf("Task is    %2d;  ", curr_id);
    printf("RT is %d\n",(long)real_clock);
    if (curr_action == START) printf("Parent is %d\n", aux_data[0]);
}
#endif DATAPRINT
E 1
