static char USMID[] = "@(#)xnotify.c	1.2 10/22/90 13:21:55 LLNL ";
#ifdef X11
#include "xexterns.h"
#include "externvars.h"
#include <string.h>
#include <errno.h>
#ifdef X11R3
#include <X11/List.h>
#else
#include <X11/Xaw/List.h>
#endif

extern int mode,subtree;
extern caddr_t process_count, task_count;

int first_time = 1;		/* needed to set up first proc at init time*/

/**********************************************************************
 * This file contains the routines which handle the notifica-
 * tions from the various buttons on the panel: 
 * go_notify_proc, load_notify_proc, connect_notify_proc, 
 * path_notify_proc, key_notfy_proc, quit_notify_proc,
 * step_notify_proc, stop_notify_proc, subtree_notify_proc,
 * recover_notify_proc,
 * and the routine which handles notifications from the slider
 * on the panel:  e_speed_notify_proc, and the support function
 * do_wait that causes a wait of the specified amount of time.
 * Also file_notify_proc, directory_notify_proc.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

void load_notify_proc()
{
	int err;

	err = open_tracefile(file_table[ft_val]);
	if (err != 0) display_message("Select another tracefile\n");
	first_time = 1;
}

void go_notify_proc()
{
	char str[30];
	int err, x;

	if (done)
	{
		XBell(display_control,0);
		display_message("Have processed all events\n");
	} else if (filepresent)
	{
		go = 1;
		display_message("To Stop: Hit Left Mouse Button\n");
		/* Process each event in turn.  We terminate if the LEFT mouse
		 * button is held down by the user. */
		while (go && (data_input() != -1 ) )
		{
		    if (curr_id != 0 || curr_action == IDLE)   /* not a killer event */
		    {
			do_wait();  
			err = process_task();
			switch (err)
			{
			case 0 : break;  /* all went well */
			case 1 : 
#ifdef DEBUG
				sprintf(str, "Task %d does not exist\n",curr_id);
				display_message(str);
#endif
				break;
			case 2 : break;  /* non-significant action # */
			}	    
			sprintf(str,"Active Processes: %d",curr_procs);
			XClearArea(control_display,control_win,
				ACTIVEX+100,ACTIVEY-10,200,12,True);
			XDrawString(display_control,control_win,control_gc,
				ACTIVEX,ACTIVEY, str, strlen(str));
#ifdef LATER
			x = (SPACEHIST * curr_events);
			if (x <= 700)
			{
				x=0;
			} else
			{
				x = x - 700;
			}
			XtMoveWidget(inner_hist,-(x),0);
#endif LATER
                    }
		    plot_histogram();  /* plot new info to histogram */
		}  
	} else
	{
		display_message("ERROR: No tracefile specified...\n");
		XBell(display_control,0);
	}
}

button_hit()
/* This function returns zero if the LEFT mouse button has not been hit
 * and non-zero if it has.
 */
{
        XEvent report;
	long event_mask;

	event_mask = ButtonPressMask;
	if( XCheckMaskEvent(canvas_display,event_mask,&report) != 0 )
	{
		if( report.type == ButtonPress || report.type == LeaveNotify )
		{
			return(1);
		}
	}
	return(0);
}

void quit_notify_proc()
{
	XWindowAttributes frameAttributes;

	XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
	XtSetArg(args[0],XtNx,frameAttributes.x+483);
	XtSetArg(args[1],XtNy,frameAttributes.y+169);
	XtSetValues(quit_shell,args,2);

	XtPopup(quit_shell,XtGrabNone);
}

void execQuit()
{
	exit(0);
}

void cancelQuit()
{
	XtPopdown(quit_shell);
}


void connect_notify_proc()
{

    display_message("Will handle socket input\n");
    key_enable = 0;
}

void subtree_notify_proc()
{
/************************************************
 * Will cause subtree canvas to be displayed and
 * activated if it is not currently displayed
 * (and in dynamic mode the input must be done),
 * else will remove the display of the subtree
 * canvas.
 ************************************************/
	XWindowAttributes frameAttributes;

	if ((mode == 1) && !done)
	{
		XBell(display_control,0);
		display_message("Cannot draw subtree until input completed\n");
	} else
	{
		if (filepresent) 
		{
			if( subtreeFLAG == 1 )
			{
				subtree = 0;
				XtPopdown(subtree_shell);
				subtreeFLAG = 0;
			} else 
			{    
				subtree = 1;
				if (leftid == -1)
				{
					XBell(display_control,0);
					display_message("ERROR: No node is selected as the root\n");
				} else
				{
					XGetWindowAttributes(display_control,frame_wid,
						&frameAttributes);
					XtSetArg(args[0],XtNx,frameAttributes.x+0);
					XtSetArg(args[1],XtNy,frameAttributes.y+575);
					XtSetValues(subtree_shell,args,2);
					XtPopup(subtree_shell,XtGrabNone);
					subtreeFLAG = 1;
					display_message("Preparing Subtree Canvas...\n");
					subtree_init(); 
				}
			}
		} else 
		{
			display_message("ERROR: No tracefile specified...\n");
			XBell(display_control,0);
		}
	}
}  /* end subtree_notify_proc */


void step_notify_proc()
{

	int err;
	char str[20];

	if (done)
	{
		XBell(canvas_display,0);
		display_message("Have processed all events\n");
	}
	else if (filepresent)
	{
		go = 0;
		if (data_input() != -1)
		{
		    if (curr_id != 0 || curr_action == IDLE)  {  /* not a killer event */

			err = process_task();
			switch (err)
			{
			case 0 : break;  /* all went well */
			case 1 : 
				break;
			case 2 : break;  /* non-significant action # */
			}
			sprintf(str,"Active Processes: %d",curr_procs);
			XClearArea(control_display,control_win,
				ACTIVEX+100,ACTIVEY-10,200,12,True);
			XDrawString(control_display,control_win,control_gc,
					ACTIVEX,ACTIVEY, str, strlen(str));
		    }
		}
		plot_histogram();
	} else
	{
		display_message("ERROR: No tracefile specified...\n");
		XBell(canvas_display,0);
	}
}   /* end step_notify_proc */


void hist_notify_proc(widget, client_data, call_data)
Widget widget; caddr_t client_data; caddr_t call_data;
{

/*******************************************
 * Will cause histogram to be displayed if 
 * it is not displayed already - else will
 * remove the histogram display.
 ******************************************/
	XWindowAttributes frameAttributes;

	if( histFLAG == 0 || histFLAG == 1 )
	{
		XGetWindowAttributes(display_control,frame_wid,&frameAttributes);
		XtSetArg(args[0],XtNx,frameAttributes.x+50);
		XtSetArg(args[1],XtNy,frameAttributes.y+660);
		XtSetValues(hist_shell,args,2);
		XtPopup(hist_shell,XtGrabNone);
		histFLAG = 2;
	} else
	{
		XtPopdown(hist_shell);
		histFLAG = 1;
	}
}

void e_speed_notify_proc(scrollbar,client_data,position)
Widget scrollbar;
caddr_t client_data;
int position;
{
	char str[10];
	char *ptr;
	int e_speed;

	e_speed = abs(position);

	sprintf(str,"[%2f]",((float)e_speed/(float)300)*100);
	ptr = strchr(str,'.');
	strcpy(ptr,"]");

	XClearArea(control_display,control_win,SLIDERX,SLIDERY-10,
		30, 30, True);
	XDrawString(control_display,control_win,control_gc,SLIDERX,SLIDERY,
			str, strlen(str));

#ifdef X11R3
	XtScrollBarSetThumb(e_speed_slider,(float)0.00,(float)e_speed/(float)300);
#else
	XawScrollbarSetThumb(e_speed_slider,(float)0.00,(float)e_speed/(float)300);
#endif
}

void e_speed_notify_thumb(scrollbar,client_data,position)
Widget scrollbar;
caddr_t  client_data;
float position;
{
	char str[15];
	char *ptr;

	e_speed = position*100;
	sprintf(str,"[%2f]",position*100);
	ptr = strchr(str,'.');
	strcpy(ptr,"]");

	XClearArea(control_display,control_win,SLIDERX,SLIDERY-10,
		30, 30, True);
	XDrawString(control_display,control_win,control_gc,SLIDERX,SLIDERY,
			str, strlen(str));

#ifdef X11R3
	XtScrollBarSetThumb(e_speed_slider,(float)0.0,position);
#else
	XawScrollbarSetThumb(e_speed_slider,(float)0.0,position);
#endif
}



do_wait()
{
/***********************************************
 * handles the wait - the maximum wait is
 * MAXWAIT microseconds, and the minimum wait is
 * zero.  The wait will not be exactly MAXWAIT
 * microseconds - rather MAXWAIT is used to 
 * control the spin-wait.   We would have 
 * preferred to avoid a spin-wait - yet wanted
 * to check for mouse input to stop the wait.
 * The Event Speed Slider represents
 * the percentage of maximum speed - thus 
 * 100 means to run as fast as possible.
 **********************************************/
	int num,i;			
	int ret_val = 0;

	num = ((100 - e_speed) * .01 * MAXWAIT);

	for (i=0; i != num && ((ret_val = button_hit()) == 0); i++)
		;
	if( ret_val == 0 )
		ret_val = button_hit();		/* get at 100% */
	if( ret_val == 1 )
		go = 0;
}
    

void file_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
#ifdef X11R3
	ft_val = listp->index;
#else
	ft_val = listp->list_index;
#endif

	XtSetArg(args[0],XtNlabel,file_table[ft_val]);
	XtSetValues(file_choice,args,1);

	XtPopdown(file_shell);
}

void directory_notify_proc(widget, closure, listp)
Widget widget; caddr_t closure; XtListReturnStruct *listp;
{
	char str[200];

#ifdef X11R3
	dt_index = listp->index;
#else
	dt_index = listp->list_index;
#endif

	if( dt_index == 0 )
	{
		strcpy(str,".");
	} else if( dt_index == 1 )
	{
		strcpy(str,"..");
	} else
	{
		strncpy(str,directory_table[dt_index],200);
	}
	if (chdir(str) == -1)
	{
		sprintf(str,"WARNING: chdir failed, errno = %d\n",
				errno);
		display_message(str);
	} else
	{
		dt_index = 0;
		load_directory_table();
	}

	XtPopdown(dir_shell);
	XtSetSensitive(directory_choice,True);
}
#endif
