static char USMID[] = "@(#)xdoevents.c	1.1 10/16/90 11:11:49 LLNL ";
#ifdef X11
#include "xexterns.h"
#include "externvars.h"

/**********************************************************************
 * Handles events in the primary canvas subwindow and the overview
 * subwindow.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

static int nodeFLAG = 0;
void  handle_pcevent(widget, client_data, event)
Widget widget;
caddr_t client_data;
XEvent *event;
{
/*********************************************************
 * handles events in the primary canvas subwindow.
 ********************************************************/
	int x,y,rightid;
	char str[20];
	int localx,localy;
	XEvent *temp;
	
	x = event->xbutton.x;
	y = event->xbutton.y;
	localx = event->xbutton.x;
	localy = event->xbutton.y;
	if (localx > (960 - 175))
	{
		localx = 960 - 175;
	}
	if (localy > (900 - 200))
	{
		localy = 900 - 200;
	}
	switch (event->xbutton.button)
	{
	/* NOTE:  pressing the mouse button down is one event, and 
	   releasing it is another.  If the button is pressed down
	   and released while on a node of the graph - the current
	   node message will be displayed twice.   */
	case 1:  /* MS_LEFT */
#ifdef DEBUG
		printf("Primary Canvas: Left mouse x %d y %d \n",x,y);  
#endif
		leftid = pixel_to_id(x,y);
		if (leftid == -1)
		{
			display_message("Cursor is not positioned on a node\n");
		} else
		{
			sprintf(str,"Current node is %d\n",leftid);
			display_message(str);
		}
		break;
	case 2: /* MS_MIDDLE */
#ifdef DEBUG
		printf("Primary Canvas: Middle Mouse x %d y %d \n",x,y); 
#endif
		break;
	case 3: /* MS_RIGHT */
#ifdef DEBUG
		printf("Primary Canvas: Right mouse x %d y %d \n",x,y); 
#endif
		/* show the canvas on a down motion and hide on an up motion */
		if( nodeFLAG == 0 )
		{
			rightid = pixel_to_id(x,y);
			if (rightid == -1)
			{
				display_message("Cursor is not positioned on a node\n");
			} else
			{
				XClearWindow(node_display,node_win);
				XtPopup(node_shell,XtGrabNone);
				nodeFLAG = 1;
				display_info(rightid);
			}
		} else
		{
			XtPopdown(node_shell);
			nodeFLAG = 0;
		}
		break;
	default:
		break;
	}   /* end switch */
}   /* end handle_event */


void  handle_ovevent(widget, client_data, event)
Widget widget;
caddr_t client_data;
XEvent *event;
{
	int x,y;
	int pcx, pcy;
	char str[20];

	x = event->xbutton.x;
	y = event->xbutton.y;
	switch (event->xbutton.button)
	{
	case 1: /* MS_LEFT */
#ifdef DEBUG
		printf("Overview: Left Mouse x %d y %d \n",x,y); 
#endif
		draw_view_box(x,y);
		if (x > 380)
		{
			x = 380;
		}
		if (y > 280)
		{
			y = 280;
		}
		pcx = (x * SCALEUP) + BORDER;  /* handle border */
		pcy = (y * SCALEUP);
		if (pcx < ((VIEWWIDTH+110)/2))
		{
			pcx = 0;
		} else
		{
			pcx = (pcx - ((VIEWWIDTH+110)/2));
		}
		if (pcy < (VIEWHEIGHT/2))
		{
			pcy = 0;
		} else
		{
			pcy = (pcy - (VIEWHEIGHT/2));
		}
#ifdef DEBUG
		fprintf(stderr,"handle_ovevent: pcx = (%d) pcy = (%d)\n",
			pcx, pcy);
#endif
		XtMoveWidget(inner_canvas,-(pcx),-(pcy));
		break;
	case 2: /* MS_MIDDLE */
#ifdef DEBUG
		printf("Overview: Middle Mouse x %d y %d \n",x,y); 
#endif
		break;
	case 3: /* MS_RIGHT */
#ifdef DEBUG
		printf("Overview: Right mouse x %d y %d \n",x,y); 
#endif
		break;
	default:
		break;
	}   /* end switch */
}   /* end handle_ovevent */


pixel_to_id(x,y)
int x, y;
{ 
/************************************************************
 * Calculate the row and column containing a given x,y 
 * coordinate in the Primary Canvas and determine the node id.
 * Returns -1 if the coords do not correspond to a node.
 ***********************************************************/
	int arrayrefx, arrayrefy, xy_id;

	arrayrefx = ( (x-BORDER) / PCSQUARE ) - ( ( x % PCSQUARE) / PCSQUARE );
	arrayrefy = ( (y-BORDER) / PCSQUARE ) - ( ( y % PCSQUARE) / PCSQUARE );
    
	xy_id = screen[arrayrefx][arrayrefy].id;
    
	if (xy_id == 0)
	{
		return(-1);
	} else
	{
		return(xy_id);
	}
}

void  handle_miscevent(widget,client_data, event)
Widget widget;
caddr_t client_data;
XEvent *event;
{
/*********************************************************
 * handles events in the misc canvas subwindow.
 ********************************************************/

	switch (event->xbutton.button)
	{
	case 1:	/* LEFT */
		break;
	case 2: /* MIDDLE */
		break;
	case 3: /* RIGHT */
		/* Hide the canvas on an up event */
		if( subtreeFLAG == 1 )
		{
			subtreeFLAG = 0;
			XtPopdown(misc_shell);
		}
		break;
	default:
		break;
	}   
}

display_info(id)
int id;
{
/**************************************************
 * Displays information pertaining to the node
 * the user indicated. Information is displayed
 * in a canvas subwindow.
 *************************************************/
	char str[30];
	int i;
	struct act_struct *temp;

	XDrawString(node_display,node_win,node_gc,10,10,
			"NODE INFORMATION", 16);
	sprintf(str,"Task Number: %d",id);
	XDrawString(node_display,node_win,node_gc,10,30,
			str, strlen(str));
	if (id != 1)
	{
		sprintf(str,"Parent Number: %d",tasks[id]->parent);
		XDrawString(node_display,node_win,node_gc,10,45,
			str, strlen(str));
	}
	switch (tasks[id]->state)
	{
	case TWAIT :
		sprintf(str,"Waiting on task %d",tasks[id]->aux_item);
		XDrawString(node_display,node_win,node_gc,10,60,
			str, strlen(str));
		break;
	case EWAIT :
		XDrawString(node_display,node_win,node_gc,10,60,
			"Waiting on event", 16);
		sprintf(str,"  at address %d",tasks[id]->aux_item);
		XDrawString(node_display,node_win,node_gc,10,75,
			str, strlen(str));
		break;
	case LWAIT :
		XDrawString(node_display,node_win,node_gc,10,60,
			"Waiting on lock", 15);
		sprintf(str,"  at address %d",tasks[id]->aux_item);
		XDrawString(node_display,node_win,node_gc,10,75,
			str, strlen(str));
		break;
	case BWAIT :
		XDrawString(node_display,node_win,node_gc,10,60,
			"Waiting on Barrier", 18);
		sprintf(str,"  at address %d",tasks[id]->aux_item);
		XDrawString(node_display,node_win,node_gc,10,75,
			str, strlen(str));
		break;
	case GNWAIT :
		if (tasks[id]->slave == -1)  /* is master */
		{
			sprintf(str,"Master of the Fray");
		} else
		{
			sprintf(str,"Slave for task %d",tasks[id]->slave);
		}
		sprintf(str,"Waiting on Guard %d",tasks[id]->aux_item);
		XDrawString(node_display,node_win,node_gc,10,75,
			str, strlen(str));
		break;
	case GWAIT :
		if (tasks[id]->slave == -1)  /* is master */
		{
			sprintf(str,"Master of the Fray");
		} else
		{
			sprintf(str,"Slave for task %d",tasks[id]->slave);
		}
		XDrawString(node_display,node_win,node_gc,10,60,
			str, strlen(str));
		XDrawString(node_display,node_win,node_gc,10,75,
			"Waiting on Guard", 16);
		break;
	case MSTARTF :
		XDrawString(node_display,node_win,node_gc,10,60,
			"Master Started Fray", 19);
		break;
	case MWAITF :
		XDrawString(node_display,node_win,node_gc,10,60,
			"Master waiting on Fray", 22);
		break;
	case CSWAIT :
		if (tasks[id]->slave == -1) /* is master */
		{
			sprintf(str,"Master of the Fray");
		} else 
		{
			sprintf(str,"Slave for task %d",tasks[id]->slave);
		}
		XDrawString(node_display,node_win,node_gc,10,60,
			str, strlen(str));
		XDrawString(node_display,node_win,node_gc,10,75,
			"Waiting on Control Structure", 28);
		break;
	case SWAITW :
		sprintf(str,"Slave waiting for work");
		XDrawString(node_display,node_win,node_gc,10,60,
			str, strlen(str));
		break;
	case GNRESUME :
	case GRESUME :
	case CSRESUME :
		if (tasks[id]->slave == -1)  /* is master */
		{
			sprintf(str,"Master of the Fray");
		} else
		{
			sprintf(str,"Slave for task %d",tasks[id]->slave);
		}
		XDrawString(node_display,node_win,node_gc,10,60,
			str, strlen(str));
		break;
	default :
		if (tasks[id]->slave == -1)
		{
			XDrawString(node_display,node_win,node_gc,10,60,
				"Master of the Fray", 18);
		} else if (tasks[id]->slave >= 0) 
		{
			sprintf(str,"Slave for task %d",tasks[id]->slave);
			XDrawString(node_display,node_win,node_gc,10,60,
				str, strlen(str));
		}
	}
	XDrawString(node_display,node_win,node_gc,10,93,
		"Most Recent Events", 18);
	XDrawString(node_display,node_win,node_gc,10,105,
		"------------------", 18);
	temp = tasks[id]->actions;
	for (i=0; temp != NULL; i++)
	{
		sprintf(str, "Action Number:  %d",temp->action);
		XDrawString(node_display,node_win,node_gc,5,120+(15*i),
			str, strlen(str));
		temp = temp->next;
	}
}
#endif
