static char USMID[] = "@(#)confirm.c	1.1 10/16/90 11:11:20 LLNL ";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>

/***********************************************************************
 * This file contains the routines to use a PopUp frame to confirm the
 * user's decision to quit the Schedule Tracing Facility Program.
 *
 **********************************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern Frame frame;

void confirm_quit(item, event)
Panel_item	item;
Event		*event;
{
    window_return(panel_get(item, PANEL_CLIENT_DATA));
}


Frame init_confirmer(message)
char *message;
{
    Frame	 confirmer;
    Panel 	 panel;	
    Panel_item   message_item;
    int      	 left, top, width, height;
    Rect	 *r;
    struct pixrect  *pr;

    /* create the confirmer base frame */
    confirmer = window_create(frame,FRAME,FRAME_SHOW_LABEL,FALSE,0);
    
    /* create the single panel subwindow */
    panel = window_create(confirmer, PANEL, 0);
    
    /* put in the message */
    message_item = panel_create_item(panel, PANEL_MESSAGE,
				     PANEL_LABEL_STRING, message, 
				     0);
    pr = panel_button_image(panel, "QUIT", 3, 0);
    width = 2 * pr->pr_width +10;
    r = (Rect *)panel_get(message_item, PANEL_ITEM_RECT);

    /* center the quit and cancel buttons */
    left = (r->r_width - width) / 2;
    if (left < 0 ) left = 0;
    top = rect_bottom(r) + 5;
    
    panel_create_item(panel, PANEL_BUTTON,
		      PANEL_ITEM_X, left, PANEL_ITEM_Y, top,
		      PANEL_LABEL_IMAGE, pr,
		      PANEL_CLIENT_DATA, TRUE,
		      PANEL_NOTIFY_PROC, confirm_quit,
		      0);
    panel_create_item(panel, PANEL_BUTTON,
		      PANEL_LABEL_IMAGE, panel_button_image(panel,
							    "CANCEL", 3, 0),
		      PANEL_CLIENT_DATA, FALSE,
		      PANEL_NOTIFY_PROC, confirm_quit,
		      0);
    window_fit(panel);
    window_fit(confirmer);

    window_set(confirmer, WIN_X, 475, WIN_Y, 230, 0 );
    return confirmer;
}

confirm(message)
char *message;
{
    Frame confirmer;
    int answer;
    
    /* create the confirmer */
    confirmer = init_confirmer(message);

    /* wait for user answer */
    answer = (int)window_loop(confirmer);

    /* destroy the confirmer */
    window_set(confirmer, FRAME_NO_CONFIRM, TRUE, 0);
    window_destroy(confirmer);

    return(answer);
}
#endif
