h21090
s 01090/00000/00000
d D 1.1 90/10/16 11:11:51 werner 1 0
c date and time created 90/10/16 11:11:51 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef X11
#include "xexterns.h"
#include "externvars.h"

/***********************************************************
 * This file contains the routines to handle the drawing
 * of the various nodes of the graph, the process icons,
 * and the view box. 
 * Various types of nodes exist:
 *     solid node - task is ready to run
 *     WT node - task is waiting on a task
 *     WE node - task is waiting on an event
 *     WL node - task is waiting on a lock
 *     WB node - task is waiting on a barrier
 *     WF node - task is a master waiting on a fray
 *     CS node - task is waiting on a control structure
 *     GN node - task is waiting on guard N
 *     G  node - task is waiting on a guard
 *     ringed node - task is a master
 *     hollow node - task is completed and recovered
 * In addition, when a process is assigned to a task - that
 * task node will appear in reverse-video.
 *
 * The five types of nodes were defined in the Icon Editor 
 * as 64x64 pixrects.  The hex files were then trimmed 
 * down to 32x32.  Nodes are displayed via the raster 
 * operations from a pixrect to a pixwin.
 *
 * Five types of process icons exist:
 *	B process icon - Bound process
 * 	U process icon - Unbound process
 * 	I process icon - Idle process
 * 	S process icon - Suspended process
 * 	R process icon - Reacquired process
 * The process icons were defined in the Icon Editor as
 * 64x64 pixrects.  The visible portion of the icon is
 * 48x48.  Icons are displayed via the raster operations
 * from a pixrect to a pixwin.
 *
 * The view box is stored in a hex file as 112 pixels by
 * 60 pixels - when drawn, the visible portion of the box
 * is approximately 111 by 60.
 *
 **********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern int subtree;

/* read the images into the pixrect structures */
    
#include "xicons/infray.node"
#include "xicons/hollow.node"
#include "xicons/solid.node"
#include "xicons/rv_sold.node"
#include "xicons/waitt.node"
#include "xicons/waite.node"
#include "xicons/waitl.node"
#include "xicons/waitb.node"
#include "xicons/waitf.node"
#include "xicons/waitgn.node"
#include "xicons/wait_gn.icon"
#include "xicons/waitg.node"
#include "xicons/wait_g.icon"
#include "xicons/waitcs.node"
#include "xicons/wait_cs.icon"
#include "xicons/master.node"
#include "xicons/waitw.node"
#include "xicons/wait_w.icon"

#include "xicons/punbind.icon"
#include "xicons/pidle.icon"
#include "xicons/psuspnd.icon"
#include "xicons/preacq.icon"
#include "xicons/pbind.icon"

#include "xicons/one.icon"
#include "xicons/two.icon"
#include "xicons/three.icon"
#include "xicons/four.icon"
#include "xicons/five.icon"

/* the following mess of flags and images are set up to be initialize once 
 * a run.   After that the flags should eliminate the need to keep recreating
 * the image each time it's needed. */
XImage *idle_image;
static int idle_FLAG = 0;
XImage *suspend_image;
static int suspend_FLAG = 0;
XImage *reacq_image;
static int reacq_FLAG = 0;
XImage *bind_image;
int bind_FLAG = 0;
XImage *unbind_image;
int unbind_FLAG = 0;

XImage *one_image;
static int one_FLAG = 0;
XImage *two_image;
static int two_FLAG = 0;
XImage *three_image;
static int three_FLAG = 0;
XImage *four_image;
static int four_FLAG = 0;
XImage *five_image;
static int five_FLAG = 0;

XImage *rv_solid_image;
static int rv_solid_FLAG = 0;
XImage *solid_image;
int solid_FLAG = 0;
XImage *waitt_image;
static int waitt_FLAG = 0;
XImage *waite_image;
static int waite_FLAG = 0;
XImage *waitw_image;
static int waitw_FLAG = 0;
XImage *waitl_image;
static int waitl_FLAG = 0;
XImage *waitb_image;
static int waitb_FLAG = 0;
XImage *wait_g_image;
static int wait_g_FLAG = 0;
XImage *waitg_image;
static int waitg_FLAG = 0;
XImage *waitgn_image;
static int waitgn_FLAG = 0;
XImage *wait_gn_image;
static int wait_gn_FLAG = 0;
XImage *wait_cs_image;
static int wait_cs_FLAG = 0;
XImage *waitcs_image;
static int waitcs_FLAG = 0;
XImage *wait_w_image;
static int wait_w_FLAG = 0;
XImage *waitf_image;
static int waitf_FLAG = 0;
XImage *hollow_image;
static int hollow_FLAG = 0;
XImage *master_image;
static int master_FLAG = 0;
XImage *infray_image;
static int infray_FLAG = 0;

draw_view_box(x,y)
int x,y;
{
/************************************
 * draw_view_box draws the view box
 * with its center at the given x,y
 * coordinates, and erases the old
 * view box.
 ***********************************/
	int cornerx,cornery;

	if (first_box)
	{
		XClearWindow(ov_display,ov_win);
		first_box = 0;
	} else  /* erase old box */
	{
		XDrawRectangle(ov_display,ov_win,erase_gc,oldx,oldy,
			BOXWIDTH,BOXHEIGHT);
	}

	if (x <= 55)
	{
		cornerx = 0;
	} else if (x >= (384 - 50))
	{
		cornerx = 384 - 100;
	} else
	{
		cornerx = (x - 55);
	}
	if (y <= 30)
	{
		cornery = 0;
	} else if (y >= (283 - 30))
	{
		cornery = 283 - 60;
	} else
	{
		cornery = (y - 30);
	}
	XDrawRectangle(ov_display,ov_win,box_gc,cornerx,cornery,
		BOXWIDTH,BOXHEIGHT);
	oldx = cornerx;
	oldy = cornery;
}


show_process()
{
/**********************************
 * show_process indicates that a 
 * process has been assigned to the
 * task by displaying the node in
 * reverse-video.  
 **********************************/

	int x,y;  /* 	the x and y coords of
			the task in the primary canvas*/
	int ovx, ovy; /* coords in the overview */
	int sx,sy;	  /* coords in the subtree canvas */
	extern int bind_FLG;

	x = tasks[curr_id]->x;
	y = tasks[curr_id]->y;
	ovx = (int)(x * SCALEDOWN);
	ovy = (int)(y * SCALEDOWN);
	sx = tasks[curr_id]->stx;
	sy = tasks[curr_id]->sty;

	XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE,OVSQUARE,True);
	if( bind_FLG == 1 )
	{
		XDrawRectangle(ov_display,ov_win,ov_gc,ovx+1,ovy+1,
			OVSQUARE-2,OVSQUARE-2);
	} else
	{
		XFillRectangle(ov_display,ov_win,ov_gc,ovx+1,ovy+1,3,3);
	}
	/* reverse video the area to show binding or unbinding */
	XCopyArea(canvas_display,can_win,can_win,rv_gc,
		x,y,NODEDIM,NODEDIM,x,y);
	if INSUBTREE 
		XCopyArea(subtree_display,subtree_win,subtree_win,rv_gc,
			sx,sy,NODEDIM,NODEDIM,sx,sy);
}

draw_task()
{
/***************************************
 * draw_task draws the node for the task
 * using the appropriate node depending
 * on the state of the task.
 **************************************/

	int x, y;		/* coordinates in the primary canvas */
	int ovx, ovy;	/* coordinates in the overview canvas */
	int sx,sy;		/* coordinates in the subtree canvas */
	char str[10];
	Pixmap pixmap;

	x = tasks[curr_id]->x;
	y = tasks[curr_id]->y;
	ovx = (int)(x * SCALEDOWN);
	ovy = (int)(y * SCALEDOWN);
	sx = tasks[curr_id]->stx;
	sy = tasks[curr_id]->sty;
	/* clear old overview*/
	XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE+1,OVSQUARE+1,True);
	XFillRectangle(ov_display,ov_win,ov_gc,ovx+1,ovy+1,3,3);
	switch (tasks[curr_id]->state)
	{
	case 0 :   /* has resumed - now ready to run */
		putimage(&solid_FLAG,canvas_display,can_win,canvas_gc,
			&solid_image,solid_bits,solid_width,solid_height,
			x,y,NODEDIM,NODEDIM,-2);
		if INSUBTREE 
			putimage(&solid_FLAG,subtree_display,subtree_win,
				canvas_gc,&solid_image,solid_bits,
				solid_width,solid_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case TWAIT : 
		putimage(&waitt_FLAG,canvas_display,can_win,canvas_gc,
			&waitt_image,waitt_bits,waitt_width,waitt_height,
			x,y,NODEDIM,NODEDIM,
			-2);
		if INSUBTREE  
			putimage(&waitt_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitt_image,waitt_bits,
				waitt_width,waitt_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case EWAIT :
		putimage(&waite_FLAG,canvas_display,can_win,canvas_gc,
			&waite_image,waite_bits,waite_width,waite_height,
			x,y,NODEDIM,NODEDIM,
			-2);
		if INSUBTREE  
			putimage(&waite_FLAG,subtree_display,subtree_win,
				canvas_gc,&waite_image,waite_bits,
				waite_width,waite_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case LWAIT : 
		putimage(&waitl_FLAG,canvas_display,can_win,canvas_gc,
			&waitl_image,waitl_bits,waitl_width,waitl_height,
			x,y,NODEDIM,NODEDIM,
			-2);
		if INSUBTREE 
			putimage(&waitl_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitl_image,waitl_bits,
				waitl_width,waitl_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case BWAIT :
		putimage(&waitb_FLAG,canvas_display,can_win,canvas_gc,
			&waitb_image,waitb_bits,waitb_width,waitb_height,
			x,y,NODEDIM,NODEDIM,
			-2);
		if INSUBTREE 
			putimage(&waitb_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitb_image,waitb_bits,
				waitb_width,waitb_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case GWAIT :
		putimage(&waitg_FLAG,canvas_display,can_win,canvas_gc,
			&waitg_image,waitg_bits,waitg_width,waitg_height,
			x,y,NODEDIM,NODEDIM,
			-2);
		if INSUBTREE  
			putimage(&waitg_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitg_image,waitg_bits,
				waitg_width,waitg_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case GNWAIT :
		putimage(&waitgn_FLAG,canvas_display,can_win,canvas_gc,
		       &waitgn_image,waitgn_bits,waitgn_width,waitgn_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE 
			putimage(&waitgn_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitgn_image,waitgn_bits,
				waitgn_width,waitgn_height,
				sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case CSWAIT :
		putimage(&waitcs_FLAG,canvas_display,can_win,canvas_gc,
		       &waitcs_image,waitcs_bits,waitcs_width,waitcs_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE 
			putimage(&waitcs_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitcs_image,waitcs_bits,
				waitcs_width,waitcs_height,
				sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case -1:
	case RECOVER : 
		putimage(&hollow_FLAG,canvas_display,can_win,canvas_gc,
		       &hollow_image,hollow_bits,hollow_width,hollow_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE
			putimage(&hollow_FLAG,subtree_display,subtree_win,
				canvas_gc,&hollow_image,hollow_bits,
				hollow_width,hollow_height,
				sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case MSTARTF :
		putimage(&solid_FLAG,canvas_display,can_win,canvas_gc,
		       &solid_image,solid_bits,solid_width,solid_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE
			putimage(&solid_FLAG,subtree_display,subtree_win,
				canvas_gc,&solid_image,solid_bits,
				solid_width,solid_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	case MWAITF :
		putimage(&waitf_FLAG,canvas_display,can_win,canvas_gc,
		       &waitf_image,waitf_bits,waitf_width,waitf_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE 
			putimage(&waitf_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitf_image,waitf_bits,
				waitf_width,waitf_height,sx,sy,NODEDIM,NODEDIM,
				-2);
		break;
	default :
		check_ud();
		break;
    	}
	if (tasks[curr_id]->slave == -1)    /* is a master */
	{
		putimage(&master_FLAG,canvas_display,can_win,canvas_gc,
		       &master_image,master_bits,master_width,master_height,
		       x,y,NODEDIM,NODEDIM,
		       -2);
		if INSUBTREE
		{
			putimage(&master_FLAG,subtree_display,subtree_win,
				canvas_gc,&master_image,master_bits,
				master_width,master_height,
				sx,sy,NODEDIM,NODEDIM,
				-2);
		}
	}
	if (tasks[curr_id]->process != -1)      /* is bound */
	{
		show_process();
	}
	sprintf(str,"%d",curr_id);
	XDrawString(canvas_display,can_win,control_gc,x+32,y+20,
			str,strlen(str));
	if INSUBTREE
		XDrawString(subtree_display,subtree_win,control_gc,sx+32,sy+20,
				str,strlen(str));
}

draw_slave()
{
/******************************************
 * draw_slave draws the node for the slave
 * using the appropriate node depending
 * on the state of the slave.
 *****************************************/

	int x, y;		/* coordinates in the primary canvas */
	int ovx, ovy;	/* coordinates in the overview canvas */
	int sx,sy;		/* coordinates in the subtree canvas */
	char str[10];
	Pixmap pixmap;

	x = tasks[curr_id]->x;
	y = tasks[curr_id]->y;
	ovx = (int)(x * SCALEDOWN);
	ovy = (int)(y * SCALEDOWN);
	sx = tasks[curr_id]->stx;
	sy = tasks[curr_id]->sty;
	/* clear old overview*/
	XClearArea(ov_display,ov_win,ovx+1,ovy+1,OVSQUARE,OVSQUARE,True);
	XFillRectangle(ov_display,ov_win,ov_gc,ovx+1,ovy+1,3,3);
	switch (tasks[curr_id]->state) {
	case 0 : /* is ready to run */
		putimage(&infray_FLAG,canvas_display,can_win,canvas_gc,
		       &infray_image,infray_bits,infray_width,infray_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&infray_FLAG,subtree_display,subtree_win,
				canvas_gc,&infray_image,infray_bits,
				infray_width,infray_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
	case GNWAIT :  
		putimage(&waitgn_FLAG,canvas_display,can_win,canvas_gc,
		       &waitgn_image,waitgn_bits,waitgn_width,waitgn_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&waitgn_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitgn_image,waitgn_bits,
				waitgn_width,waitgn_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
	case GWAIT :
		putimage(&waitg_FLAG,canvas_display,can_win,canvas_gc,
		       &waitg_image,waitg_bits,waitg_width,waitg_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&waitg_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitg_image,waitg_bits,
				waitg_width,waitg_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
	case CSWAIT :
		putimage(&waitcs_FLAG,canvas_display,can_win,canvas_gc,
		       &waitcs_image,waitcs_bits,waitcs_width,waitcs_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&waitcs_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitcs_image,waitcs_bits,
				waitcs_width,waitcs_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
	case SSTARTF  :
		putimage(&infray_FLAG,canvas_display,can_win,canvas_gc,
		       &infray_image,infray_bits,infray_width,infray_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&infray_FLAG,subtree_display,subtree_win,
				canvas_gc,&infray_image,infray_bits,
				infray_width,infray_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
	case SWAITW :
		putimage(&waitw_FLAG,canvas_display,can_win,canvas_gc,
		       &waitw_image,waitw_bits,waitw_width,waitw_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&waitw_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitw_image,waitw_bits,
				waitw_width,waitw_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		break;
		default:
		break;
	}
	if (tasks[curr_id]->process != -1)      /* is bound */
	{
		show_process();
	}
	sprintf(str,"%d",curr_id);
	XDrawString(canvas_display,can_win,control_gc,x+32,y+20,
			str,strlen(str));
	if INSUBTREE
		XDrawString(subtree_display,subtree_win,control_gc,x+32,y+20,
			str,strlen(str));
}


	  
check_ud()
{
/***********************************************
 * check_ud checks to see if the action number 
 * corresponds to one of the user-defined
 * significant action number. This is done 
 * separately because the argument to case 
 * must be a constant and the user-defined
 * significant action numbers are not constants.
 ***********************************************/
	int x,y,sx,sy;

	x = tasks[curr_id]->x;
	y = tasks[curr_id]->y;
	sx = tasks[curr_id]->stx;
	sy = tasks[curr_id]->sty;

	if (tasks[curr_id]->state == choice[1])
	{
		putimage(&one_FLAG,canvas_display,can_win,canvas_gc,
		       &one_image,one_bits,one_width,one_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&one_FLAG,subtree_display,subtree_win,
				canvas_gc,&one_image,one_bits,
				one_width,one_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
	} else if (tasks[curr_id]->state == choice[2])
	{
		putimage(&two_FLAG,canvas_display,can_win,canvas_gc,
		       &two_image,two_bits,two_width,two_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&two_FLAG,subtree_display,subtree_win,
				canvas_gc,&two_image,two_bits,
				two_width,two_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
	} else if (tasks[curr_id]->state == choice[3])
	{
		putimage(&three_FLAG,canvas_display,can_win,canvas_gc,
		       &three_image,three_bits,three_width,three_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&three_FLAG,subtree_display,subtree_win,
				canvas_gc,&three_image,three_bits,
				three_width,three_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
	} else if (tasks[curr_id]->state == choice[4])
	{
		putimage(&four_FLAG,canvas_display,can_win,canvas_gc,
		       &four_image,four_bits,four_width,four_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&four_FLAG,subtree_display,subtree_win,
				canvas_gc,&four_image,four_bits,
				four_width,four_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
	} else if (tasks[curr_id]->state == choice[5])
	{
		putimage(&five_FLAG,canvas_display,can_win,canvas_gc,
		       &five_image,five_bits,five_width,five_height,
		       x,y,NODEDIM,NODEDIM,
		       tasks[curr_id]->process);
		if INSUBTREE
			putimage(&five_FLAG,subtree_display,subtree_win,
				canvas_gc,&five_image,five_bits,
				five_width,five_height,
		       		sx,sy,NODEDIM,NODEDIM,
				tasks[curr_id]->process);
	}
}
	      
connect_tasks()
{
/****************************************
 * connect-tasks connects current  parent
 * task to current child task.
 ***************************************/

	int px,py,cx,cy;  
	int spx,spy,sx,sy;
	int parent;

	parent = tasks[curr_id]->parent;
	if (tasks[parent] == NULL) return(1);
	spx = tasks[parent]->stx;
	spy = tasks[parent]->sty;
	sx = tasks[curr_id]->stx;
	sy = tasks[curr_id]->sty;
	if INSUBTREE
		XDrawLine(subtree_display,subtree_win,control_gc,
			spx+XOFFSET,spy+BOTOFFSET, sx+XOFFSET,sy+TOPOFFSET);
	px = tasks[parent]->x + XOFFSET;
	py = tasks[parent]->y + BOTOFFSET;
	cx = tasks[curr_id]->x + XOFFSET;
	cy = tasks[curr_id]->y + TOPOFFSET;
	XDrawLine(canvas_display,can_win,control_gc,px,py,cx,cy);
	return(0);
}


draw_process()
{
/*****************************************
 * draw_process draws or updates the 
 * process icon for the current process.
 * Process icons are displayed only in
 * the Primary Canvas - and always on 
 * the first row.
 ****************************************/

	int x,y,ovx,ovy;
	char str[10];
	Pixmap pixmap;

	x = procs[curr_process].x;
	y = procs[curr_process].y;
	ovx = (x * SCALEDOWN);
	ovy = (y * SCALEDOWN);  /* always zero */
      
	switch(procs[curr_process].state)
	{
	case 0 :  /* process is idle */
		putimage(&idle_FLAG,canvas_display,can_win,canvas_gc,
			&idle_image,pidle_bits,pidle_width,pidle_height,
			x,y,ICONHEIGHT,ICONWIDTH,-1);
		/* clear old overview*/
		XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE,OVSQUARE,True);
		/* draw vertical line on overview */
		XFillRectangle(ov_display,ov_win,ov_gc,ovx+2,ovy,2,5);
		break;
	case 1 : /* process is suspended */
		putimage(&suspend_FLAG,canvas_display,can_win,canvas_gc,
			&suspend_image,psuspend_bits,psuspend_width,
			psuspend_height,x,y,ICONHEIGHT,ICONWIDTH,-1);
		/* clear old overview*/
		XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE,OVSQUARE,True);
		/* draw vertical line on overview */
		XFillRectangle(ov_display,ov_win,ov_gc,ovx+2,ovy,2,5);
		break;
	case 2 : /* process is reaquired */
		putimage(&reacq_FLAG,canvas_display,can_win,canvas_gc,
			&reacq_image,preacq_bits,preacq_width,preacq_height,
			x,y,ICONHEIGHT,ICONWIDTH,-1);
		/* clear old overview*/
		XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE,OVSQUARE,True);
		/* draw vertical line on overview */
		XFillRectangle(ov_display,ov_win,ov_gc,ovx+2,ovy,2,5);
	break;
	case 3 : /* process is bound */
		putimage(&bind_FLAG,canvas_display,can_win,canvas_gc,
			&bind_image,pbind_bits,pbind_width,pbind_height,
			x,y,ICONHEIGHT,ICONWIDTH,-1);
		sprintf(str,"<-- %d",curr_id);
		XClearArea(canvas_display,can_win,x+50,y,30,30,True);
		XDrawString(canvas_display,can_win,control_gc,x+50,y+24,
						str,strlen(str));
		XFillRectangle(ov_display,ov_win,ov_gc,ovx,ovy,
			OVSQUARE,OVSQUARE);
		/* clear vertical line on square */
		XClearArea(ov_display,ov_win,ovx+2,ovy,2,5,True);
	break;
	case 4 : /* process is unbound */
		putimage(&unbind_FLAG,canvas_display,can_win,canvas_gc,
			&unbind_image,punbind_bits,punbind_width,
			punbind_height,x,y,ICONHEIGHT,ICONWIDTH,-1);
		/* clear old overview*/
		XClearArea(ov_display,ov_win,ovx,ovy,OVSQUARE,OVSQUARE,True);
		XClearArea(canvas_display,can_win,x+ICONWIDTH,y,
			ICONHEIGHT,ICONWIDTH,True);
		/* draw vertical line on overview */
		XFillRectangle(ov_display,ov_win,ov_gc,ovx+2,ovy,2,5);
		/* clear vertical line on square */
		XClearArea(ov_display,ov_win,ovx+4,ovy,2,5,True);
		break;
	default : display_message("Unknown process state\n");
	}
#ifdef CTSSTRACE
	sprintf(str,"proc %d",curr_process);
#endif
#ifdef CRAYTRACE
	sprintf(str,"proc %d",procs[curr_process].pid);
#endif
	XDrawString(canvas_display,can_win,control_gc,x,y+60,
			str,strlen(str));
}


/* 
   Designed to draw all the state children given the x,y coordinate of 
   a selected root node.
*/

subtree_init()
{
	int child,i,j;

	XClearWindow(subtree_display,subtree_win);

	for(i=0; i < 74; i++) {
		for(j=0; j < 54; j++) {
			subtree_screen[i][j].children.x = 0;
			subtree_screen[i][j].children.y = 0;
			subtree_screen[i][j].position.x = 0;
			subtree_screen[i][j].position.y = 0;
			subtree_screen[i][j].id = 0;
			subtree_screen[i][j].pass = 0;
			subtree_screen[i][j].constraint = 0;
			subtree_screen[i][j].working = 0;
		}
	}

	subtree_screen[37][0].id = leftid;
	subtree_screen[37][0].constraint = 5;
	subtree_draw(leftid);
	subtree_draw_children(leftid,tasks[leftid]->children);
}

subtree_draw_children(parent_id,pointer_to)
int parent_id;
struct child_struct *pointer_to;
{
	int nil,child;
	struct child_struct *next_child;

	if (pointer_to == NULL)
	{
		return(0);
	} else
	{
		child = pointer_to->child_id;
		next_child = pointer_to->next;
	
		subtree_draw(child);
		nil = subtree_draw_children(child, tasks[child]->children);
		return(subtree_draw_children(parent_id,next_child));
	}
}

subtree_draw(task_id)
int task_id;
{
	subtree_curr_id = task_id;

	/* put the calculated subscreen x,y in structure in stx, sty */
	subtree_assign_xy();
	subtree_draw_task(); /* draw the task on the subscreen */
	subtree_connect();   /* connect the the parent/child */
}    

subtree_draw_task()
{
/***************************************
 * subtree_draw_task draws the node for 
 * the task using the appropriate node
 * type depending on the state of the 
 * task.
 **************************************/

	int sx,sy;		/* coordinates in the subtree canvas */
	char str[10];
	Pixmap pixmap;

	sx = tasks[subtree_curr_id]->stx;
	sy = tasks[subtree_curr_id]->sty;
	switch (tasks[subtree_curr_id]->state)
	{
	case 0 :
		if (tasks[subtree_curr_id]->slave >= 0)
		{
			putimage(&infray_FLAG,subtree_display,subtree_win,
				canvas_gc,&infray_image,infray_bits,
				infray_width,infray_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		} else
		{
			putimage(&solid_FLAG,subtree_display,subtree_win,
				canvas_gc,&solid_image,solid_bits,
				solid_width,solid_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		}
		break;
	case TWAIT : 
		putimage(&waitt_FLAG,subtree_display,subtree_win,
			canvas_gc,&waitt_image,waitt_bits,
			waitt_width,waitt_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case EWAIT :
		putimage(&waite_FLAG,subtree_display,subtree_win,
			canvas_gc,&waite_image,waite_bits,
			waite_width,waite_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case LWAIT : 
		putimage(&waitl_FLAG,subtree_display,subtree_win,
			canvas_gc,&waitl_image,waitl_bits,
			waitl_width,waitl_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case BWAIT : 
		putimage(&waitb_FLAG,subtree_display,subtree_win,
			canvas_gc,&waitb_image,waitb_bits,
			waitb_width,waitb_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case MWAITF :
		putimage(&waitf_FLAG,subtree_display,subtree_win,
			canvas_gc,&waitf_image,waitf_bits,
			waitf_width,waitf_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case MRESUMEF :
	case RECOVER : 
		putimage(&hollow_FLAG,subtree_display,subtree_win,
			canvas_gc,&hollow_image,hollow_bits,
			hollow_width,hollow_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case GNWAIT :  
		if (tasks[subtree_curr_id]->slave >= 0) 
		{
			putimage(&waitgn_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitgn_image,waitgn_bits,
				waitgn_width,waitgn_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		} else 
		{
			putimage(&wait_gn_FLAG,subtree_display,subtree_win,
				canvas_gc,&wait_gn_image,wait_gn_bits,
				wait_gn_width,wait_gn_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		}
		break;
	case GWAIT :
		if (tasks[subtree_curr_id]->slave >= 0) 
		{
			putimage(&waitg_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitg_image,waitg_bits,
				waitg_width,waitg_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		} else 
		{
			putimage(&wait_g_FLAG,subtree_display,subtree_win,
				canvas_gc,&wait_g_image,wait_g_bits,
				wait_g_width,wait_g_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		}
		break;
	case CSWAIT :
		if (tasks[subtree_curr_id]->slave >= 0) 
		{
			putimage(&waitcs_FLAG,subtree_display,subtree_win,
				canvas_gc,&waitcs_image,waitcs_bits,
				waitcs_width,waitcs_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		} else 
		{
			putimage(&wait_cs_FLAG,subtree_display,subtree_win,
				canvas_gc,&wait_cs_image,wait_cs_bits,
				wait_cs_width,wait_cs_height,sx,sy,
				NODEDIM,NODEDIM,
				tasks[curr_id]->process);
		}
		break;
	case SWAITW :
		putimage(&wait_w_FLAG,subtree_display,subtree_win,
			canvas_gc,&wait_w_image,wait_w_bits,
			wait_w_width,wait_w_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	case SSTARTF  :
		putimage(&infray_FLAG,subtree_display,subtree_win,
			canvas_gc,&infray_image,infray_bits,
			infray_width,infray_height,sx,sy,
			NODEDIM,NODEDIM,
			tasks[curr_id]->process);
		break;
	default :
		subtree_check_ud();  
		break;
	}
	if (tasks[subtree_curr_id]->slave == -1)  /* is a master */
	{
		putimage(&master_FLAG,subtree_display,subtree_win,
			canvas_gc,&master_image,master_bits,
			master_width,master_height,
			sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
	}
	if (tasks[subtree_curr_id]->process != -1)      /* is bound */
	{
		subtree_show_process();
	}
	sprintf(str,"%d",subtree_curr_id);
	XDrawString(subtree_display,subtree_win,control_gc,sx+32,sy+20,
			str,strlen(str));
}

subtree_check_ud()
{
/******************************************
 * subtree_check_ud checks to see if the 
 * state corresponds to a user-defined
 * significant action number
 *****************************************/
	int ch, sx, sy;

	ch = tasks[subtree_curr_id]->state;
	sx = tasks[subtree_curr_id]->stx;
	sy = tasks[subtree_curr_id]->sty;

	if (ch == choice[1]) 
		putimage(&one_FLAG,subtree_display,subtree_win,
			canvas_gc,&one_image,one_bits,
			one_width,one_height,sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
	if (ch == choice[2])
		putimage(&two_FLAG,subtree_display,subtree_win,
			canvas_gc,&two_image,two_bits,
			two_width,two_height,sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
	if (ch == choice[3])
		putimage(&three_FLAG,subtree_display,subtree_win,
			canvas_gc,&three_image,three_bits,
			three_width,three_height,sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
	if (ch == choice[4])
		putimage(&four_FLAG,subtree_display,subtree_win,
			canvas_gc,&four_image,four_bits,
			four_width,four_height,sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
	if (ch == choice[5])
		putimage(&five_FLAG,subtree_display,subtree_win,
			canvas_gc,&five_image,five_bits,
			five_width,five_height,sx,sy,NODEDIM,NODEDIM,
			tasks[curr_id]->process);
}

subtree_show_process()
{
/****************************************
 * subtree_show_process indicates that a 
 * process has been assigned to the
 * task by displaying the node in
 * reverse-video on the subtree canvas.
 ***************************************/
	int sx,sy;	  /* coords in the subtree canvas */

	sx = tasks[subtree_curr_id]->stx;
	sy = tasks[subtree_curr_id]->sty;

	/* reverse video the area to show binding or unbinding */
	XCopyArea(subtree_display,subtree_win,subtree_win,rv_gc,
		sx,sy,NODEDIM,NODEDIM,sx,sy);
	
}

	      
subtree_connect()
{
/********************************************
 * subtree_connect connects current parent
 * task to current child task in the subtree
 * canvas.
 *******************************************/
	int spx,spy,sx,sy;
	int parent_id;

	parent_id = tasks[subtree_curr_id]->parent;
	if (subtree_curr_id == leftid)
	{
		return(1);
	}
	spx = tasks[parent_id]->stx;
	spy = tasks[parent_id]->sty;
	sx = tasks[subtree_curr_id]->stx;
	sy = tasks[subtree_curr_id]->sty;
	XDrawLine(subtree_display,subtree_win,control_gc,
		spx+XOFFSET,spy+BOTOFFSET, sx+XOFFSET,sy+TOPOFFSET);
	return(0);
}

static int first_FLAG = 0;
static XImage *ximage;
putimage(FLAG,dpy,win,gc,image,ibits,iw,ih,x,y,drawh,draww,bound)
int *FLAG;		/* FLAG specifying if we should redraw or not. */
Display *dpy;		/* The display to write to. */
Window win;		/* The window to write to. */
GC gc;			/* The graphics control to write with */
XImage **image;		/* The image to create, write, and pass back. */
char *ibits;		/* The image data */
int iw;			/* The image width */
int ih;			/* The image height */
int x;			/* The x coordinate */
int y;			/* The y coordinate */
int drawh;		/* The height to draw */
int draww;		/* The width to draw */
int bound;		/* Should it be reverse-video'd to be bound? */
{
	Pixmap bitmap;
	Pixmap pixmap;
	int width, height, pixel_value;

	/* Is this the first time we've had to use this image ? */
	if( *FLAG == 0 )
	{
		bitmap = XCreateBitmapFromData(dpy,DefaultRootWindow(dpy),
			ibits, iw, ih);
		pixmap = XCreatePixmap(dpy,DefaultRootWindow(dpy),
			iw,ih,depth);
		XCopyPlane(dpy,bitmap,pixmap,gc,0,0,
			iw, ih, 0,0,1);
		*image = XGetImage(dpy,pixmap,0,0,
			iw, ih, AllPlanes, XYPixmap);
		XFreePixmap(dpy,pixmap);
		XFreePixmap(dpy,bitmap);
		*FLAG = 1;
	}
	XPutImage(dpy,win,gc,*image,0,0,x,y,drawh,drawh);
}
#endif
E 1
