h00635
s 00169/00000/00000
d D 1.1 90/10/16 11:11:44 werner 1 0
c date and time created 90/10/16 11:11:44 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/scrollbar.h>
#endif
#ifdef X11
#include "xexterns.h"
#endif
#include "externvars.h"

/*************************************************************
 * This file contains the routines to draw the histogram:
 * 
 ***********************************************************/

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */
 

/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

extern int mode,done;
#ifdef sunview
Scrollbar h_bar;
extern Frame frame;
extern Frame popup_frame;
extern Pixwin *pw, *pw2;
#endif

int event_adjustment = 0;
int adjustment = 0;

plot_histogram()
{
/*****************************************
 * histogram updates the histogram 
 * popup canvas using the global 
 * variables curr_events and curr_procs
 * and using the local static integers
 * to record the last plotted point.
 ****************************************/
	int startx,starty;
	int x;   /* where to scroll to */
	extern void hist_init();

	if( curr_events >= 2500+event_adjustment )
	{
		event_adjustment = event_adjustment + 2500;
		histx = 0;
		adjustment = 1;
#ifdef HIST_DEBUG
		fprintf(stderr, "new event_adjustment = (%d)\n", event_adjustment);
#endif HIST_DEBUG
		hist_init();
	}
	x = (SPACEHIST * (curr_events - event_adjustment + adjustment));
	if (x <= 700)
	{
		x=0;
	} else
	{
		x = x - 700;
#ifdef X11
		XtMoveWidget(inner_hist,-(x),0);
#endif
	}
#ifdef sunview
	scrollbar_scroll_to(h_bar,x);
#endif
	startx = histx;
	starty = histy;
	histx = ((curr_events-event_adjustment+adjustment) * SPACEHIST);
#ifdef HIST_DEBUG 
	fprintf(stderr, "curr_events = (%d) startx = (%d) histx = (%d)\n",
		curr_events, startx, histx );
#endif HIST_DEBUG
	histy = (175 - (curr_procs * 20));
#ifdef sunview
	pw_vector(pw2,startx,starty-1,histx,histy-1,PIX_SET,1);
	pw_vector(pw2,startx,starty  ,histx,histy  ,PIX_SET,1);
	pw_vector(pw2,startx,starty+1,histx,histy+1,PIX_SET,1);
#endif
#ifdef X11
	XDrawLine(hist_display,hist_win,hist_gc,
			startx, starty-1, histx, histy-1);
	XDrawLine(hist_display,hist_win,hist_gc,
			startx, starty, histx, histy);
	XDrawLine(hist_display,hist_win,hist_gc,
			startx, starty+1, histx, histy+1);
#endif
}

void hist_init()
{
	int i;
	char str[10];

#ifdef X11
	XClearWindow(hist_display,hist_win);
	XtMoveWidget(inner_hist,0,0);
#endif X11
#ifdef sunview
	scrollbar_scroll_to(h_bar,0);
	clearscreen(pw2,HISTX,HISTY);
#endif sunview
#ifdef X11
	XDrawLine(hist_display,hist_win,control_gc, 0, 15, MAXHIST, 15);
	XDrawLine(hist_display,hist_win,control_gc, 0, 55, MAXHIST, 55);
	XDrawLine(hist_display,hist_win,control_gc, 0, 95, MAXHIST, 95);
	XDrawLine(hist_display,hist_win,control_gc, 0, 135, MAXHIST, 135);
	XDrawLine(hist_display,hist_win,control_gc, 0, 175, MAXHIST, 175);

	for(i=0;i<= (MAXHIST/SPACEHIST);i=i+50)
	{
		sprintf(str,"%d",i+event_adjustment);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 189, str, strlen(str));
	}

	for(i=0;i<= (MAXHIST/SPACEHIST);i=i+100)
	{
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 13, "8", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 53, "6", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 93, "4", 1);
		XDrawString(hist_display,hist_win,control_gc,
			(i*SPACEHIST), 133, "2", 1);
	}
#endif X11
#ifdef sunview
	/* draw upper bound  - 8 processors */
	pw_vector(pw2,0,15,MAXHIST,15,PIX_SET,1);
	pw_vector(pw2,0,55,MAXHIST,55,PIX_SET,1);     /* 6 processors */
	pw_vector(pw2,0,95,MAXHIST,95,PIX_SET,1);   /* 4 processors */
	pw_vector(pw2,0,135,MAXHIST,135,PIX_SET,1);   /* 2 processors */
	pw_vector(pw2,0,175,MAXHIST,175,PIX_SET,1);   /* 0 processors */
	for(i=0;i<= (MAXHIST/SPACEHIST);i=i+50)
	{
		sprintf(str,"%d",i+event_adjustment);
		pw_text(pw2,(i*SPACEHIST),189,PIX_SCR,0,str);
	}
	for(i=0;i<= (MAXHIST/SPACEHIST);i=i+100)
	{
		pw_text(pw2,(i*SPACEHIST),13,PIX_SCR,0,"8");
		pw_text(pw2,(i*SPACEHIST),53,PIX_SCR,0,"6");
		pw_text(pw2,(i*SPACEHIST),93,PIX_SCR,0,"4");
		pw_text(pw2,(i*SPACEHIST),133,PIX_SCR,0,"2");
	}
#endif sunview
}
E 1
