h65242
s 00324/00000/00000
d D 1.1 90/10/16 11:11:22 werner 1 0
c date and time created 90/10/16 11:11:22 by werner
e
u
U
t
T
I 1
static char USMID[] = "%W% %G% %U% LLNL %Q%";
#include <stdio.h>
#ifdef sunview
#include <suntool/sunview.h>
#include <suntool/panel.h>
#endif

#ifdef X11
#include "xexterns.h"	/* contains all the X11 specific external variables */
#endif

#include "externvars.h" /* stategraph specific external variables */
#include "log_entry.h"  /* the log file, one line entry, description */

#define BUFSIZE 10         /* Maximum 32 bit words to buffer */

/* ********************************************************************** */
/* This file contains various routines for interaction with the user
 * 
 * ********************************************************************** */

/* ******************************************************************** */
/*   (c) Copyright 1987 the Regents of the University of California,	*/
/*    Lawrence Livermore National Laboratory.  All Rights Reserved.	*/
/* ******************************************************************** */


/*
 * Copyright Cray Research, Inc.  Unpublished.  All rights reserved.

 * Cray Research warrants and provides support for this software
 * only when distributed and used under the terms of a license
 * agreement with Cray Research.

 * FOR PRODUCT DISTRIBUTED IN ANY OTHER MANNER, CRAY RESEARCH DISCLAIMS
 * ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL 
 * CRAY RESEARCH BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL
 * DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA
 * OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OF
 * THIS SOFTWARE.
*/

#ifdef sunview
extern Panel_item event_count;
#endif

#ifdef X11
extern caddr_t event_count;
#endif

extern int first_time;	/* used to check for invalid parent first time around */

data_input()
{
/************************************************************
 * data_input reads the data from the file or the socket and
 * fills the global variables so that process_task can
 * be called.
 ***********************************************************/
	int cc, len, first, secnd, aux_data_len, i;
	unsigned int buf[BUFSIZE];
	double sbuf[3];
	char str[30];
	double data(), clock();

	/* Read the first 32 bit word   */
	cc = read(fp,(char *)&log_entry,sizeof(log_entry));
	if (cc == 0)   /* at EOF */
	{
		display_message("End of Tracefile - first\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}

	curr_events++;			/* update number of events */
	sprintf(str,"Events Processed: %d",curr_events);
#ifdef sunview
	panel_set(event_count,PANEL_LABEL_STRING,str,0);
#endif
#ifdef X11
	/* clear the event then display the string */
	XClearArea(control_display,control_win,
		EVENTSX+100,EVENTSY-10,200,12,True);
	XDrawString(control_display,control_win,control_gc,EVENTSX,EVENTSY,
		str, strlen(str));
#endif

#ifdef CTSSTRACE
	len = log_entry.len;		/* Number of 64 bit words       */
#endif
#ifdef CRAYTRACE
	len = LOG_ENT_LEN;		/* Number of 64 bit words	*/
#endif
	curr_id = log_entry.tid;		/* Task ID */
	curr_action = log_entry.actno;	/* Action number for this event */

#ifdef CRAYTRACE
	/* any curr_actions of -1 are invalid.  It just happens that -1 is put
	* in the trace file to detect the tracefile wrap around condition. */
	if( curr_action == -1 )
		display_message("DETECTED PARTIAL TRACE FILE OR UNREADABLE TRACEFILE.\n");
#endif

#ifdef CTSSTRACE
	if (curr_action == 0)
	{
		display_message("End of Tracefile - \n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}
	curr_process =  log_entry.pid;	/* Process ID */
	if (curr_process >= MAXPROCS)
	{
		display_message("data_input.c: No available procs[] entries\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}

	aux_data_len = len - 2;		/* Number of 64 bit aux data words.  */
	cc = read(fp,buf,aux_data_len*8);
	for(i = 0; i < aux_data_len; i++)
	{
		first = buf[2*i];
		secnd = buf[2*i+1];
		aux_data[i] = data(first, secnd);
	}
#endif
#ifdef CRAYTRACE
	/* The sizes are different between suns and crays.   For the suns
	 * put the ints to doubles for the cray just take it as it is.
	 */
#if sun
	aux_data[0] = data(log_entry.hi_user,log_entry.lo_user);
#endif
#if CRAY2 || CRAY
	aux_data[0] = log_entry.lo_user;
#endif
	/* This is a fix to prevent a core dump from bad data.  When the second
	 * task starts or any non first task starts it's process id should be
	 * non zero. */
	if((!first_time) && (log_entry.lo_user == 0 ) && (curr_action == START))
	{
		display_message("ERROR: Invalid start of process zero\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}

	if (first_time && ((curr_action != START) || (curr_id != 1)))
	{
		display_message("ERROR: No dummy start of task zero\n");
		close(fp);
		done = 1;
		go = 0;
		return(-1);
	}
	
	switch (curr_action)
	{
	case START:
		if (!first_time && 
			((aux_data[0] < 0) || (aux_data[0] >= MAXTASKS) 
			|| (tasks[(int)(aux_data[0])] == NULL)))
		{
			display_message("ERROR: START action has invalid parent\n");
			close(fp);
			done = 1;
			go = 0;
			return(-1);
		}
		break;
	case ACQUIRE:
		/* check for an already acquired cpu for this pid */
		for (i = 0; i <MAXPROCS; i++ )
		{ 
			if (procs[i].pid == log_entry.lo_user )
			{
				break;
			}
		}
		/* if no entry already exists then find an empty procs[] table
		 * entry for the new proc. */
		if (i == MAXPROCS )
		{
			for (i = 0; i < MAXPROCS; i++)
			{
				if (procs[i].state == -1)
				{
					break;
				}
			}
		}

		if (i == MAXPROCS)
		{
			display_message("ERROR: No available procs[] entries\n");
			close(fp);
			done = 1;
			go = 0;
			return(-1);
		}
		curr_process = i;
		procs[curr_process].pid = log_entry.lo_user;
		procs[curr_process].state = 0;
		break;

	case BIND:
	case UNBIND:
	case REQUEST:
	case REQUEST_NA:
	case RELEASE:
	case RELEASE_NA:
	case SUSPEND:
	case SUSPEND_NA:
	case REQSUS:
	case REQSUS_NA:
	case IDLE:
		/* find the procs[] table entry matching this pid */
		for (i = 0; i < MAXPROCS; i++)
		{
			if (procs[i].pid == log_entry.lo_user)
			{
				break;
			}
		}
		if (i == MAXPROCS)
		{
			/* catch the startup pid0 case */
			if (procs[0].pid == 0)
			{
				i = 0;
				procs[0].pid = log_entry.lo_user;
			} else
			{
				display_message("ERROR: Process not found\n");
				close(fp);
				done = 1;
				go = 0;
				return(-1);
			}
		}
		curr_process = i;
		break;

	default:
		/* find the proc to which this task should be connected */
		for (i = 0; i < MAXPROCS; i++)
		{
			if (procs[i].task == log_entry.tid)
			{
				break;
			}
		}
		if (i == MAXPROCS)
		{
			display_message("ERROR: Process/task connect mismatch\n");
			close(fp);
			done = 1;
			go = 0;
			return(-1);
		}
		curr_process = i;
	}
#endif

#ifdef DEBUG
	dataprint();
#endif
	return(0);
}

#define POW 4294967296.0   /* 32 bit offset */ 

double clock(first, secnd)
unsigned int first, secnd;
{
	unsigned int  msk, lsb;
	double clk, msb, pow = POW;

	lsb = secnd;  /* Least signif. bit */

	msk = first & 0x3ff;    /* mask to get first 9 bits */
	msb = (double)msk * pow; /* shift by 32 bits */
	clk = msb + lsb;

	return(clk);
}


double data(first,secnd)
unsigned int first, secnd;
{
	unsigned int lsb;
	double ldata, msb, pow = POW;

	lsb = secnd;                 /* Least signif. bit */
	msb = (double)first * pow;  /* shift by 32 bits */
	ldata = msb + lsb;
	return(ldata);
}


dataprint()
{
/*****************************************
 * Used for debugging purposes to verify
 * valid input.
 ****************************************/    

	printf("Action is  %d ", curr_action);
	printf("Process is %d[%2d] ", procs[curr_process].pid,curr_process);
	printf("Task is    %d\n", curr_id);
	if (curr_action == START) printf("Parent is %d\n", aux_data[0]);
	printf("\n");
}
E 1
