          CAREX - A Benchmark Collection for CARE
         =========================================

The FORTRAN 77 subroutine CAREX is designed to generate all examples
of continuous-time algebraic Riccati equations (CARE)

                     T 
(I)     0  =  Q  +  A  X  +  X A  -  X G X

collected in [1]. Here, A, G, Q, and X are real n-by-n matrices. G and Q
are symmetric and usually, the required solution matrix X is symmetric,
too. The coefficient matrices G and Q are often given in factored form as

                 -1  T            T 
(II)    G  =  B R   B ,    Q  =  C  Q0 C,

where B is n-by-m, R is m-by-m, C is p-by-n, and Q0 is p-by-p. This
factorization often arises in (but is not limited to) CARE coming from
control theory. The required solution X often has some particular or
extremal properties, for instance in control theory one is usually
concerned with the "stabilizing" solution of (I), i.e., a solution
such that the "feedback gain matrix"

	F  =  A  -  G X
 
has all its eigenvalues in the open left half plane.
The benchmark collection [1] consists of examples which can be used for
testing purposes in the construction of new numerical methods to solve
CAREs or as a reference set for the comparison of methods. Although
the presented benchmark examples have a control-theoretic background,
they can be considered as examples for general CARE of the form (I).
  
---------------------------------------------------------------------------

IMPLEMENTATION:
===============

CAREX, the required subroutines SP2SY, SY2SP, and the sample program
EXAMPLE were implemented and documented according to the standards
given in [2]. So far only DOUBLE PRECISION versions of these subroutines
are available.  
The subroutines are based upon the DOUBLE PRECISION versions of the BLAS
and LAPACK [3]. Thus, to run the codes, you have to link the BLAS and
LAPACK libraries. If those are not available on your computer, see the
HELP AND BUGS section in this file.  
A call to CAREX looks like

      CALL CAREX(NO, N, M, P, NPAR, DPARAM, DATAF, A, LDA, B, LDB, C,
     1           LDC, G, LDG, Q, LDQ, X, LDX, NOTE, STORE, FORM, RWORK,
     2           IERR)

A detailed description of all parameters in the argument list of CAREX
is given in the prolog of the subroutine CAREX.

The coefficient matrices G and Q can be returned either in the "product
form" as in (I) (i.e., the matrices G and Q are returned in the
corresponding arrays) or in the "factored forms" as in (II) (i.e., the
array G contains R, Q0 is returned in Q and the matrices B and C are
returned in the arrays B, C, respectively) or in either combination 
of the forms in (I) and (II). The symmetric matrices G, Q, and R, Q0,
respectively, can be stored by columns in a full two-dimensional array
(standard matrix storage mode in FORTRAN 77) or in lower (upper) packed
storage mode, i.e., the lower (upper) triangle of the matrices is stored
by columns.
If an analytical solution of the CARE is available, it will be returned,
too (in standard storage mode). This returned solution is generally
the "stabilizing" solution in the control-theoretic sense, i.e., the
feedback gain matrix

	F  =  A  -  G X

has all its eigenvalues in the open left half plane.
Most of the examples have one INTEGER and/or one or several real
(implemented as DOUBLE PRECISION) parameters. These can be supplied by
the user or they are set by default.  
Some examples require data files which are supplied together with
carex.f. NOTE that the names of the supplied data files (see next
section) contain only capital letters. This is obligatory for the provided 
files, but not for user-supplied data files.       
A sample program and sample input/output files are also provided (in a
subdirectory named EXAMPLES). Those will be briefly described in the
Section EXAMPLES below.

---------------------------------------------------------------------------

CONTENTS:
=========

You can receive the file carex_f.tar.Z by anonymous ftp at

	ftp.tu-chemnitz.de

from the directory

	pub/Local/mathematik/Benner

(observe the capital "L" in Local !) where you can also receive a
postscript version of the preprint [1] (this file is called blm1.ps.Z).

Then by decompressing carex_f.tar.Z via

	uncompress carex_f.tar.Z

or

	compress -d carex_f.tar.Z

and extracting the resulting file carex.tar by

	tar xf carex_f.tar

a directory carex_f is created containing the following files and
subdirectories: 

EXAMPLES    - A directory containing a sample program, example.f, and a
              sample Makefile as well as ASCII files containing sample
              inputs to and sample outputs from EXAMPLE. Using the sample
              program is described below by showing some sample inputs
              and outputs.
README.f77  - This file.
SOURCE      - A directory containing the source codes required for the
              benchmark collection.  

The subdirectory SOURCE contains the following files:

carex.f     - The FORTRAN 77 subroutine CAREX for generating all the
              benchmark examples presented in [1].
CAREX3.DAT  - Data file in ASCII format required by CAREX for generating
              Example 3 of [1].    
CAREX4.DAT  - Data file in ASCII format required by CAREX for generating
              Example 4 of [1].    
CAREX5.DAT  - Data file in ASCII format required by CAREX for generating
              Example 5 of [1].    
CAREX6.DAT  - Data file in ASCII format required by CAREX for generating
              Example 6 of [1].    
CAREX20.DAT - Data file in ASCII format required by CAREX for generating
              Example 20 of [1].    
sp2sy.f     - The FORTRAN 77 subroutine SP2SY which converts a symmetric 
              matrix stored in packed storage mode to full (standard)
              storage mode. 
sy2sp.f     - The FORTRAN 77 subroutine SY2SP which converts a symmetric 
              matrix stored in full (standard) storage mode to packed
              storage mode. 

---------------------------------------------------------------------------

EXAMPLES:
=========

In the following we will describe how to use CAREX by showing some input
to the sample program EXAMPLE and the resulting output. Note that in
EXAMPLE, G is declared as one-dimensional array designed for packed
storage mode whereas Q is declared as a standard two-dimensional array. 
This is done for demonstration purposes. The actual declaration of G and 
Q should depend upon the desired storage mode (although each declaration
can be used with each storage mode - but this makes life more
complicated). 
In the sample program EXAMPLE, the input is expected from the standard
input device and the output is sent to the standard output device, i.e., 
in both cases the terminal.
After creating an executable file via, e.g., (note that you have to adept
the Makefile to your computer environment)

        make example

there will be an executable file named "carex". You can now use the data 
files provided in the subdirectory EXAMPLES called 

        carex#.d

where # stands for one of the numbers 1, 8, 16, 19. These numbers
correspond to the example numbers in [1] and if in the following, a #
appears in a filename, this will replace any of those four numbers. (Of
course, you can create data files yourself and give them any name you
want.) 
"carex" can now read the data from such a file by typing

        example < carex#.d

The output files in subdirectory EXAMPLES called

        carex#.r

were created by

        example < carex#.d > carex#.r

If for any reason, "piping" via ">" and "<" is not possible in your
computer environment, you can insert the line

        OPEN(NIN,FILE='carex#.d')

at the beginning of the executable statements in example.f. Then you have
to insert the line 

        CLOSE(NIN)

just before 

        CALL CAREX(....)

or any other place following the last READ directive.
You can create an output file similar by inserting at the beginning of
the executable statements

        OPEN(NOUT,FILE='carex#.r')

and closing the file after the last WRITE command (but before the STOP
directive !) by

        CLOSE(NOUT)

In the following we will assume that "piping" is possible. We now create
some of the benchmark examples by showing some input data (defining the
input paramters to CAREX) for EXAMPLE and the resulting output. 

NOTE that the last line of each input file consists of two character
constants. They define the input arguments FORM and STORE of CAREX. A 
detailed description of these parameters is given in the prolog of CAREX.
 
A) To generate Example 1 of [1] where G is to be given in factored form
(i.e., B and R are returned), Q is in product form and the arrays G and Q
are to be stored in upper packed mode, we need the following input file,
carex1.d : 

CAREX EXAMPLE PROGRAM DATA
1 0
'g' 'u'

The first line after the heading contains the number of the required
example (1) and the number of the user-defined parameters (0).
As mentioned above, the next line defines in which form ((I) or (II))
G and Q are returned and which storage mode is used for the arrays G
and Q.  
Then by typing

	carex < carex1.d > carex1.r

we obtain the following output file carex1.r :

 CAREX EXAMPLE PROGRAM RESULTS
 
 Laub 1979, Ex.1                                                       

 Order of matrix A:               N  =   2
 Number of columns in matrix B:   M  =   1
 Number of rows in matrix C:      P  =   2

 A  = 
    .0000   1.0000 
    .0000    .0000 
 B  = 
    .0000 
   1.0000 
 R  = 
   1.0000 
 Q  = 
   1.0000    .0000 
    .0000   2.0000 

 The solution matrix X is 
   2.0000   1.0000 
   1.0000   2.0000 


B) Now we want to generate Example 8 of [1]. This example has as
parameter one real number EPS. We want to set EPS = 3.14159 and both G
and Q are to be returned in factored form (II). The arrays G and Q are
stored conventionally as two-dimensional arrays.

The input file carex8.d is then 

CAREX EXAMPLE PROGRAM DATA
8 1
3.14159
'f' 'f'

In contrast to the last example, here we have one user-defined parameter
which is given in the second line after the heading. 
From this, we obtain the output file carex8.r :

 CAREX EXAMPLE PROGRAM RESULTS
 
 Arnold/Laub 1984, Ex.3: control weighting matrix singular as EPS -> 0 

 Order of matrix A:               N  =   2
 Number of columns in matrix B:   M  =   2
 Number of rows in matrix C:      P  =   1

 A  = 
   -.1000    .0000 
    .0000   -.0200 
 B  = 
    .1000    .0000 
    .0010    .0100 
 R  = 
   4.1416   1.0000 
   1.0000   1.0000 
 C  = 
  10.0000 100.0000 
 Q0 = 
   1.0000 

C) Next, we create the coefficient matrices corresponding to Example 16
from [1]. The only free parameter in this example is the order of the
CARE which we choose as n = 6. Both G and Q are to be returned in
product form as in (I) and their lower triangular part is stored by
columns. Using as input carex16.d :

CAREX EXAMPLE PROGRAM DATA
16 1
6
'p' 'l'
 
we obtain by

	carex < carex16.d > carex16.r

the output file

 CAREX EXAMPLE PROGRAM RESULTS

 Laub 1979, Ex.5: circulant matrices                                   

 Order of matrix A:               N  =   6
 Number of columns in matrix B:   M  =   6
 Number of rows in matrix C:      P  =   6

 A  = 
  -2.0000   1.0000    .0000    .0000    .0000   1.0000 
   1.0000  -2.0000   1.0000    .0000    .0000    .0000 
    .0000   1.0000  -2.0000   1.0000    .0000    .0000 
    .0000    .0000   1.0000  -2.0000   1.0000    .0000 
    .0000    .0000    .0000   1.0000  -2.0000   1.0000 
   1.0000    .0000    .0000    .0000   1.0000  -2.0000 
 G  = 
   1.0000    .0000    .0000    .0000    .0000    .0000 
    .0000   1.0000    .0000    .0000    .0000    .0000 
    .0000    .0000   1.0000    .0000    .0000    .0000 
    .0000    .0000    .0000   1.0000    .0000    .0000 
    .0000    .0000    .0000    .0000   1.0000    .0000 
    .0000    .0000    .0000    .0000    .0000   1.0000 
 Q  = 
   1.0000    .0000    .0000    .0000    .0000    .0000 
    .0000   1.0000    .0000    .0000    .0000    .0000 
    .0000    .0000   1.0000    .0000    .0000    .0000 
    .0000    .0000    .0000   1.0000    .0000    .0000 
    .0000    .0000    .0000    .0000   1.0000    .0000 
    .0000    .0000    .0000    .0000    .0000   1.0000 

 The solution matrix X is 
    .3793    .1881    .0911    .0622    .0911    .1881 
    .1881    .3793    .1881    .0911    .0622    .0911 
    .0911    .1881    .3793    .1881    .0911    .0622 
    .0622    .0911    .1881    .3793    .1881    .0911 
    .0911    .0622    .0911    .1881    .3793    .1881 
    .1881    .0911    .0622    .0911    .1881    .3793 


D) The last example given here has the number 19 in [1]. This example has 
four parameters, the order L of an underlying second-order sytem (yielding
n = 2*L), and three DOUBLE PRECISION parameters mu, delta, and kappa. Here,
L, mu, and delta are defined by L = 3, mu = 10.0, delta = 3.0, and the
remaining parameter kappa is set by default. We want the matrix G in (I) to
be returned as well as the factors C and Q0 of (II). The arrays G and Q (Q 
containing Q0) are to be stored in upper packed storage mode.

The corresponding data file carex19.d is 

CAREX EXAMPLE PROGRAM DATA
19 3
3
10.0 3.0
'q' 'u'

Here, the user-defined parameters are given in two lines, one
containing the information about the order of the Problem (L = 3), the
other one containing the DOUBLE PRECISION parameters mu (=10.0) and delta
(=3.0). 

Generating the output file carex19.r as before, we obtain

 CAREX EXAMPLE PROGRAM RESULTS
 
 Hench et al. 1995: coupled springs, dashpots and masses               

 Order of matrix A:               N  =   6
 Number of columns in matrix B:   M  =   2
 Number of rows in matrix C:      P  =   6

 A  = 
    .0000    .0000    .0000   1.0000    .0000    .0000 
    .0000    .0000    .0000    .0000   1.0000    .0000 
    .0000    .0000    .0000    .0000    .0000   1.0000 
   -.1000    .1000    .0000   -.3000    .0000    .0000 
    .1000   -.2000    .1000    .0000   -.3000    .0000 
    .0000    .1000   -.2000    .0000    .0000   -.3000 
 G  = 
    .0000    .0000    .0000    .0000    .0000    .0000 
    .0000    .0000    .0000    .0000    .0000    .0000 
    .0000    .0000    .0000    .0000    .0000    .0000 
    .0000    .0000    .0000    .0100    .0000    .0000 
    .0000    .0000    .0000    .0000    .0000    .0000 
    .0000    .0000    .0000    .0000    .0000    .0100 
 C  = 
   1.0000    .0000    .0000    .0000    .0000    .0000 
    .0000   1.0000    .0000    .0000    .0000    .0000 
    .0000    .0000   1.0000    .0000    .0000    .0000 
    .0000    .0000    .0000   1.0000    .0000    .0000 
    .0000    .0000    .0000    .0000   1.0000    .0000 
    .0000    .0000    .0000    .0000    .0000   1.0000 
 Q0 = 
   1.0000    .0000    .0000    .0000    .0000    .0000 
    .0000   1.0000    .0000    .0000    .0000    .0000 
    .0000    .0000   1.0000    .0000    .0000    .0000 
    .0000    .0000    .0000   1.0000    .0000    .0000 
    .0000    .0000    .0000    .0000   1.0000    .0000 
    .0000    .0000    .0000    .0000    .0000   1.0000 


---------------------------------------------------------------------------

HELP AND BUGS:
==============

If you have trouble either compiling or running the codes or if you find
any bugs please send an e-mail message reporting the problem or bug to 

        benner@mathematik.tu-chemnitz.de

We will get in touch with you as soon as possible.

---------------------------------------------------------------------------

REFERENCES:
===========

[1] P. Benner, A.J. Laub and V.Mehrmann
    'A Collection of Benchmark Examples for the Numerical Solution of
     Algebraic Riccati Equations I: Continuous-Time Case',
    Technical Report SPC 95_22, TU Chemnitz-Zwickau (FRG), 1995.

[2] Numerical Algorithms Group,
    'Implementation and Documentation Standards for the Subroutine 
     Library in Control and Systems Theory SLICOT',
    NAG Publication NP2032, Eindhoven/Oxford, 1990.

[3] E. Anderson, Z. Bai, C. Bischof, J. Demmel, J. Dongarra, J. Du Croz,
    A. Greenbaum, S. Hammarling, A. McKenney, S. Ostrouchov and D. Sorensen
    'LAPACK Users' Guide', 2nd edition, 
    SIAM, Philadelphia, PA, 1994.

---------------------------------------------------------------------------
 
CONTRIBUTORS:
=============

Peter Benner and Volker Mehrmann
Fakultaet fuer Mathematik
Technische Universitaet Chemnitz-Zwickau (FRG)
e-mail: benner@mathematik.tu-chemnitz.de
        mehrmann@mathematik.tu-chemnitz.de

Alan J. Laub
Department of Electrical and Computer Engineering
University of California
Santa Barbara, CA 93106-9560 (USA)
e-mail: laub@ece.ucsb.edu

---------------------------------------------------------------------------

Peter Benner, November 10, 1995.
