*     CAREXE EXAMPLE PROGRAM TEXT.
*
*     .. Parameters ..
      INTEGER          NIN, NOUT
      PARAMETER        (NIN = 5, NOUT = 6)
*     NEX - no. of examples available; NFEX - no. of examples without
*     parameters; NFSEX - no. of examples with fixed size; NSAEX -
*     no. of examples with analytical solution available ..
      INTEGER          NEX, NFEX, NFSEX, NSAEX
      PARAMETER        (NEX = 20, NFEX = 6, NFSEX = 14, NSAEX = 8)
      INTEGER          NMAX, MMAX, PMAX
      PARAMETER        (NMAX = 421, MMAX = 211, PMAX = 211)
      INTEGER          LDA, LDB, LDC, LDG, LDQ, LDX
      PARAMETER        (LDA = NMAX, LDB = NMAX, LDC = PMAX, LDG = NMAX,
     1                  LDQ = NMAX, LDX = NMAX)
      INTEGER          LDSYM
      PARAMETER        (LDSYM = NMAX*(NMAX+1)/2)
      INTEGER          LRWORK
      PARAMETER        (LRWORK = NMAX*MAX(4,NMAX))
*     .. Local Scalars ..
      INTEGER          I, IERR, J, K, N, NO, NPAR, M, P
      CHARACTER        FORM, STORE
      CHARACTER*70     NOTE
      CHARACTER*255    DATAF
*     .. Local Arrays ..
      DOUBLE PRECISION A(LDA, NMAX), B(LDA,MMAX), C(LDC,NMAX),
     1                 G(LDSYM), Q(LDQ,NMAX), X(LDX,NMAX), 
     2                 RWORK(LRWORK), DPARAM(7)
      INTEGER          SAEX(NSAEX)
*     .. External Subroutines ..
      EXTERNAL         CAREX, DLACPY, SP2SY
*     .. External Functions
      LOGICAL          LSAME
      EXTERNAL         LSAME
*     .. Data Statements ..
      DATA SAEX /1, 2, 7, 9, 10, 11, 12, 16/
*     .. Executable Statements ..
      WRITE (NOUT, FMT=99999)
*     Skip the heading in the data file and read the data.
      READ (NIN,FMT='()')
      READ (NIN,FMT=*) NO, NPAR
      IF ((NO .LE. 0) .OR. (NO .GT. NEX)) THEN
        WRITE (NOUT, FMT=99998) NO
      ELSE
        IF (NPAR .GT. 0) THEN
          IF ((NO .GT. NFEX) .AND. (NO .LE. NFSEX)) THEN
            READ (NIN,FMT=*) DPARAM(1)
          ELSE IF (NO .GT. NFSEX) THEN
            READ (NIN,FMT=*) N
            IF ((NO .LT. NEX) .AND. (NPAR .GT. 1))
     1        READ (NIN,FMT=*) (DPARAM(I),I=1,NPAR-1)
            IF (NO .EQ. NEX) READ (NIN,FMT=*) DATAF
          END IF
        END IF
        READ (NIN,FMT=*) FORM, STORE
*       Generate benchmark example
        CALL CAREX(NO, N, M, P, NPAR, DPARAM, DATAF, A, LDA, B, LDB, C, 
     1             LDC, G, LDG, Q, LDQ, X, LDX, NOTE, STORE, FORM,
     2             RWORK, IERR)
*
        IF (IERR .NE. 0) THEN
          WRITE (NOUT,FMT=99997) IERR
        ELSE
          WRITE (NOUT,FMT=*) NOTE
          WRITE (NOUT,FMT=99996) N
          WRITE (NOUT,FMT=99995) M
          WRITE (NOUT,FMT=99994) P
          WRITE (NOUT,FMT=99993)
          DO 10  I = 1, N
            WRITE (NOUT,FMT=99985) (A(I,J),J=1,N)
10        CONTINUE
*         Print B and R or print G, corresponding to mode parameter FORM
          IF (LSAME(FORM,'F') .OR. LSAME(FORM,'G')) THEN
            WRITE (NOUT,FMT=99992)
            DO 20  I = 1, N
              WRITE (NOUT,FMT=99985) (B(I,J),J=1,M)
20          CONTINUE
            WRITE (NOUT,FMT=99987)
            IF (.NOT. LSAME(STORE,'F')) THEN
*           Expand packed matrix to full storage mode using work array 
              CALL DLACPY('A', M*(M+1)/2, 1, G, LDSYM, RWORK, NMAX) 
              CALL SP2SY(M, RWORK, N, STORE, IERR) 
              DO 30  I = 1, M
                WRITE (NOUT,FMT=99985) (RWORK((I-1)*N+J),J=1,M)
30            CONTINUE
            ELSE
              DO 40  I = 1, M
                WRITE (NOUT,FMT=99985) (G((I-1)*LDG+J),J=1,M)
40            CONTINUE
            END IF
          ELSE
            WRITE (NOUT,FMT=99990)
            IF (.NOT. LSAME(STORE,'F')) THEN
*           .. expand packed matrix to full storage mode using work
*              array .. 
              CALL DLACPY('A', N*(N+1)/2, 1, G, LDSYM, RWORK, NMAX) 
              CALL SP2SY(N, RWORK, N, STORE, IERR) 
              DO 50  I = 1, N
                WRITE (NOUT,FMT=99985) (RWORK((I-1)*N+J),J=1,N)
50            CONTINUE
            ELSE
              DO 60  I = 1, M
                WRITE (NOUT,FMT=99985) (G((I-1)*N+J),J=1,N)
60            CONTINUE
            END IF
          END IF
*         Print C and Q0 or print Q, corresponding to mode parameter FORM 
          IF (LSAME(FORM,'F') .OR. LSAME(FORM,'Q')) THEN
            WRITE (NOUT,FMT=99991)
            DO 70  I = 1, P
              WRITE (NOUT,FMT=99985) (C(I,J),J=1,N)
70          CONTINUE
            WRITE (NOUT,FMT=99988)
            IF (.NOT. LSAME(STORE,'F')) THEN
*           Expand packed matrix to full storage mode 
              CALL SP2SY(P, Q, LDQ, STORE, IERR) 
              DO 80  I = 1, P
                WRITE (NOUT,FMT=99985) (Q(I,J),J=1,P)
80            CONTINUE
            ELSE
              DO 90  I = 1, P
                WRITE (NOUT,FMT=99985) (Q(I,J),J=1,P)
90            CONTINUE
            END IF
          ELSE
            WRITE (NOUT,FMT=99989)
            IF (.NOT. LSAME(STORE,'F')) THEN
*           Expand packed matrix to full storage mode 
              CALL SP2SY(N, Q, LDQ, STORE, IERR) 
              DO 100  I = 1, N
                WRITE (NOUT,FMT=99985) (Q(I,J),J=1,N)
100           CONTINUE
            ELSE
              DO 110  I = 1, N
                WRITE (NOUT,FMT=99985) (Q(I,J),J=1,N)
110           CONTINUE
            END IF
          END IF
*         Print solution if available 
          DO 130  K = 1, NSAEX
            IF (NO .EQ. SAEX(K)) THEN
              WRITE (NOUT,FMT=99986)
              DO 120  I = 1, N
                WRITE (NOUT,FMT=99985) (X(I,J),J=1,N)
120           CONTINUE
            END IF
130       CONTINUE
        END IF
      END IF 
      STOP
*
99999 FORMAT (' CAREX EXAMPLE PROGRAM RESULTS',/1X)
99998 FORMAT (/' NO is out of range.',/' NO = ',I5)
99997 FORMAT (' IERR on exit from CAREX = ',I1)
99996 FORMAT (/' Order of matrix A:               N  = ',I3)
99995 FORMAT (' Number of columns in matrix B:   M  = ',I3)
99994 FORMAT (' Number of rows in matrix C:      P  = ',I3)
99993 FORMAT (/' A  = ')
99992 FORMAT (' B  = ')
99991 FORMAT (' C  = ')
99990 FORMAT (' G  = ')
99989 FORMAT (' Q  = ')
99988 FORMAT (' Q0 = ')
99987 FORMAT (' R  = ')
99986 FORMAT (/' The solution matrix X is ')
99985 FORMAT (20(1X,F8.4))
      END
 
