#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_z3chke(char *sf) {
char *s;
int m, n, lda, ldb, ldc, k;
CBLAS_TEST_ZOMPLEX a, b, c, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans, transb;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha.real = 1.00;
   alpha.imag = 1.00;
   beta.real = 1.00;
   beta.imag = 1.00;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   ldb = 1;
   ldc = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   trans = CblasNoTrans;
   transb = CblasNoTrans;
   side = CblasLeft;
   diag = CblasNonUnit;
   uplo = CblasUpper;
   if (strncmp( sf,"ZGEMM",5)==0) {
      s = "CGEMM ";
      cblas_zgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_zgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      trans = CblasNoTrans;
      transb = INVALID;
      cblas_zgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"ZHEMM",5)==0) {
      s = "ZHEMM ";
      cblas_zhemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_zhemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_zhemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"ZSYMM",5)==0) {
      s = "ZSYMM ";
      cblas_zsymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_zsymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_zsymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHERK",5)==0) {
      s = "ZHERK ";
      cblas_zherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_zherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZSYRK",5)==0) {
      s = "ZSYRK ";
      cblas_zsyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zsyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_zsyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHER2K",6)==0) {
      s = "ZHER2K";
      cblas_zher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_zher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZSYR2K",6)==0) {
      s = "ZSYR2K";
      cblas_zsyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zsyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_zsyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTRMM",5)==0) {
      s = "ZTRMM ";
      cblas_ztrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_ztrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_ztrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTRSM",5)==0) {
      s = "ZTRSM ";
      cblas_ztrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_ztrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_ztrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}
