#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_z2chke(char *sf) {
char *s;
int m, n, lda, incx, incy, ku, kl, k;
CBLAS_TEST_ZOMPLEX a, y, x, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha.real = 1.0;
   alpha.imag = 1.0;
   beta.real = 1.0;
   beta.imag = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   incx = 1;
   incy = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   if (strncmp( sf,"ZGEMV",5)==0) {
      s = "ZGEMV ";
      trans = CblasNoTrans;
      cblas_zgemv(order, trans, m, n, &alpha, &a, lda, &x, incx, &beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_zgemv(order, trans, m, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"ZGBMV",5)==0) {
      s = "ZGBMV ";
      ku = 1;
      kl = 1;
      trans = CblasNoTrans;
      cblas_zgbmv(order, trans, m, n, kl, ku, &alpha, &a, lda, &x, incx, &beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_zgbmv(order, trans, m, n, kl, ku, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZGERC",5)==0) {
      s = "ZGERC ";
      cblas_zgerc( order, m, n, &alpha, &x, incx, &y, incy, &a, lda );
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZGERU",5)==0) {
      s = "ZGERU ";
      cblas_zgeru( order, m, n, &alpha, &x, incx, &y, incy, &a, lda );
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHEMV",5)==0) {
      s = "ZHEMV ";
      uplo = CblasUpper;
      cblas_zhemv(order, uplo, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zhemv(order, uplo, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHBMV",5)==0) {
      s = "ZHBMV ";
      uplo = CblasUpper;
      cblas_zhbmv(order, uplo, n, k, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zhbmv(order, uplo, n, k, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHPMV",5)==0) {
      s = "ZHPMV ";
      uplo = CblasUpper;
      cblas_zhpmv(order, uplo, n, &alpha, &a, &x, incx, &beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zhpmv(order, uplo, n, &alpha, &a, &x, incx, &beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTBMV",5)==0) {
      s = "ZTBMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTBSV",5)==0) {
      s = "ZTBSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTPMV",5)==0) {
      s = "ZTPMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTPSV",5)==0) {
      s = "ZTPSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTRMV",5)==0) {
      s = "ZTRMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZTRSV",5)==0) {
      s = "ZTRSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ztrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ztrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ztrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ztrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHPR2",5)==0) {
      s = "ZHPR2 ";
      uplo = CblasUpper;
      cblas_zhpr2(order, uplo, n, &alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zhpr2(order, uplo, n, &alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);
   }

/* this else if clause must follow error check for CHPR2 */
   else if (strncmp( sf,"ZHPR",4)==0) {
      s = "ZHPR  ";
      uplo = CblasUpper;
      cblas_zhpr(order, uplo, n, alpha.real, &x, incx, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zhpr(order, uplo, n, alpha.real, &x, incx, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"ZHER2",5)==0) {
      s = "ZHER2 ";
      uplo = CblasUpper;
      cblas_zher2(order, uplo, n, &alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zher2(order, uplo, n, &alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }

/* this else if clause must follow error check for CHER2 */
   else if (strncmp( sf,"ZHER",4)==0) {
      s = "ZHER  ";
      uplo = CblasUpper;
      cblas_zher(order, uplo, n, alpha.real, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_zher(order, uplo, n, alpha.real, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);
   }

   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}

void cblas_xerbla(char *s, int err) {
   lerr = PASSED;
   if (infot != err) {
      if (infot != 0) 
         printf("******* cblas_xerbla was called with info = %d instead of %d *******\n", err, infot);
      else
         printf("******* cblas_xerbla was called with info = %d *******\n",
         err);
      ok = FALSE;
   }
}

