#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_s3chke(char *sf) {
char *s;
int m, n, lda, ldb, ldc, k;
float a, b, c, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans, transb;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha = 1.0;
   beta = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   ldb = 1;
   ldc = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   trans = CblasNoTrans;
   transb = CblasNoTrans;
   side = CblasLeft;
   diag = CblasNonUnit;
   uplo = CblasUpper;

   if (strncmp( sf,"SGEMM",5)==0) {
      s = "SGEMM ";
      cblas_sgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_sgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      trans = CblasNoTrans;
      transb = INVALID;
      cblas_sgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYMM",5)==0) {
      s = "SSYMM ";
      cblas_ssymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_ssymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_ssymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYRK",5)==0) {
      s = "SSYRK ";
      cblas_ssyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ssyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYR2K",6)==0) {
      s = "SSYR2K";
      cblas_ssyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ssyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STRMM",5)==0) {
      s = "STRMM ";
      cblas_strmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_strmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_strmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_strmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_strmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STRSM",5)==0) {
      s = "STRSM ";
      cblas_strsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_strsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_strsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_strsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_strsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}
