#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_s2chke(char *sf) {
char *s;
int m, n, lda, incx, incy, ku, kl, k;
float a, y, x, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha = 1.0;
   beta = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   incx = 1;
   incy = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   if (strncmp( sf,"SGER",4)==0) {
      s = "SGER  ";
      cblas_sger(order, m, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SGEMV",5)==0) {
      s = "SGEMV ";
      trans = CblasNoTrans;
      cblas_sgemv(order, trans, m, n, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_sgemv(order, trans, m, n, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SGBMV",5)==0) {
      s = "SGBMV ";
      ku = 1;
      kl = 1;
      trans = CblasNoTrans;
      cblas_sgbmv(order, trans, m, n, kl, ku, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_sgbmv(order, trans, m, n, kl, ku, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYMV",5)==0) {
      s = "SSYMV ";
      uplo = CblasUpper;
      cblas_ssymv(order, uplo, n, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssymv(order, uplo, n, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYR",4)==0) {
      s = "SSYR  ";
      uplo = CblasUpper;
      cblas_ssyr(order, uplo, n, alpha, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssyr(order, uplo, n, alpha, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSYR2",5)==0) {
      s = "SSYR2 ";
      uplo = CblasUpper;
      cblas_ssyr2(order, uplo, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssyr2(order, uplo, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSBMV",5)==0) {
      s = "SSBMV ";
      uplo = CblasUpper;
      cblas_ssbmv(order, uplo, n, k, alpha, &a, lda, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ssbmv(order, uplo, n, k, alpha, &a, lda, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSPMV",5)==0) {
      s = "SSPMV ";
      uplo = CblasUpper;
      cblas_sspmv(order, uplo, n, alpha, &a, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_sspmv(order, uplo, n, alpha, &a, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSPR",4)==0) {
      s = "SSPR  ";
      uplo = CblasUpper;
      cblas_sspr(order, uplo, n, alpha, &x, incx, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_sspr(order, uplo, n, alpha, &x, incx, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"SSPR2",5)==0) {
      s = "SSPR2 ";
      uplo = CblasUpper;
      cblas_sspr2(order, uplo, n, alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_sspr2(order, uplo, n, alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STRMV",5)==0) {
      s = "STRMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_strmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_strmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_strmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_strmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STRSV",5)==0) {
      s = "STRSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_strsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_strsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_strsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_strsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STBSV",5)==0) {
      s = "STBSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_stbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_stbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_stbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_stbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STBMV",5)==0) {
      s = "STBMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_stbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_stbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_stbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_stbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STPSV",5)==0) {
      s = "STPSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_stpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_stpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_stpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_stpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"STPMV",5)==0) {
      s = "STPMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_stpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_stpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_stpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_stpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}
