#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_d3chke(char *sf) {
char *s;
int m, n, lda, ldb, ldc, k;
double a, b, c, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans, transb;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha = 1.0;
   beta = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   ldb = 1;
   ldc = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   trans = CblasNoTrans;
   transb = CblasNoTrans;
   side = CblasLeft;
   diag = CblasNonUnit;
   uplo = CblasUpper;

   if (strncmp( sf,"DGEMM",5)==0) {
      s = "DGEMM ";
      cblas_dgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_dgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      trans = CblasNoTrans;
      transb = INVALID;
      cblas_dgemm(order, trans, transb, m, n, k, alpha, &a, lda, &b, ldb,
		  beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYMM",5)==0) {
      s = "DSYMM ";
      cblas_dsymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_dsymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_dsymm(order, side, uplo, m, n, alpha, &a, lda, &b, ldb, beta, 
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYRK",5)==0) {
      s = "DSYRK ";
      cblas_dsyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dsyrk(order, uplo, trans, n, k, alpha, &a, lda, beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYR2K",6)==0) {
      s = "DSYR2K";
      cblas_dsyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dsyr2k(order, uplo, trans, n, k, alpha, &a, lda, &b, ldb,
		   beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTRMM",5)==0) {
      s = "DTRMM ";
      cblas_dtrmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_dtrmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_dtrmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtrmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtrmm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTRSM",5)==0) {
      s = "DTRSM ";
      cblas_dtrsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_dtrsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_dtrsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtrsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtrsm(order, side, uplo, trans, diag, m, n, alpha, &a, lda, 
		  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}
