#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_d2chke(char *sf) {
char *s;
int m, n, lda, incx, incy, ku, kl, k;
double a, y, x, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha = 1.0;
   beta = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   incx = 1;
   incy = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   if (strncmp( sf,"DGER",4)==0) {
      s = "DGER  ";
      cblas_dger(order, m, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DGEMV",5)==0) {
      s = "DGEMV ";
      trans = CblasNoTrans;
      cblas_dgemv(order, trans, m, n, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_dgemv(order, trans, m, n, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DGBMV",5)==0) {
      s = "DGBMV ";
      ku = 1;
      kl = 1;
      trans = CblasNoTrans;
      cblas_dgbmv(order, trans, m, n, kl, ku, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_dgbmv(order, trans, m, n, kl, ku, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYMV",5)==0) {
      s = "DSYMV ";
      uplo = CblasUpper;
      cblas_dsymv(order, uplo, n, alpha, &a, lda, &x, incx, beta, 
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsymv(order, uplo, n, alpha, &a, lda, &x, incx, beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYR",4)==0) {
      s = "DSYR  ";
      uplo = CblasUpper;
      cblas_dsyr(order, uplo, n, alpha, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsyr(order, uplo, n, alpha, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSYR2",5)==0) {
      s = "DSYR2 ";
      uplo = CblasUpper;
      cblas_dsyr2(order, uplo, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsyr2(order, uplo, n, alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSBMV",5)==0) {
      s = "DSBMV ";
      uplo = CblasUpper;
      cblas_dsbmv(order, uplo, n, k, alpha, &a, lda, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dsbmv(order, uplo, n, k, alpha, &a, lda, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSPMV",5)==0) {
      s = "DSPMV ";
      uplo = CblasUpper;
      cblas_dspmv(order, uplo, n, alpha, &a, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dspmv(order, uplo, n, alpha, &a, &x, incx, beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSPR",4)==0) {
      s = "DSPR  ";
      uplo = CblasUpper;
      cblas_dspr(order, uplo, n, alpha, &x, incx, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dspr(order, uplo, n, alpha, &x, incx, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DSPR2",5)==0) {
      s = "DSPR2 ";
      uplo = CblasUpper;
      cblas_dspr2(order, uplo, n, alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dspr2(order, uplo, n, alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTRMV",5)==0) {
      s = "DTRMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTRSV",5)==0) {
      s = "DTRSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTBSV",5)==0) {
      s = "DTBSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTBMV",5)==0) {
      s = "DTBMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTPSV",5)==0) {
      s = "DTPSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"DTPMV",5)==0) {
      s = "DTPMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_dtpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_dtpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_dtpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_dtpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}


