#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_c3chke(char *sf) {
char *s;
int m, n, lda, ldb, ldc, k;
CBLAS_TEST_COMPLEX a, b, c, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans, transb;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha.real = 1.0;
   alpha.imag = 1.0;
   beta.real = 1.0;
   beta.imag = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   ldb = 1;
   ldc = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   trans = CblasNoTrans;
   transb = CblasNoTrans;
   side = CblasLeft;
   diag = CblasNonUnit;
   uplo = CblasUpper;
   if (strncmp( sf,"CGEMM",5)==0) {
      s = "CGEMM ";
      cblas_cgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_cgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      trans = CblasNoTrans;
      transb = INVALID;
      cblas_cgemm(order, trans, transb, m, n, k, &alpha, &a, lda, &b, ldb,
                  &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"CHEMM",5)==0) {
      s = "CHEMM ";
      cblas_chemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_chemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_chemm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"CSYMM",5)==0) {
      s = "CSYMM ";
      cblas_csymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_csymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_csymm(order, side, uplo, m, n, &alpha, &a, lda, &b, ldb, &beta,
                  &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHERK",5)==0) {
      s = "CHERK ";
      cblas_cherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_cherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_cherk(order, uplo, trans, n, k, alpha.real, &a, lda, beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CSYRK",5)==0) {
      s = "CSYRK ";
      cblas_csyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_csyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_csyrk(order, uplo, trans, n, k, &alpha, &a, lda, &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHER2K",6)==0) {
      s = "CHER2K";
      cblas_cher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_cher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_cher2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   beta.real, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CSYR2K",6)==0) {
      s = "CSYR2K";
      cblas_csyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_csyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_csyr2k(order, uplo, trans, n, k, &alpha, &a, lda, &b, ldb,
                   &beta, &c, ldc);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTRMM",5)==0) {
      s = "CTRMM ";
      cblas_ctrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_ctrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_ctrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctrmm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTRSM",5)==0) {
      s = "CTRSM ";
      cblas_ctrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      side = INVALID;
      cblas_ctrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      side = CblasLeft;
      uplo = INVALID;
      cblas_ctrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);

      infot = 5;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctrsm(order, side, uplo, trans, diag, m, n, &alpha, &a, lda,
                  &b, ldb);
      chkxer(s, infot, lerr, ok);
   }
   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}
