#include "cblas.h"
#include "cblas_test.h"
#define  TRUE     1
#define  FALSE    0
#define  PASSED   1
#define  FAILED   0
#define  INVALID -1

void chkxer(char *s, int infot, int lerr, int ok) ;
int infot, lerr, ok;
void F77_c2chke(char *sf) {
char *s;
int m, n, lda, incx, incy, ku, kl, k;
CBLAS_TEST_COMPLEX a, y, x, alpha, beta;
 
CBLAS_ORDER order;
CBLAS_TRANSPOSE trans;
CBLAS_SIDE side;
CBLAS_UPLO uplo;
CBLAS_DIAG diag;

   alpha.real = 1.0;
   alpha.imag = 1.0;
   beta.real = 1.0;
   beta.imag = 1.0;
   m = 1;
   n = 1;
   k = 1;
   lda = 1;
   incx = 1;
   incy = 1;
   ok = TRUE;
   lerr = FAILED;
   infot = 1;
   order = INVALID;
   if (strncmp( sf,"CGEMV",5)==0) {
      s = "CGEMV ";
      trans = CblasNoTrans;
      cblas_cgemv(order, trans, m, n, &alpha, &a, lda, &x, incx, &beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_cgemv(order, trans, m, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   if (strncmp( sf,"CGBMV",5)==0) {
      s = "CGBMV ";
      ku = 1;
      kl = 1;
      trans = CblasNoTrans;
      cblas_cgbmv(order, trans, m, n, kl, ku, &alpha, &a, lda, &x, incx, &beta, 
		  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      trans = INVALID;
      cblas_cgbmv(order, trans, m, n, kl, ku, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CGERC",5)==0) {
      s = "CGERC ";
      cblas_cgerc( order, m, n, &alpha, &x, incx, &y, incy, &a, lda );
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CGERU",5)==0) {
      s = "CGERU ";
      cblas_cgeru( order, m, n, &alpha, &x, incx, &y, incy, &a, lda );
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHEMV",5)==0) {
      s = "CHEMV ";
      uplo = CblasUpper;
      cblas_chemv(order, uplo, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_chemv(order, uplo, n, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHBMV",5)==0) {
      s = "CHBMV ";
      uplo = CblasUpper;
      cblas_chbmv(order, uplo, n, k, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_chbmv(order, uplo, n, k, &alpha, &a, lda, &x, incx, &beta,
                  &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHPMV",5)==0) {
      s = "CHPMV ";
      uplo = CblasUpper;
      cblas_chpmv(order, uplo, n, &alpha, &a, &x, incx, &beta, &y, incy);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_chpmv(order, uplo, n, &alpha, &a, &x, incx, &beta, &y, incy);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTBMV",5)==0) {
      s = "CTBMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctbmv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTBSV",5)==0) {
      s = "CTBSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctbsv(order, uplo, trans, diag, n, k, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTPMV",5)==0) {
      s = "CTPMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctpmv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTPSV",5)==0) {
      s = "CTPSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctpsv(order, uplo, trans, diag, n, &a, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTRMV",5)==0) {
      s = "CTRMV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctrmv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CTRSV",5)==0) {
      s = "CTRSV ";
      trans = CblasNoTrans;
      uplo = CblasUpper;
      diag = CblasNonUnit;
      cblas_ctrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_ctrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 3;
      uplo = CblasUpper;
      trans = INVALID;
      cblas_ctrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);

      infot = 4;
      trans = CblasNoTrans;
      diag = INVALID;
      cblas_ctrsv(order, uplo, trans, diag, n, &a, lda, &x, incx);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHPR2",5)==0) {
      s = "CHPR2 ";
      uplo = CblasUpper;
      cblas_chpr2(order, uplo, n, &alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_chpr2(order, uplo, n, &alpha, &x, incx, &y, incy, &a);
      chkxer(s, infot, lerr, ok);
   }

/* this else if clause must follow error check for CHPR2 */
   else if (strncmp( sf,"CHPR",4)==0) {
      s = "CHPR  ";
      uplo = CblasUpper;
      cblas_chpr(order, uplo, n, alpha.real, &x, incx, &a);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_chpr(order, uplo, n, alpha.real, &x, incx, &a);
      chkxer(s, infot, lerr, ok);
   }
   else if (strncmp( sf,"CHER2",5)==0) {
      s = "CHER2 ";
      uplo = CblasUpper;
      cblas_cher2(order, uplo, n, &alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_cher2(order, uplo, n, &alpha, &x, incx, &y, incy, &a, lda);
      chkxer(s, infot, lerr, ok);
   }

/* this else if clause must follow error check for CHER2 */
   else if (strncmp( sf,"CHER",4)==0) {
      s = "CHER  ";
      uplo = CblasUpper;
      cblas_cher(order, uplo, n, alpha.real, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);

      infot = 2;
      order = CblasColMajor;
      uplo = INVALID;
      cblas_cher(order, uplo, n, alpha.real, &x, incx, &a, lda);
      chkxer(s, infot, lerr, ok);
   }

   if (ok == TRUE)
       printf("%s PASSED THE TESTS OF ERROR-EXITS\n", s);
   else
       printf("******* %s FAILED THE TESTS OF ERROR-EXITS *******\n",s);
}

void chkxer(char *s, int infot, int lerr, int ok) {
   if (lerr == FAILED) {
      printf(" ***** ILLEGAL VALUE OF PARAMETER NUMBER %d NOT DETECTED BY %s *****\n", infot, s);
      ok = FALSE;
   }
   lerr = FAILED;
}

void cblas_xerbla(char *s, int err) {
   lerr = PASSED;
   if (infot != err) {
      if (infot != 0) 
         printf("******* cblas_xerbla was called with info = %d instead of %d *******\n", err, infot);
      else
         printf("******* cblas_xerbla was called with info = %d *******\n",
         err);
      ok = FALSE;
   }
}

