#include "cblas.h"
#include "cblas_fortran_header.h"

int CBLAS_CallFromC=0;

#include <ctype.h>
#include <stdio.h>

#define XerblaStrLen 6
#define XerblaStrLen1 7

#ifdef F77_Char
void F77_xerbla(F77_Char F77_srname, void *vinfo)
#else
void F77_xerbla(char *srname, void *vinfo)
#endif

{
#ifdef F77_Char
   char *srname;
#endif

   char rout[XerblaStrLen1];

#ifdef F77_Integer
   F77_Integer *info=vinfo;
   F77_Integer i;
#else
   int *info=vinfo;
   int i;
#endif

   extern int CBLAS_CallFromC;

#ifdef F77_Char
   srname = F2C_STR(F77_srname, XerblaStrLen);
#endif

   if (CBLAS_CallFromC)
   {
      for(i=0; i != XerblaStrLen; i++) rout[i] = tolower(srname[i]);
      rout[XerblaStrLen] = '\0';
      fprintf(stderr, "Parameter %d to routine cblas_%s was incorrect\n",
              *info+1, rout);
   }
   else
   {
      fprintf(stderr, "Parameter %d to routine %s was incorrect\n",
              *info, srname);
   }
}
