/*
 * cblas_zswap.c
 *
 * The program is a C interface to zswap.
 *
 * Written by Keita Teranishi.  2/11/1998
 *
 */
#include "cblas.h"
#include "cblas_f77.h"
#include "cblas_fortran_header.h"
void cblas_zswap( const int N, void  *X, const int incX, void  *Y,
                       const int incY)
{
#ifdef F77_Integer
   F77_integer F77_N=N, F77_incX=incX, F77_incY=incY;
#else 
   #define F77_N N
   #define F77_incX incX
   #define F77_incY incY
#endif
   F77_zswap( &F77_N, X, &F77_incX, Y, &F77_incY);
}
