/*
 * cblas_sscal.c
 *
 * The program is a C interface to sscal.
 *
 * Written by Keita Teranishi.  2/11/1998
 *
 */
#include "cblas.h"
#include "cblas_f77.h"
#include "cblas_fortran_header.h"
void cblas_sscal( const int N, const float alpha, float *X, 
                       const int incX)
{
#ifdef F77_Integer
   F77_integer F77_N=N, F77_incX=incX;
#else 
   #define F77_N N
   #define F77_incX incX
#endif
   F77_sscal( &F77_N, &alpha, X, &F77_incX);
}
