/*
 *
 * cblas_ssbmv.c
 * This program is a C interface to ssbmv.
 * Written by Keita Teranishi
 * 4/6/1998
 *
 */
#include "cblas.h"
#include "cblas_f77.h"
#include "cblas_fortran_header.h"
void cblas_ssbmv(const CBLAS_ORDER order, const CBLAS_UPLO Uplo,
           const int N, const int K, const float alpha, const float *A,
           const int lda, const float *X, const int incX,
           const float beta, float *Y, const int incY)
{
   char UL;
#ifdef F77_Char
   F77_Char F77_UL;
#else
   #define F77_UL &UL   
#endif

#ifdef F77_Integer
   F77_Integer F77_N=N, F77_K=K, F77_lda=lda, F77_incX=incX, F77_incY=incY;
#else
   #define F77_N N
   #define F77_K K
   #define F77_lda lda
   #define F77_incX incX
   #define F77_incY incY
#endif
   extern int CBLAS_CallFromC;

   CBLAS_CallFromC = 1;
   if (order == CblasColMajor)
   {
   
      if (Uplo == CblasUpper) UL = 'U';
      else if (Uplo == CblasLower) UL = 'L';
      else cblas_xerbla(2, "cblas_ssbmv",
                        "Illegal Uplo setting, %d\n",Uplo );
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif
      F77_ssbmv(F77_UL, &F77_N, &F77_K, &alpha, A, &F77_lda, X,
      &F77_incX, &beta, Y, &F77_incY);
   }else if (order == CblasRowMajor)
   {
      if (Uplo == CblasUpper) UL = 'L';
      else if (Uplo == CblasLower) UL = 'U';
      else cblas_xerbla(2, "cblas_ssbmv",
                        "Illegal Uplo setting, %d\n", Uplo);
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif
      F77_ssbmv(F77_UL, &F77_N, &F77_K, &alpha, A, &F77_lda, X,
      &F77_incX, &beta, Y, &F77_incY);
   }
   else cblas_xerbla(1, "cblas_ssbmv",
                     "Illegal Order setting, %d\n", order);
   CBLAS_CallFromC = 0;
   return;
}
