/*
 *
 * cblas_dsymv.c
 * This program is a C interface to dsymv.
 * Written by Keita Teranishi
 * 4/6/1998
 *
 */

#include "cblas.h"
#include "cblas_f77.h"
#include "cblas_fortran_header.h"
void cblas_dsymv(const CBLAS_ORDER order,
                 const CBLAS_UPLO Uplo, const int N,
                 const double alpha, const double  *A, const int lda,
                 const double  *X, const int incX, const double beta,
                 double  *Y, const int incY)
{
   char UL;
#ifdef F77_Char
   F77_Char F77_UL;
#else
   #define F77_UL &UL   
#endif
#ifdef F77_Integer
   F77_Integer F77_N=N, F77_lda=lda, F77_incX=incX, F77_incY=incY;
#else
   #define F77_N N
   #define F77_lda lda
   #define F77_incX incX
   #define F77_incY incY
#endif
   extern int CBLAS_CallFromC;

   CBLAS_CallFromC = 1;
   if (order == CblasColMajor)
   {
      if (Uplo == CblasUpper) UL = 'U';
      else if (Uplo == CblasLower) UL = 'L';
      else cblas_xerbla(2, "cblas_dsymv",
                        "Illegal Uplo setting, %d\n",Uplo );
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif
      F77_dsymv(F77_UL, &F77_N, &alpha, A, &F77_lda, X,  
                     &F77_incX, &beta, Y, &F77_incY);
   }
   else if (order == CblasRowMajor)
   {
      if (Uplo == CblasUpper) UL = 'L';
      else if (Uplo == CblasLower) UL = 'U';
      else cblas_xerbla(2, "cblas_dsymv",
                        "Illegal Uplo setting, %d\n", Uplo);
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif
      F77_dsymv(F77_UL, &F77_N, &alpha, 
                     A ,&F77_lda, X,&F77_incX, &beta, Y, &F77_incY);
   }
   else cblas_xerbla(1, "cblas_dsymv",
                     "Illegal Order setting, %d\n", order);
   CBLAS_CallFromC = 0;
}
