/*
 * cblas_dspr2.c
 * The program is a C interface to dspr2.
 *
 * Keita Teranishi  5/20/98
 *
 */
#include "cblas.h"
#include "cblas_f77.h"
#include "cblas_fortran_header.h"
void cblas_dspr2(const CBLAS_ORDER order, const CBLAS_UPLO Uplo,
                const int N, const double  alpha, const double  *X,
                const int incX, const double  *Y, const int incY, double  *A)
{
   char UL;
#ifdef F77_Char
   F77_Char F77_UL;
#else
   #define F77_UL &UL
#endif

#ifdef F77_Integer
   F77_Integer F77_N=N, F77_incX=incX, F77_incY=incY;
#else
   #define F77_N N
   #define F77_incX incX
   #define F77_incY incY
#endif

   extern int CBLAS_CallFromC;
   CBLAS_CallFromC = 1;
   if (order == CblasColMajor)
   {
      if (Uplo == CblasLower) UL = 'L';
      else if (Uplo == CblasUpper) UL = 'U';
      else cblas_xerbla(2, "cblas_dspr2",
                        "Illegal Uplo setting, %d\n",Uplo );
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif

      F77_dspr2(F77_UL, &F77_N, &alpha, X, &F77_incX, Y, &F77_incY, A);

   }  else if (order == CblasRowMajor) 
   {
      if (Uplo == CblasLower) UL = 'U';
      else if (Uplo == CblasUpper) UL = 'L';
      else cblas_xerbla(2, "cblas_dspr2",
                        "Illegal Uplo setting, %d\n",Uplo );
      #ifdef F77_Char
         F77_UL = C2F_CHAR(&UL);
      #endif  
      F77_dspr2(F77_UL, &F77_N, &alpha, X, &F77_incX, Y, &F77_incY,  A); 
   } else cblas_xerbla(1, "cblas_dspr2",
                     "Illegal Order setting, %d\n", order);
   CBLAS_CallFromC = 0;
}
