#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cztrbr2d(ConTxt, scope, top, uplo, diag, m, n, A, lda, rsrc, csrc)
int  ConTxt;
char  *scope;
char  *top;
char  *uplo;
char  *diag;
int  m;
int  n;
double  *A;
int  lda;
int  rsrc;
int  csrc;
#else
void ztrbr2d_(ConTxt, scope, top, uplo, diag, m, n, A, lda, rsrc, csrc)
int  *ConTxt;
char  *scope;
char  *top;
char  *uplo;
char  *diag;
int  *m;
int  *n;
double  *A;
int  *lda;
int  *rsrc;
int  *csrc;
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Broadcast/receive for trapezoidal double complex arrays.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to double complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void tvcopy16();
   void vtcopy16();
   int Shyp_br();
   int Sidring_br();
   int Ssring_br();
   int Smpath_br();
   int Stree_br();
   char *getbuff();
   BLACSCONTEXT *ctxt;
   char *buff;
   int length;
   char ttop, tscope, tuplo, tdiag;
   int tlda, error;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);
   tdiag = Mlowcase(*diag);
   tuplo = Mlowcase(*uplo);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_BR, __FILE__, tscope, tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(m) <= Mpval(lda)) tlda = Mpval(lda);
   else tlda = Mpval(m);

   trsize(tdiag, Mpval(m), Mpval(n), sizeof(DCOMPLEX), length);
   buff = getbuff(length);

   switch(ttop)
   {
   case ' ':
      error = Stree_br(ctxt, tscope, buff, length, 2, Mpval(rsrc), Mpval(csrc));
      break;
   case 'h':
      error = Shyp_br(ctxt, tscope, buff, length, Mpval(rsrc), Mpval(csrc));
      if (error == NPOW2)
         error = Stree_br(ctxt, tscope, buff, length, 2,
                          Mpval(rsrc), Mpval(csrc));
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      error = Stree_br(ctxt, tscope, buff, length, ttop-47,
                       Mpval(rsrc), Mpval(csrc));
      break;
   case 't':
      error = Stree_br(ctxt, tscope, buff, length, ctxt->Nb_bs,
                       Mpval(rsrc), Mpval(csrc));
      break;
   case 'i':
      error = Sidring_br(ctxt, tscope, buff, length, Mpval(rsrc),
                         Mpval(csrc), 1);
      break;
   case 'd':
      error = Sidring_br(ctxt, tscope, buff, length, Mpval(rsrc),
                         Mpval(csrc), -1);
      break;
   case 's':
      error = Ssring_br(ctxt, tscope, buff, length,
                        Mpval(rsrc), Mpval(csrc));
      break;
   case 'm':
      error = Smpath_br(ctxt, tscope, buff, length, ctxt->Nr_bs,
                        Mpval(rsrc), Mpval(csrc));
      break;
   case 'f':
      error = Smpath_br(ctxt, tscope, buff, length, FULLCON,
                        Mpval(rsrc), Mpval(csrc));
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

#if (BlacsDebugLvl > 0)
   if (error == BADSCP)
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown scope '%c'", *scope);
#endif
   zvtcopy(tuplo, tdiag, Mpval(m), Mpval(n), A, tlda, buff);
}
