#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cztrsd2d(int ConTxt, char *uplo, char *diag, int m, int n, double *A,
              int lda, int rdest, int cdest)
#else
void ztrsd2d_(int *ConTxt, char *uplo, char *diag, int *m, int *n, double *A,
              int *lda, int *rdest, int *cdest)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point-to-point trapezoidal double complex send.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to double complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination process.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination process.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
   void tvcopy16(char, char, int, int, double *, int, double *);
   void Asend2dID(BLACSCONTEXT *, BLACBUFF *, int, int, int);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);

   int length, tlda;
   BLACBUFF *bp;
   BLACSCONTEXT *ctxt;
   char tuplo, tdiag;

   MGetConTxt(Mpval(ConTxt), ctxt);
   tuplo = Mlowcase(*uplo);
   tdiag = Mlowcase(*diag);

#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_SD, __FILE__, 'a', tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rdest), Mpaddress(cdest));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);

/*
 * Get buff, pack, and send message
 */
   trsize(tdiag, Mpval(m), Mpval(n), sizeof(DCOMPLEX), length);
   bp = getbuff(length);
   ztvcopy(tuplo, tdiag, Mpval(m), Mpval(n), A, tlda, bp->Buff);
   Asend2dID(ctxt, bp, length, Mpval(rdest), Mpval(cdest));

/*
 * Having started the async send, update the buffers (reform links, check if
 * active buffers have become inactive, etc.)
 */
   UpdateBuffs(bp);
}  /* end of ztrsd2d_ */
