#include "Bdef.h"

#if (INTFACE == C_CALL)
void Csgerv2d(int ConTxt, int m, int n, float *A, int lda, int rsrc, int csrc)
#else
void sgerv2d_(int *ConTxt, int *m, int *n, float *A, int *lda, int *rsrc, int *csrc)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point to point general real receive.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to real two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
/*
 *  Prototypes and variable declarations
 */
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
   void vmcopy4(int, int, int *, int, int *);
   void Srecv2dID(BLACSCONTEXT *, char *, int, int, int);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);
   int tlda;
   int length;
   char *buff;
   extern BLACBUFF *ActiveQ00;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_RV, __FILE__, 'a', 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);
/*
 * If message is contiguous, recv into user's space, else get buffer.
 */
   length = Mpval(m) * Mpval(n) * sizeof(float);
   if ( (Mpval(m) == tlda) || (Mpval(n) == 1) )
      Srecv2dID(ctxt, (char *) A, length, Mpval(rsrc), Mpval(csrc));
/*
 * Otherwise, receive into buff, and unpack
 */
   else
   {
      buff = (getbuff(length))->Buff;
      Srecv2dID(ctxt, buff, length, Mpval(rsrc), Mpval(csrc));
      svmcopy(Mpval(m), Mpval(n), A, tlda, buff);
   }
   if (ActiveQ00) UpdateBuffs(NULL);
}
