#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cdtrbr2d(int ConTxt, char *scope, char *top, char *uplo, char *diag,
              int m, int n, double *A, int lda, int rsrc, int csrc)
#else
void dtrbr2d_(int *ConTxt, char *scope, char *top, char *uplo, char *diag,
              int *m, int *n, double *A, int *lda, int *rsrc, int *csrc)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Broadcast/receive for trapezoidal double precision arrays.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  UPLO    (input) Ptr to char
 *          Specifies the part of the matrix to be sent.
 *          = 'U':      Upper trapezoidal part
 *          ELSE :      Lower trapezoidal part
 *
 *  DIAG    (input) Ptr to char
 *          Specifies whether the matrix is unit diagonal or not.
 *          = 'U':      Matrix is unit diagonal, diagonal not communicated.
 *          ELSE :      Matrix is not unit diagonal, diagonal is communicated.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to double precision two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *          If UPLO = 'U', only the upper trapezoid is accessed;
 *          if UPLO = 'L', only the lower trapezoid is accessed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
   void tvcopy8(char, char, int, int, double *, int, double *);
   void vtcopy8(char, char, int, int, double *, int, double *);
   int Ahyp_br(BLACSCONTEXT *, char, BLACBUFF *, int, int, int);
   int Aidring_br(BLACSCONTEXT *, char, BLACBUFF *, int, int, int, int);
   int Asring_br(BLACSCONTEXT *, char, BLACBUFF *, int, int, int);
   int Ampath_br(BLACSCONTEXT *, char, BLACBUFF *, int, int, int, int);
   int Atree_br(BLACSCONTEXT *, char, BLACBUFF *, int, int, int, int);
   int Shyp_br(BLACSCONTEXT *, char, char *, int, int, int);
   int Sidring_br(BLACSCONTEXT *, char, char *, int, int, int, int);
   int Ssring_br(BLACSCONTEXT *, char, char *, int, int, int);
   int Smpath_br(BLACSCONTEXT *, char, char *, int, int, int, int);
   int Stree_br(BLACSCONTEXT *, char, char *, int, int, int, int);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);
   BLACSCONTEXT *ctxt;
   BLACBUFF *bp=NULL;
   int length;
   char ttop, tscope, tuplo, tdiag;
   int tlda, error;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);
   tdiag = Mlowcase(*diag);
   tuplo = Mlowcase(*uplo);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_BR, __FILE__, tscope, tuplo, tdiag, Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(m) <= Mpval(lda)) tlda = Mpval(lda);
   else tlda = Mpval(m);

   trsize(tdiag, Mpval(m), Mpval(n), sizeof(double), length);
   bp = getbuff(length);

   switch(ttop)
   {
   case ' ':
      if (bp == NULL)
         error = Stree_br(ctxt, tscope, (char *) A, length, 2,
                          Mpval(rsrc), Mpval(csrc));
      else
         error = Atree_br(ctxt, tscope, bp, length, 2,
                          Mpval(rsrc), Mpval(csrc));
      break;
   case 'h':
      if (bp == NULL)
      {
         error = Shyp_br(ctxt, tscope, (char *) A, length,
                         Mpval(rsrc), Mpval(csrc));
         if (error == NPOW2)
            error = Stree_br(ctxt, tscope, (char *) A, length, 2,
                             Mpval(rsrc), Mpval(csrc));
      }
      else
      {
         error = Ahyp_br(ctxt, tscope, bp, length,
                         Mpval(rsrc), Mpval(csrc));
         if (error == NPOW2)
            error = Atree_br(ctxt, tscope, bp, length, 2,
                             Mpval(rsrc), Mpval(csrc));
      }
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      if (bp == NULL)
         error = Stree_br(ctxt, tscope, (char *) A, length, ttop-47,
                          Mpval(rsrc), Mpval(csrc));
      else
         error = Atree_br(ctxt, tscope, bp, length, ttop-47,
                          Mpval(rsrc), Mpval(csrc));
      break;
   case 't':
      if (bp == NULL)
         error = Stree_br(ctxt, tscope, (char *) A, length, ctxt->Nb_bs,
                          Mpval(rsrc), Mpval(csrc));
      else
         error = Atree_br(ctxt, tscope, bp, length, ctxt->Nb_bs,
                          Mpval(rsrc), Mpval(csrc));
      break;
   case 'i':
      if (bp == NULL)
         error = Sidring_br(ctxt, tscope, (char *) A, length, Mpval(rsrc),
                            Mpval(csrc), 1);
      else
         error = Aidring_br(ctxt, tscope, bp, length, Mpval(rsrc),
                            Mpval(csrc), 1);
      break;
   case 'd':
      if (bp == NULL)
         error = Sidring_br(ctxt, tscope, (char *) A, length, Mpval(rsrc),
                            Mpval(csrc), -1);
      else
         error = Aidring_br(ctxt, tscope, bp, length, Mpval(rsrc),
                            Mpval(csrc), -1);
      break;
   case 's':
      if (bp == NULL)
         error = Ssring_br(ctxt, tscope, (char *) A, length,
                           Mpval(rsrc), Mpval(csrc));
      else
         error = Asring_br(ctxt, tscope, bp, length,
                           Mpval(rsrc), Mpval(csrc));
      break;
   case 'm':
      if (bp == NULL)
         error = Smpath_br(ctxt, tscope, (char *) A, length, ctxt->Nr_bs,
                           Mpval(rsrc), Mpval(csrc));
      else
         error = Ampath_br(ctxt, tscope, bp, length, ctxt->Nr_bs,
                           Mpval(rsrc), Mpval(csrc));
      break;
   case 'f':
      if (bp == NULL)
         error = Smpath_br(ctxt, tscope, (char *) A, length, FULLCON,
                           Mpval(rsrc), Mpval(csrc));
      else
         error = Ampath_br(ctxt, tscope, bp, length, FULLCON,
                           Mpval(rsrc), Mpval(csrc));
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

#if (BlacsDebugLvl > 0)
   if (error == BADSCP)
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown scope '%c'", *scope);
#endif
   dvtcopy(tuplo, tdiag, Mpval(m), Mpval(n), A, tlda, bp->Buff);
   UpdateBuffs(bp);
}
