#include "Bdef.h"

#if (INTFACE == C_CALL)
void Ccgesd2d(int ConTxt, int m, int n, float *A, int lda,
              int rdest, int cdest)
#else
void cgesd2d_(int *ConTxt, int *m, int *n, float *A, int *lda,
              int *rdest, int *cdest)
#endif
/*
 *  -- V1.1 BLACS routine --
 *  University of Tennessee, May 1, 1996
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Locally-blocking point-to-point general complex send.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (input) Ptr to complex two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *  RDEST   (input) Ptr to int
 *          The process row of the destination process.
 *
 *  CDEST   (input) Ptr to int
 *          The process column of the destination process.
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00(int, int, char *, char, char, char, int, int, int, int,
                   int *, int *);
#endif
   void mvcopy8(int, int, double *, int, double *);
   void Asend2dID(BLACSCONTEXT *, BLACBUFF *, int, int, int);
   void UpdateBuffs(BLACBUFF *);
   BLACBUFF *getbuff(int);
   int BuffIsFree(BLACBUFF *, int);

   int length, tlda;
   BLACBUFF *bp;
   BLACSCONTEXT *ctxt;

   MGetConTxt(Mpval(ConTxt), ctxt);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_SD, __FILE__, 'a', 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rdest), Mpaddress(cdest));
#endif
   if (Mpval(lda) < Mpval(m)) tlda = Mpval(m);
   else tlda = Mpval(lda);

   length = Mpval(m) * Mpval(n) * sizeof(SCOMPLEX);
   bp = getbuff(length);
   cmvcopy(Mpval(m), Mpval(n), A, tlda, bp->Buff);
   Asend2dID(ctxt, bp, length, Mpval(rdest), Mpval(cdest));

/*
 * Having started the async send, update the buffers (reform links, check if
 * active buffers have become inactive, etc.)
 */
   UpdateBuffs(bp);
}  /* end of cgesd2d_ */
