#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cblacs_gridinfo(int ConTxt, int *nprow, int *npcol, int *myrow, int *mycol)
#else
void blacs_gridinfo_(int *ConTxt, int *nprow, int *npcol, int *myrow, int *mycol)
#endif
{
   extern BLACSCONTEXT **MyConTxts00;
   extern int MaxNCtxt00;
   BLACSCONTEXT *ctxt;
/*
 * Make sure context handle is in range
 */
   if ( (Mpval(ConTxt) >= 0) && (Mpval(ConTxt) < MaxNCtxt00) )
   {
/*
 *    Make sure context is still defined
 */
      ctxt = MyConTxts00[Mpval(ConTxt)];
      if (ctxt != NULL)
      {
         *nprow = ctxt->nprow;
         *npcol = ctxt->npcol;
         *myrow = ctxt->myrow;
         *mycol = ctxt->mycol;
      }
      else *nprow = *npcol = *myrow = *mycol = -1;
   }
   else *nprow = *npcol = *myrow = *mycol = -1;
}
