#include "Bdef.h"
/***************************************************************************
 *  The sp1 implements globally blocking sends.  I.e., a send blocks until *
 *  the dest. node issues a recv.  The BLACS assume locally-blocking sends.*
 *  Therefore, the BLACS must fake locally-blocking sends.  To do this     *
 *  requires an indeterminate number of buffers and the use of             *
 *  non-blocking sends.  However, it is very important that even though I  *
 *  provide a dynamic number of buffers, that getting these buffers does   *
 *  not take too long in the critical part of a send operation.            *
 *  Therefore, the buffer management is broken into two routines.          *
 *									   *
 *  Inside the BLACS there are two states a buffer may be in.  If the buff *
 *  is currently being used (for instance, an asynchronous send is coming  *
 *  from it), it is classified as an ACTIVE buffer, and is on the active   *
 *  buffer queue.  Otherwise, a buffer is READY: it is not being used      *
 *  and is available for the next buffer operation.                        *
 *  In order to avoid buffer proliferation, only one ready buffer is kept, *
 *  and as active buffers become inactive they either become the ready     *
 *  buffer, or are freed.						   *
 *  									   *
 *  The first routine, getbuff, checks if the ready buffer is big enough   *
 *  to fulfill the buffer request.  If not, the present ready buffer is    *
 *  is freed, and a new buffer of the required length is allocated.  If    *
 *  the buffer is of sufficent size already, no action is taken.           *
 *  This routine is purposely very short, as it is called at the beginning *
 *  of each broadcast/send operation.  All participating nodes             *
 *  are waiting on the source node, so this routine must be very cheap.	   *
 *									   *
 *  The second routine, UpdateBuffs, moves the ready buffer to the active  *
 *  buffer queue (if needed).  It also checks the entire active buffer     *
 *  queue to see if any have finished their operations.  If so, they are   *
 *  are either moved to the ready buff, or freed.  This routine is called  *
 *  AFTER the send/broadcast has been started, and thus I am free to make  *
 *  it a little more complex.						   *
 ***************************************************************************/

BLACBUFF *getbuff(int length)
{
   void emergency_buff(int length);

   char *cptr;
   int i;
   extern int Np00;
   extern BLACBUFF *ReadyB00;

/*
 * If ready buffer already exists, and is big enough, return it.  Otherwise,
 * free the buffer (if it exists) and get one of correct size
 */
   if (ReadyB00)
   {
      if (ReadyB00->Len >= length) return(ReadyB00);
      else free(ReadyB00);
   }
   i = sizeof(BLACBUFF) + Np00*sizeof(int);
   if (i % 8) i += 8 - i % 8;  /* make sure buff is on 8-byte boundary */
   cptr = malloc(i + length);
   ReadyB00 = (BLACBUFF *) cptr;

   if (ReadyB00 != NULL)
   {
      ReadyB00->nAops = 0;
      ReadyB00->Aops = (int *) &cptr[sizeof(BLACBUFF)];
      ReadyB00->Buff = &cptr[i];
      ReadyB00->Len = length;
   }
   else emergency_buff(length);

   return(ReadyB00);
}
