#include "Bdef.h"

/***************************************************************************
 *  If there is insufficient space to allocate a needed buffer, this       *
 *  routine is called.  It moniters active buffers for the time defined by *
 *  the user-changeable macro value BUFWAIT.  If in that time no active    *
 *  buffer becomes inactive, a hang is assumed, and the grid is killed.    *
 ***************************************************************************/
void emergency_buff(int length)
{
   char *cptr;
   int i;
   double Mwalltime(void);
   double t1;
   extern int Np00;
   extern BLACBUFF *ReadyB00, *ActiveQ00;

   i = sizeof(BLACBUFF) + Np00*sizeof(int);
   if (i % 8) i += 8 - i % 8;  /* make sure buff is on 8-byte boundary */
   t1 =  Mwalltime();
   while ( (ActiveQ00) && (Mwalltime() - t1 < BUFWAIT) && !(ReadyB00) )
   {
      UpdateBuffs(NULL);
      if (ReadyB00)
      {
         if (ReadyB00->Len < length)
         {
	    free(ReadyB00);
            cptr = malloc(length + i);
            ReadyB00 = (BLACBUFF *) cptr;
            if (ReadyB00)
            {
               ReadyB00->nAops = 0;
               ReadyB00->Aops = (int *) &cptr[sizeof(BLACBUFF)];
               ReadyB00->Buff = &cptr[i];
               ReadyB00->Len = length;
            }
         }
      }
   }
   if (ReadyB00 == NULL)
   {
      BlacsErr(-1, __LINE__, __FILE__, "BLACS out of buffer space");
   }
}
