#include "Bdef.h"

int Stree_br(BLACSCONTEXT *ctxt, char scope, char *buff, int length, int nbranches,
            int rsrc, int csrc)
{
   void Ssend2d00(BLACSCONTEXT *, char *, int, int, int, int);
   void Srecv2d00(BLACSCONTEXT *, char *, int, int);

   int i, j;
   int mydist;          /* my distance from src */
   int destdist;	/* the distance of the destination node */
   int vsrc, rdest, cdest, nnodes;
   int Ng, nprow, npcol, myrow, mycol;
   int msgid;

   Mgridinfo(ctxt, Ng, nprow, npcol, myrow, mycol);
   scope = Mlowcase(scope);
   switch(scope)
   {
   case 'r':
      msgid = Mrid(ctxt);
      mydist = (npcol + mycol - csrc) % npcol;
      nnodes = npcol;
      break;
   case 'c':
      msgid = Mcid(ctxt);
      mydist = (nprow + myrow - rsrc) % nprow;
      nnodes = nprow;
      break;
   case 'a':
      vsrc = Mvkpnum(ctxt, rsrc, csrc);
      msgid = Maid(ctxt);
      mydist = (Ng + ctxt->vIam - vsrc) % Ng;
      nnodes = Ng;
      break;
   default:
      return(BADSCP);
   }


/*
 * Go up to first step of tree where I send data to other nodes
 */
   for (i=nbranches; i < nnodes; i *= nbranches);
   for (i /= nbranches; (mydist%i); i /= nbranches);

   Srecv2d00(ctxt, buff, length, msgid);
/*
 * While I need to send data to others
 */
   switch(scope)
   {
   case 'r':
      while ( (i > 1) && !(mydist%i) )
      {
         i /= nbranches;
         j = 1;
         do
	 {
	    destdist = mydist + j*i;
	    if (destdist < nnodes)
               Ssend2d00(ctxt, buff, length, myrow, (csrc+destdist)%nnodes,
                         msgid);
         }
         while(++j < nbranches);
      }
      break;
   case 'c':
      while ( (i > 1) && !(mydist%i) )
      {
         i /= nbranches;
         j = 1;
         do
         {
            destdist = mydist + j*i;
            if (destdist < nnodes)
               Ssend2d00(ctxt, buff, length, (rsrc+destdist)%nnodes, mycol,
                         msgid);
         }
         while(++j < nbranches);
      }
      break;
   case 'a':
      while ( (i > 1) && !(mydist%i) )
      {
         i /= nbranches;
         j = 1;
         do
         {
            destdist = mydist + j*i;
            if (destdist < nnodes)
            {
               destdist = (vsrc+destdist) % Ng;
               Mvpcoord(ctxt, destdist, rdest, cdest);
               Ssend2d00(ctxt, buff, length, rdest, cdest, msgid);
            }
         }
         while(++j < nbranches);
      }
      break;
   }
   return(0);	/* error free return */
} /* end Stree_br */
