!              Automatically Tuned Linear Algebra Software v3.5.9
!                     (C) Copyright 2002 R. Clint Whaley
!
!  Redistribution and use in source and binary forms, with or without
!  modification, are permitted provided that the following conditions
!  are met:
!    1. Redistributions of source code must retain the above copyright
!       notice, this list of conditions and the following disclaimer.
!    2. Redistributions in binary form must reproduce the above copyright
!       notice, this list of conditions, and the following disclaimer in the
!       documentation and/or other materials provided with the distribution.
!    3. The name of the ATLAS group or the names of its contributers may
!       not be used to endorse or promote products derived from this
!       software without specific written permission.
!
!  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
!  ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
!  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
!  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ATLAS GROUP OR ITS CONTRIBUTORS
!  BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
!  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
!  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
!  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
!  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
!  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
!  POSSIBILITY OF SUCH DAMAGE.
!

#if !defined(KB)
   #define ATL_NEED_K_TEST
#elif (KB == 0) || (KB == 2)
   #define ATL_NEED_K_TEST
#endif
#if defined(SCPLX) || defined(DCPLX)
   #define TCPLX
#endif
#ifndef ATL_GAS_SPARC
   #error "This kernel requires sparc assembler!"
#endif

#ifdef TCPLX
   #define incCm 32
#else
   #define incCm 16
#endif
!
!  Here's the register mappings of note:
!
!   #        F       I       O       L       G
!  --   ------  ------  ------  ------  ------
!   0   A[0]     pA0       stM     pC0
!   1   A[1]     pB1       stN     pC1
!   2   A[NB]    KB*4      stK     pC2
!   3   A[NB+1]  KB2*4 mb*kb*4     pC3
!   4   A[NB2]   KB3*4 ldc*4*4  4(kb-2)
!   5   A[NB2+1] KB4*4   incCn
!   6   A[NB3]   ------  ------
!   7   A[NB3+1]
!   8   B[0]
!   9   B[1]                    ------
!  10   B[NB]
!  11   B[NB+1]
!
!       %f[12-15] <--> m[0-3]  (mul results for pipelining)
!       %f[16-31] <--> c00 ... c33, in col-major order
!       %f[62-63] <--> beta
!
! NOTE: incAm=NB3*4, incBm=-NB*4, incBn=NB4*4
!
	.section	".text"
	.align 8
	.global ATL_USERMM
ATL_USERMM:
	save	%sp, (-104), %sp
#ifdef BETA0
	ld	[%fp+100], %f16
#endif
!
!       temporarily set stM = mb, stN = nb
!
	mov	%i0, %o0
	mov	%i1, %o1
!
!       init pA0, pB0, and set i[2-5] = KB[1-4]*sizeof
!
	mov	%i4, %i0
	ld 	[%fp+92], %i1
	sll	%i2, 2, %i2
	add	%i2, %i2, %i3
	add	%i2, %i3, %i4
	add	%i2, %i4, %i5
!
!       o3 = mb*kb*sizeof();
!
	smul	%o0, %i2, %o3
!
!       o4 = ldc * sizeof
!
	ld	[%fp+108], %o4
#ifdef TCPLX
	sll	%o4, 3, %o4
#else
	sll	%o4, 2, %o4
#endif
!
!       o5 = ldc*size*4 - mb*size
!
#ifdef TCPLX
	sll	%o0, 3, %o5
#else
	sll	%o0, 2, %o5
#endif
	sll	%o4, 2, %l4
	sub	%l4, %o5, %o5
!
!       l[0-3] = pC[0-3]
!
	ld	[%fp+104], %l0
	add	%l0, %o4, %l1
	add	%l1, %o4, %l2
	add	%l2, %o4, %l3
!
!       stM = A + mb*kb*sizeof
!
	add	%i0, %o3, %o0
!
!       stN = B + nb * kb * sizeof()
!
        smul	%o1, %i2, %o1
	add	%i1, %o1, %o1
!
!       l4 = (KB-2)*sizeof
!
	sub	%i2, 8, %l4
NLOOP:
!
!       o2 <- stK = pB0 + NB - 2
!
	add	%i1, %l4, %o2
MLOOP:
!
!       Load C[0..3][0..3] into f16-32
!
   #ifdef BETA0
        fsubs	%f16, %f16, %f16
        fmovs	%f16, %f17
        fmovs	%f16, %f18
        fmovs	%f16, %f19
        fmovs	%f16, %f20
        fmovs	%f16, %f21
        fmovs	%f16, %f22
        fmovs	%f16, %f23
        fmovs	%f16, %f24
        fmovs	%f16, %f25
        fmovs	%f16, %f26
        fmovs	%f16, %f27
        fmovs	%f16, %f28
        fmovs	%f16, %f29
        fmovs	%f16, %f30
        fmovs	%f16, %f31
   #else
      #ifdef BETAX
	ld	[%fp+100], %f15
      #endif
      #ifdef TCPLX
	ld	[%l0], %f16
	ld	[%l0+8], %f17
	ld	[%l0+16], %f18
	ld	[%l0+24], %f19
	ld	[%l1], %f20
	ld	[%l1+8], %f21
	ld	[%l1+16], %f22
	ld	[%l1+24], %f23
	ld	[%l2], %f24
	ld	[%l2+8], %f25
	ld	[%l2+16], %f26
	ld	[%l2+24], %f27
	ld	[%l3], %f28
	ld	[%l3+8], %f29
	ld	[%l3+16], %f30
	ld	[%l3+24], %f31
      #else
	ld	[%l0], %f16
	ld	[%l0+4], %f17
	ld	[%l0+8], %f18
	ld	[%l0+12], %f19
	ld	[%l1], %f20
	ld	[%l1+4], %f21
	ld	[%l1+8], %f22
	ld	[%l1+12], %f23
	ld	[%l2], %f24
	ld	[%l2+4], %f25
	ld	[%l2+8], %f26
	ld	[%l2+12], %f27
	ld	[%l3], %f28
	ld	[%l3+4], %f29
	ld	[%l3+8], %f30
	ld	[%l3+12], %f31
      #endif
      #ifdef BETAX
	fmuls	%f15, %f16, %f16
	fmuls	%f15, %f17, %f17
	fmuls	%f15, %f18, %f18
	fmuls	%f15, %f19, %f19
	fmuls	%f15, %f20, %f20
	fmuls	%f15, %f21, %f21
	fmuls	%f15, %f22, %f22
	fmuls	%f15, %f23, %f23
	fmuls	%f15, %f24, %f24
	fmuls	%f15, %f25, %f25
	fmuls	%f15, %f26, %f26
	fmuls	%f15, %f27, %f27
	fmuls	%f15, %f28, %f28
	fmuls	%f15, %f29, %f29
	fmuls	%f15, %f30, %f30
	fmuls	%f15, %f31, %f31
      #endif
   #endif
!
!       Start pipeline; first load A & B, then perform mults
!
        ldd	[%i0], %f0
	ldd	[%i1], %f8
        ldd	[%i0+%i2], %f2
        ldd	[%i0+%i3], %f4
        ldd	[%i0+%i4], %f6
	ldd	[%i1+%i2], %f10
	fmuls	%f0, %f8, %f12
#ifdef ATL_NEED_K_TEST
        subcc	%i2, 8, %g0
#endif
	fmuls	%f2, %f8, %f13
	fmuls	%f4, %f8, %f14
#ifdef ATL_NEED_K_TEST
        bz	DRAIN
	fmuls	%f6, %f8, %f15
#else
	fmuls	%f6, %f8, %f15
#endif
KLOOP:
!
!       rC00 += m0;  m0 = rA0 * rB1;
!       rC10 += m1;  m1 = rA1 * rB1;
!       rC20 += m2;  m2 = rA2 * rB1;
!       rC30 += m3;  m3 = rA3 * rB1;
!
	fadds	%f16, %f12, %f16
	fmuls	%f0,  %f10, %f12
	fadds	%f17, %f13, %f17
	fmuls	%f2,  %f10, %f13
	fadds	%f18, %f14, %f18
	fmuls	%f4,  %f10, %f14
	fadds	%f19, %f15, %f19
	fmuls	%f6,  %f10, %f15
!
!       rC01 += m0;  m0 = ra0 * rb0;
!       rC11 += m1;  m1 = ra1 * rb0;
!       rC21 += m2;  m2 = ra2 * rb0;
!       rC31 += m3;  m3 = ra3 * rb0;
!
	fadds	%f20, %f12, %f20
	fmuls	%f1,  %f9,  %f12
	fadds	%f21, %f13, %f21
	fmuls	%f3,  %f9,  %f13
	fadds	%f22, %f14, %f22
	fmuls	%f5,  %f9,  %f14
	fadds	%f23, %f15, %f23
	fmuls	%f7,  %f9,  %f15
	ldd	[%i1+%i3], %f8
!
!       rC00 += m0;  m0 = ra0 * rb1;
!       rC10 += m1;  m1 = ra1 * rb1;
!       rC20 += m2;  m2 = ra2 * rb1;
!       rC30 += m3;  m3 = ra3 * rb1;
!
	fadds	%f16, %f12, %f16
	fmuls	%f1,  %f11, %f12
	fadds	%f17, %f13, %f17
	fmuls	%f3,  %f11, %f13
	fadds	%f18, %f14, %f18
	fmuls	%f5,  %f11, %f14
	fadds	%f19, %f15, %f19
	fmuls	%f7,  %f11, %f15
	ldd	[%i1+%i4], %f10
!
!       rB0 = pB[NB2];   rB1 = pB[NB3];
!       rb0 = pB[NB2+1]; rb1 = pB[NB3+1];
!       pA0 += 2;        pB0 += 2;
!

!
!       rC01 += m0;  m0 = rA0 * rB0;
!       rC11 += m1;  m1 = rA1 * rB0;
!       rC21 += m2;  m2 = rA2 * rB0;
!       rC31 += m3;  m3 = rA3 * rB0;
!
	fadds	%f20, %f12, %f20
	fmuls	%f0,  %f8,  %f12
	add     %i0, 8, %i0
	fadds	%f21, %f13, %f21
	fmuls	%f2,  %f8,  %f13
	add     %i1, 8, %i1
	fadds	%f22, %f14, %f22
	fmuls	%f4,  %f8,  %f14
	fadds	%f23, %f15, %f23
	fmuls	%f6,  %f8,  %f15
!
!       rC02 += m0;  m0 = rA0 * rB1;
!       rC12 += m1;  m1 = rA1 * rB1;
!       rC22 += m2;  m2 = rA2 * rB1;
!       rC32 += m3;  m3 = rA3 * rB1;
!
	fadds	%f24, %f12, %f24
	fmuls	%f0,  %f10, %f12
	fadds	%f25, %f13, %f25
	fmuls	%f2,  %f10, %f13
	fadds	%f26, %f14, %f26
	fmuls	%f4,  %f10, %f14
	fadds	%f27, %f15, %f27
	fmuls	%f6,  %f10, %f15

!
!       rC03 += m0;  m0 = ra0 * rb0;
!       rC13 += m1;  m1 = ra1 * rb0;
!       rC23 += m2;  m2 = ra2 * rb0;
!       rC33 += m3;  m3 = ra3 * rb0;
!
	fadds	%f28, %f12, %f28
	fmuls	%f1,  %f9,  %f12
	fadds	%f29, %f13, %f29
	fmuls	%f3,  %f9,  %f13
	fadds	%f30, %f14, %f30
	fmuls	%f5,  %f9,  %f14
	fadds	%f31, %f15, %f31
	fmuls	%f7,  %f9,  %f15
	ldd	[%i1], %f8
!
!       rC02 += m0;  m0 = ra0 * rb1;
!       rC12 += m1;  m1 = ra1 * rb1;
!       rC22 += m2;  m2 = ra2 * rb1;
!       rC32 += m3;  m3 = ra3 * rb1;
!
	fadds	%f24, %f12, %f24
	fmuls	%f1,  %f11, %f12
        ldd	[%i0], %f0
	fadds	%f25, %f13, %f25
	fmuls	%f3,  %f11, %f13
        ldd	[%i0+%i2], %f2
	fadds	%f26, %f14, %f26
	fmuls	%f5,  %f11, %f14
        ldd	[%i0+%i3], %f4
	fadds	%f27, %f15, %f27
	fmuls	%f7,  %f11, %f15
        ldd	[%i0+%i4], %f6

!
!       Load both A & B
!

!
!       rC03 += m0;  m0 = rA0 * rB0;
!       rC13 += m1;  m1 = rA1 * rB0;
!       rC23 += m2;  m2 = rA2 * rB0;
!       rC33 += m3;  m3 = rA3 * rB0;
!
	fadds	%f28, %f12, %f28
	fmuls	%f0,  %f8,  %f12
	ldd	[%i1+%i2], %f10
	fadds	%f29, %f13, %f29
	fmuls	%f2,  %f8,  %f13
	fadds	%f30, %f14, %f30
	fmuls	%f4,  %f8,  %f14
	subcc	%i1, %o2, %g0
	fadds	%f31, %f15, %f31
	fmuls	%f6,  %f8,  %f15
!
!       while (pB0 != stK)
!
	bnz	KLOOP
	nop
!
!       Drain pipe, then store to C, etc etc etc
!
DRAIN:
!
!       rC00 += m0;  m0 = rA0 * rB1;
!       rC10 += m1;  m1 = rA1 * rB1;
!       rC20 += m2;  m2 = rA2 * rB1;
!       rC30 += m3;  m3 = rA3 * rB1;
!
	fadds	%f16, %f12, %f16
	fmuls	%f0,  %f10, %f12
	fadds	%f17, %f13, %f17
	fmuls	%f2,  %f10, %f13
	fadds	%f18, %f14, %f18
	fmuls	%f4,  %f10, %f14
	fadds	%f19, %f15, %f19
	fmuls	%f6,  %f10, %f15
!
!       rC01 += m0;  m0 = ra0 * rb0;
!       rC11 += m1;  m1 = ra1 * rb0;
!       rC21 += m2;  m2 = ra2 * rb0;
!       rC31 += m3;  m3 = ra3 * rb0;
!
	fadds	%f20, %f12, %f20
	fmuls	%f1,  %f9,  %f12
	fadds	%f21, %f13, %f21
	fmuls	%f3,  %f9,  %f13
	fadds	%f22, %f14, %f22
	fmuls	%f5,  %f9,  %f14
	fadds	%f23, %f15, %f23
	fmuls	%f7,  %f9,  %f15
!
!       rC00 += m0;  m0 = ra0 * rb1;
!       rC10 += m1;  m1 = ra1 * rb1;
!       rC20 += m2;  m2 = ra2 * rb1;
!       rC30 += m3;  m3 = ra3 * rb1;
!
	fadds	%f16, %f12, %f16
	fmuls	%f1,  %f11, %f12
	fadds	%f17, %f13, %f17
	fmuls	%f3,  %f11, %f13
	fadds	%f18, %f14, %f18
	fmuls	%f5,  %f11, %f14
	fadds	%f19, %f15, %f19
	fmuls	%f7,  %f11, %f15
!
!       rB0 = pB[NB2];   rB1 = pB[NB3];
!       rb0 = pB[NB2+1]; rb1 = pB[NB3+1];
!       pA0 += incAm;        pB0 += incBm;
!
	ldd	[%i1+%i3], %f8
	ldd	[%i1+%i4], %f10
	add     %i0, 8, %i0
	add	%i0, %i4, %i0
	add     %i1, 8, %i1
	sub	%i1, %i2, %i1

!
!       rC01 += m0;  m0 = rA0 * rB0;
!       rC11 += m1;  m1 = rA1 * rB0;
!       rC21 += m2;  m2 = rA2 * rB0;
!       rC31 += m3;  m3 = rA3 * rB0;
!
	fadds	%f20, %f12, %f20
	fmuls	%f0,  %f8,  %f12
	fadds	%f21, %f13, %f21
	fmuls	%f2,  %f8,  %f13
	fadds	%f22, %f14, %f22
	fmuls	%f4,  %f8,  %f14
	fadds	%f23, %f15, %f23
	fmuls	%f6,  %f8,  %f15
!
!       rC02 += m0;  m0 = rA0 * rB1;
!       rC12 += m1;  m1 = rA1 * rB1;
!       rC22 += m2;  m2 = rA2 * rB1;
!       rC32 += m3;  m3 = rA3 * rB1;
!
	fadds	%f24, %f12, %f24
	fmuls	%f0,  %f10, %f12
	fadds	%f25, %f13, %f25
	fmuls	%f2,  %f10, %f13
	fadds	%f26, %f14, %f26
	fmuls	%f4,  %f10, %f14
	fadds	%f27, %f15, %f27
	fmuls	%f6,  %f10, %f15

!
!       rC03 += m0;  m0 = ra0 * rb0;
!       rC13 += m1;  m1 = ra1 * rb0;
!       rC23 += m2;  m2 = ra2 * rb0;
!       rC33 += m3;  m3 = ra3 * rb0;
!
	fadds	%f28, %f12, %f28
	fmuls	%f1,  %f9,  %f12
	fadds	%f29, %f13, %f29
	fmuls	%f3,  %f9,  %f13
	fadds	%f30, %f14, %f30
	fmuls	%f5,  %f9,  %f14
	fadds	%f31, %f15, %f31
	fmuls	%f7,  %f9,  %f15
!
!       rC02 += m0;  m0 = ra0 * rb1;
!       rC12 += m1;  m1 = ra1 * rb1;
!       rC22 += m2;  m2 = ra2 * rb1;
!       rC32 += m3;  m3 = ra3 * rb1;
!
	fadds	%f24, %f12, %f24
	fmuls	%f1,  %f11, %f12
	fadds	%f25, %f13, %f25
	fmuls	%f3,  %f11, %f13
	fadds	%f26, %f14, %f26
	fmuls	%f5,  %f11, %f14
	fadds	%f27, %f15, %f27
	fmuls	%f7,  %f11, %f15
!
!       rC03 += m0;
!       rC13 += m1;
!       rC23 += m2;
!       rC33 += m3;
!
	fadds	%f28, %f12, %f28
	fadds	%f29, %f13, %f29
	fadds	%f30, %f14, %f30
	fadds	%f31, %f15, %f31
!
!       store answer back to C
!
   #ifdef TCPLX
	st	%f16, [%l0]
	st	%f17, [%l0+8]
	st	%f18, [%l0+16]
	st	%f19, [%l0+24]

	st	%f20, [%l1]
	st	%f21, [%l1+8]
	st	%f22, [%l1+16]
	st	%f23, [%l1+24]

	st	%f24, [%l2]
	st	%f25, [%l2+8]
	st	%f26, [%l2+16]
	st	%f27, [%l2+24]

	st	%f28, [%l3]
	st	%f29, [%l3+8]
	st	%f30, [%l3+16]
	st	%f31, [%l3+24]
   #else
	st	%f16, [%l0]
	st	%f17, [%l0+4]
	st	%f18, [%l0+8]
	st	%f19, [%l0+12]

	st	%f20, [%l1]
	st	%f21, [%l1+4]
	st	%f22, [%l1+8]
	st	%f23, [%l1+12]

	st	%f24, [%l2]
	st	%f25, [%l2+4]
	st	%f26, [%l2+8]
	st	%f27, [%l2+12]

	st	%f28, [%l3]
	st	%f29, [%l3+4]
	st	%f30, [%l3+8]
	st	%f31, [%l3+12]
   #endif
!
!       pC[0-3] += incCm
!
	add	%l0, incCm, %l0
	add	%l1, incCm, %l1
	add	%l2, incCm, %l2
!
!       while (pA0 != stM)
!
	subcc	%i0, %o0, %g0
	bnz	MLOOP
	add	%l3, incCm, %l3
!
!	pC[0-3] += incCn; p[A,B]0 += inc[A,B]n;
!
	sub	%i0, %o3, %i0
	add	%i1, %i5, %i1
	add	%l0, %o5, %l0
	add	%l1, %o5, %l1
	subcc	%i1, %o1, %g0
	add	%l2, %o5, %l2
!
!	while (pB0 != stN)
!
	bnz	NLOOP
	add	%l3, %o5, %l3

	ret
	restore
#if 0
	.section	".rodata"
	.type, kstr,#object
	.type, mstr,#object
	.type, nstr,#object
kstr:
	.asciz  "pB0 = %lu, stK = %lu\n"
mstr:
	.asciz  "pA0 = %lu, stM = %lu\n"
nstr:
	.asciz  "pB0 = %lu, stN = %lu\n"
!==================================================
	sethi	%hi(nstr), %g1
	or	%lo(nstr),%g1,%g1
	mov	%i1, %g2
	mov	%o1, %g3
        save    %sp,(-96), %sp
	mov	%g1,%o0
	mov	%g2,%o1
	mov	%g3,%o2
	call printf,3
	nop
	restore
!==================================================
#endif

#undef incCm
#ifdef ATL_NEED_K_TEST
   #undef ATL_NEED_K_TEST
#endif
#ifdef TCPLX
   #undef TCPLX
#endif
