/*
 *             Automatically Tuned Linear Algebra Software v3.5.6
 *                    (C) Copyright 2003 R. Clint Whaley
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *   1. Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *   2. Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions, and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *   3. The name of the ATLAS group or the names of its contributers may
 *      not be used to endorse or promote products derived from this
 *      software without specific written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE ATLAS GROUP OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 */
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>

#include "atlas_misc.h"
#include "atlas_lvl3.h"
#include "atlas_tst.h"
#include "cblas.h"
#include "atlas_pkblas.h"

void Mjoin(PATL,gpmm)
   (const enum PACK_UPLO UA, const enum PACK_TRANS TA,
    const enum PACK_UPLO UB, const enum PACK_TRANS TB, const enum PACK_UPLO UC,
    const int M, const int N, const int K, const double alpha,
    const double *A, const int IA, const int JA, const int lda,
    const double *B, const int IB, const int JB, const int ldb,
    const double beta, double *C, const int IC, const int JC,
    const int ldc)
{
   double *pA, *pB, *pC;
   void ge2tp(const enum PACK_UPLO uplo, int M, int N, const TYPE *A, int lda,
              TYPE *P, int ldp);
   void tp2ge(const enum PACK_UPLO uplo, int M, int N, const TYPE *P, int ldp,
              TYPE *A, int lda);

   if (UA != PackGen)
   {
      pA = malloc(lda*lda*ATL_sizeof);
      assert(pA);
      tp2ge(UA, lda, lda, A, lda, pA, lda);
   }
   else pA = (TYPE*) A;
   if (UB != PackGen)
   {
      pB = malloc(ldb*ldb*ATL_sizeof);
      assert(pB);
      tp2ge(UB, ldb, ldb, B, ldb, pB, ldb);
   }
   else pB = (TYPE*) B;
   if (UC != PackGen)
   {
      pC = malloc(ldc*ldc*ATL_sizeof);
      assert(pC);
      tp2ge(UC, ldc, ldc, C, ldc, pC, ldc);
   }
   else pC = (TYPE*) C;
/*   if (UA == PackGen && UB == PackGen && UC == PackGen) */
   Mjoin(PATL,gemm)(TA, TB, M, N, K, alpha, pA+IA+JA*lda, lda, pB+IB+JB*ldb,
                    ldb, beta, pC+IB+JB*ldc, ldc);
   if (pC != C)
      ge2tp(UC, ldc, ldc, pC, ldc, C, ldc);
}

