    /*        Fast GEMM routine for Alpha                  */
    /*           Linux, Digital UNIX and NT/Alpha          */
    /*        by Kazushige Goto <goto@statabo.rim.or.jp>   */


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/times.h>
#include <sys/time.h>
#include <time.h>
#include "common.h"
#include "bmcommon.h"

int main(int argc, char *argv[]){

  FLOAT *a, *b, *c, *d;
  int i, j, errcount;
  int m, n, k;
  int nrowa, nrowb;
  int transa, transb;
  complex_t alpha = {3.0, 4.0};
  complex_t beta  = {1.0, 0.0};
  int size;
  int only_beta = 4;

  fprintf(stderr, "\n\tMatrix-Matrix Multiply"
#ifdef DGEMM
	  "(Double Precision, Complex) "
#else
	  "(Single Precision, Complex) "
#endif
	  "Check Routine\n"
	          "\t\t\t by Kazushige Goto <goto@statabo.rim.or.jp>\n\n");

  argc--;argv++; 
  size = 400;
  if (argc > 0) { size      = atol(*argv);argc--; argv++;}
  if (argc > 0) { alpha.r   = atof(*argv);argc--; argv++;}
  if (argc > 0) { alpha.i   = atof(*argv);argc--; argv++;}
  if (argc > 0) { beta.r    = atof(*argv);argc--; argv++;}
  if (argc > 0) { beta.i    = atof(*argv);argc--; argv++;}
  if (argc > 0) { only_beta = atof(*argv);argc--; argv++;}

  fprintf(stderr, "\tSize = %4d\n", size);
  fprintf(stderr, "\tAlpha = (%e,%e) Beta = (%e,%e)\n\n",
	  alpha.r, alpha.i, beta.r, beta.i);

  if (( a=(FLOAT *)malloc(sizeof(FLOAT) * size * size * 2)) == NULL){
    fprintf(stderr,"Out of Memory!!\n");exit(1);
  }
 
  if (( b=(FLOAT *)malloc(sizeof(FLOAT) * size * size * 2)) == NULL){
    fprintf(stderr,"Out of Memory!!\n");exit(1);
  }
  
  if (( c=(FLOAT *)malloc(sizeof(FLOAT) * size * size * 2)) == NULL){
    fprintf(stderr,"Out of Memory!!\n");exit(1);
  }

  if (( d=(FLOAT *)malloc(sizeof(FLOAT) * size * size * 2)) == NULL){
    fprintf(stderr,"Out of Memory!!\n");exit(1);
  }
  
  srandom(getpid());

  for(i = 0; i < size; i++) for(j = 0; j < size * 2; j++){
    a[i*size*2 +j] = rand() / ((double) RAND_MAX + 1.0 )*10.0;
    b[i*size*2 +j] = rand() / ((double) RAND_MAX + 1.0 )*10.0; 
    c[i*size*2 +j] = rand() / ((double) RAND_MAX + 1.0 )*10.0;
    d[i*size*2 +j] = c[i*size*2+j];
  }

  for(m = 1; m <= size; m++){
    for(n = 1; n <= size; n++){
      for(k = 1; k <= size; k++){

	m = k;
	n = k;

	fprintf(stderr, "m = %3d n = %3d k = %3d : ", m, n, k);

	for (transa=0; transa < only_beta; transa++){
	  for (transb=0; transb < only_beta; transb++){

	    if (transa == 0 || transa == 2) nrowa = m; else nrowa = k;
	    if (transb == 0 || transb == 2) nrowb = k; else nrowb = n;

	    if ((m >= nrowa) && (n >= nrowb)  && (k >= m)){

	      for(i = 0; i < m; i++) for(j = 0; j < n * 2; j++){
		c[i*n*2 +j] = rand() / ((double) RAND_MAX + 1.0 )*10.0;
		d[i*n*2 +j] = c[i*n*2+j];
	      }

	      ZGEMMC_(trans[transa], trans[transb], &m, &n, &k, 
		      &alpha.r, a, &m, b, &n, &beta.r, c, &k);

	      ZGEMM_ (trans[transa], trans[transb], &m, &n, &k, 
		      &alpha.r, a, &m, b, &n, &beta.r, d, &k);
	      
	      errcount = 0;
	      for(i = 0; i < size; i++){
		for(j = 0;j < size*2; j++){
		  if (diffs(c[i*size*2+j], d[i*size*2+j])){
		    if (!errcount) fprintf(stderr,"\n");
		    fprintf(stderr, "%3d %3d :%6.1f %6.1f\n",
			    i, j, c[i*size*2 +j], d[i*size*2+j]);
		    errcount ++;
		    if (errcount > 1) exit(1);
		  }
		}
	      }
	      fprintf(stderr, "G ");
	    } else {
	      fprintf(stderr, "S ");
	    }
	  }
	}
	fprintf(stderr, "\n");
      }
    }
  }
  
  free(a);
  free(b);
  free(c);
  free(d);
  return 0;
}
